/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.security.AccessController;
import javax.naming.NamingException;
import weblogic.jms.saf.SAFAgentDeployer;
import weblogic.jms.saf.SAFService;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFLogger;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFServerService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;

public final class SAFServiceAdmin
implements GenericAdminHandler {
    private SAFAgentDeployer jmsSAFAgentDeployer = SAFService.getSAFService().getDeployer();
    private SAFServerService safService;
    private String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public SAFServiceAdmin() {
        this.safService = SAFServerService.getService();
    }

    private void addAgent(SAFAgentAdmin sAFAgentAdmin) {
        this.safService.addAgent(sAFAgentAdmin);
    }

    private SAFAgentAdmin getAgent(String string) {
        return this.safService.getAgent(string);
    }

    private void removeAgent(String string) {
        this.safService.removeAgent(string);
    }

    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        this.jmsSAFAgentDeployer.prepare(deploymentMBean);
        try {
            this.safService.checkShutdown();
        }
        catch (ServiceFailureException serviceFailureException) {
            throw new DeploymentException(serviceFailureException);
        }
        try {
            this.addAgent(new SAFAgentAdmin(this, (SAFAgentMBean)deploymentMBean));
        }
        catch (ManagementException managementException) {
            if (SAFDebug.SAFAdmin.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Error preparing SAF agent " + this.getAgentName(deploymentMBean.getName()), (Throwable)managementException);
            }
            SAFLogger.logErrorPrepareSAFAgent((String)this.getAgentName(deploymentMBean.getName()), (Exception)((Object)managementException));
            throw new DeploymentException("Error preparing SAF agent " + this.getAgentName(deploymentMBean.getName()), managementException);
        }
        SAFLogger.logSAFAgentPrepared((String)this.getAgentName(deploymentMBean.getName()));
    }

    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        this.jmsSAFAgentDeployer.activate(deploymentMBean);
        try {
            this.safService.checkShutdown();
        }
        catch (ServiceFailureException serviceFailureException) {
            throw new DeploymentException(serviceFailureException);
        }
        SAFAgentAdmin sAFAgentAdmin = this.getAgent(deploymentMBean.getName());
        if (sAFAgentAdmin == null) {
            throw new DeploymentException("Error activating SAF agent " + this.getAgentName(deploymentMBean.getName()) + ": it was not successfully prepared");
        }
        try {
            sAFAgentAdmin.start();
        }
        catch (SAFException sAFException) {
            if (SAFDebug.SAFAdmin.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Error activating SAF agent " + this.getAgentName(deploymentMBean.getName()), (Throwable)sAFException);
            }
            SAFLogger.logErrorStartSAFAgent((String)this.getAgentName(deploymentMBean.getName()), (Exception)sAFException);
            throw new DeploymentException("Error activating SAF agent " + this.getAgentName(deploymentMBean.getName()), sAFException);
        }
        catch (NamingException namingException) {
            if (SAFDebug.SAFAdmin.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Error activating SAF agent " + this.getAgentName(deploymentMBean.getName()), (Throwable)namingException);
            }
            SAFLogger.logErrorStartSAFAgent((String)this.getAgentName(deploymentMBean.getName()), (Exception)namingException);
            throw new DeploymentException("Error activating SAF agent " + this.getAgentName(deploymentMBean.getName()), namingException);
        }
        SAFLogger.logSAFAgentActivated((String)this.getAgentName(deploymentMBean.getName()));
    }

    public void deactivate(DeploymentMBean deploymentMBean) throws UndeploymentException {
        SAFAgentAdmin sAFAgentAdmin;
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        if (SAFDebug.SAFAdmin.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("Undeploying " + deploymentMBean.getName());
        }
        if ((sAFAgentAdmin = this.getAgent(deploymentMBean.getName())) == null) {
            return;
        }
        sAFAgentAdmin.close();
        SAFLogger.logSAFAgentDeactivated((String)this.getAgentName(deploymentMBean.getName()));
        this.jmsSAFAgentDeployer.deactivate(deploymentMBean);
    }

    public void unprepare(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        this.removeAgent(deploymentMBean.getName());
        SAFLogger.logSAFAgentUnprepared((String)this.getAgentName(deploymentMBean.getName()));
        this.jmsSAFAgentDeployer.unprepare(deploymentMBean);
    }

    private String getAgentName(String string) {
        return string + "@" + this.serverName;
    }
}

