/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.extensions.WLMessage;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.saf.SAFRequest;
import weblogic.utils.expressions.Expression;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.Variable;
import weblogic.utils.expressions.VariableBinder;

final class SAFVariableBinder
implements VariableBinder {
    public static final SAFVariableBinder THE_ONE = new SAFVariableBinder();
    private static final HashMap VARIABLES = new HashMap();

    SAFVariableBinder() {
    }

    public Variable getVariable(String string) {
        Variable variable = (Variable)VARIABLES.get(string);
        if (variable != null) {
            return variable;
        }
        return new JMSPropertiesVariable(string);
    }

    private static SAFRequest saf(Object object) {
        if (object instanceof SAFRequest) {
            return (SAFRequest)object;
        }
        if (object instanceof MessageElement) {
            return (SAFRequest)((MessageElement)object).getMessage();
        }
        return null;
    }

    private static WLMessage msg(Object object) {
        Externalizable externalizable;
        if (object instanceof SAFRequest && (externalizable = ((SAFRequest)object).getPayload()) instanceof WLMessage) {
            return (WLMessage)((Object)externalizable);
        }
        if (object instanceof MessageElement) {
            return (WLMessage)((MessageElement)object).getMessage();
        }
        return null;
    }

    private static Message kmsg(Object object) {
        Externalizable externalizable;
        if (object instanceof SAFRequest && (externalizable = ((SAFRequest)object).getPayload()) instanceof Message) {
            return (Message)externalizable;
        }
        if (object instanceof MessageElement) {
            return ((MessageElement)object).getMessage();
        }
        return null;
    }

    private static ExpressionEvaluationException wrapException(JMSException jMSException) throws ExpressionEvaluationException {
        ExpressionEvaluationException expressionEvaluationException = new ExpressionEvaluationException("Failed to bind variable");
        expressionEvaluationException.initCause((Throwable)jMSException);
        throw expressionEvaluationException;
    }

    static {
        VARIABLES.put("JMSDeliveryMode", new JMSDeliveryModeVariable());
        VARIABLES.put("JMSMessageID", new JMSMessageIDVariable());
        VARIABLES.put("JMSTimestamp", new JMSTimestampVariable());
        VARIABLES.put("JMSCorrelationID", new JMSCorrelationIDVariable());
        VARIABLES.put("JMSType", new JMSTypeVariable());
        VARIABLES.put("JMSPriority", new JMSPriorityVariable());
        VARIABLES.put("JMSExpiration", new JMSExpirationVariable());
        VARIABLES.put("JMSRedelivered", new JMSRedeliveredVariable());
        VARIABLES.put("JMSDeliveryTime", new JMSDeliveryTimeVariable());
        VARIABLES.put("JMSRedeliveryLimit", new JMSRedeliveryLimitVariable());
        VARIABLES.put("JMS_BEA_Size", new JMS_BEA_SizeVariable());
        VARIABLES.put("JMS_BEA_UnitOfOrder", new JMS_BEA_UnitOfOrderVariable());
        VARIABLES.put("SAFConversationName", new SAFConversationNameVariable());
        VARIABLES.put("SAFSequenceNumber", new SAFSequenceNumberVariable());
        VARIABLES.put("SAFExpiration", new SAFExpirationVariable());
        VARIABLES.put("SAFDeliveryMode", new SAFDeliveryModeVariable());
        VARIABLES.put("SAFTimestamp", new SAFTimestampVariable());
        VARIABLES.put("SAFMessageID", new SAFMessageIDVariable());
    }

    private static class SAFMessageIDVariable
    implements Variable {
        private SAFMessageIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return SAFVariableBinder.saf(object).getMessageId();
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class SAFTimestampVariable
    implements Variable {
        private SAFTimestampVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return new Long(SAFVariableBinder.saf(object).getTimestamp());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class SAFDeliveryModeVariable
    implements Variable {
        private SAFDeliveryModeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return SAFVariableBinder.saf(object).getDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class SAFExpirationVariable
    implements Variable {
        private SAFExpirationVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            if (SAFVariableBinder.saf(object).getTimeToLive() == -1L) {
                return new Long(-1L);
            }
            return new Long(SAFVariableBinder.saf(object).getTimestamp() + SAFVariableBinder.saf(object).getTimeToLive());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class SAFSequenceNumberVariable
    implements Variable {
        private SAFSequenceNumberVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return new Long(SAFVariableBinder.saf(object).getSequenceNumber());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class SAFConversationNameVariable
    implements Variable {
        private SAFConversationNameVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return SAFVariableBinder.saf(object).getConversationName();
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMS_BEA_UnitOfOrderVariable
    implements Variable {
        private JMS_BEA_UnitOfOrderVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getStringProperty("JMS_BEA_UnitOfOrder");
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMS_BEA_SizeVariable
    implements Variable {
        private JMS_BEA_SizeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return new Long(SAFVariableBinder.kmsg(object).size());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSRedeliveryLimitVariable
    implements Variable {
        private JMSRedeliveryLimitVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Integer(SAFVariableBinder.msg(object).getJMSRedeliveryLimit());
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSDeliveryTimeVariable
    implements Variable {
        private JMSDeliveryTimeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(SAFVariableBinder.msg(object).getJMSDeliveryTime());
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSRedeliveredVariable
    implements Variable {
        private JMSRedeliveredVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getJMSRedelivered();
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.BOOLEAN;
        }
    }

    private static class JMSExpirationVariable
    implements Variable {
        private JMSExpirationVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(SAFVariableBinder.msg(object).getJMSExpiration());
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSPriorityVariable
    implements Variable {
        private JMSPriorityVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Integer(SAFVariableBinder.msg(object).getJMSPriority());
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSTypeVariable
    implements Variable {
        private JMSTypeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getJMSType();
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSCorrelationIDVariable
    implements Variable {
        private JMSCorrelationIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getJMSCorrelationID();
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSTimestampVariable
    implements Variable {
        private JMSTimestampVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(SAFVariableBinder.msg(object).getJMSTimestamp());
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSMessageIDVariable
    implements Variable {
        private JMSMessageIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getJMSMessageID();
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSDeliveryModeVariable
    implements Variable {
        private JMSDeliveryModeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSPropertiesVariable
    implements Variable {
        private final String key;

        private JMSPropertiesVariable(String string) {
            this.key = string;
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return SAFVariableBinder.msg(object).getObjectProperty(this.key);
            }
            catch (JMSException jMSException) {
                throw SAFVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.ANY;
        }
    }
}

