/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.health.HealthState;
import weblogic.jms.saf.SAFService;
import weblogic.management.ManagementException;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.SAFConversationRuntimeMBean;
import weblogic.messaging.Message;
import weblogic.messaging.common.SQLFilter;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.Filter;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.QuotaException;
import weblogic.messaging.kernel.SendOptions;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.kernel.internal.KernelImpl;
import weblogic.messaging.kernel.runtime.MessagingKernelDiagnosticImageSource;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFServiceNotAvailException;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.internal.AgentImpl;
import weblogic.messaging.saf.internal.ConversationAssembler;
import weblogic.messaging.saf.internal.RemoteEndpointRuntimeDelegate;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFAgentFactoryInternal;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFVariableBinder;
import weblogic.messaging.saf.internal.SendingAgent;
import weblogic.messaging.saf.store.SAFStore;
import weblogic.messaging.saf.store.SAFStoreException;
import weblogic.messaging.saf.utils.Util;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;

public final class SendingAgentImpl
extends AgentImpl
implements SendingAgent,
Externalizable {
    static final long serialVersionUID = -2776562935951109789L;
    private HashMap conversations;
    private long conversationsCurrentCount;
    private long conversationsHighCount;
    private long conversationsTotalCount;
    private HashMap dynamicNameToName;
    private HashMap conversationsByCreateConvMsgID;
    private long failedMessagesTotal;
    private HashMap kernelTopics;
    private double retryDelayMultiplier;
    private long retryDelayBase;
    private long retryDelayMaximum;
    private long timeToLiveDefault;
    private long conversationIdleTimeMaximum;
    private boolean isLoggingEnabled;
    private int windowSize;
    private boolean isPausedForIncoming;
    private boolean isPausedForForwarding;
    private Kernel kernel;
    private Quota kernelQuota;
    private static final SAFAgentFactoryInternal agentFactoryInternal = new SAFAgentFactoryInternal();
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
    private ServerStateChangeListener stateChangeListener;

    public SendingAgentImpl() {
    }

    SendingAgentImpl(String string, SAFAgentAdmin sAFAgentAdmin, SAFStore sAFStore) throws NamingException, SAFException {
        super(string, sAFAgentAdmin, sAFStore, 1);
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + string + "': RetryDelayBase=" + this.retryDelayBase + ", RetryDelayMaximum=" + this.retryDelayMaximum + ", RetryDelayMultiplier=" + this.retryDelayMultiplier + ", ConversationIdleTimeMaximum=" + this.conversationIdleTimeMaximum + ", TimeToLive=" + this.timeToLiveDefault + ", WindowSize=" + this.windowSize);
        }
    }

    public String toString() {
        return "<SendingAgentImpl> :  SAFAgentInternalName = " + this.name + " " + this.store;
    }

    static SAFAgentFactoryInternal getAgentFactory() {
        return agentFactoryInternal;
    }

    protected synchronized void addToAgentFactory() {
        agentFactoryInternal.addAgent(this);
        safManager.addLocalSendingAgent(this);
    }

    protected void removeFromAgentFactory() {
        agentFactoryInternal.removeAgent(this);
        safManager.removeLocalSendingAgent(this);
    }

    public void setConversationInfosFromStore(HashMap hashMap) {
        this.conversationInfosFromStore = hashMap;
    }

    public void startInitialize(SAFAgentMBean sAFAgentMBean) throws SAFException {
        this.state = 1;
        this.retryDelayBase = sAFAgentMBean.getDefaultRetryDelayBase();
        this.retryDelayMultiplier = sAFAgentMBean.getDefaultRetryDelayMultiplier();
        this.retryDelayMaximum = sAFAgentMBean.getDefaultRetryDelayMaximum();
        this.timeToLiveDefault = sAFAgentMBean.getDefaultTimeToLive();
        this.conversationIdleTimeMaximum = sAFAgentMBean.getConversationIdleTimeMaximum();
        this.windowSize = sAFAgentMBean.getWindowSize();
        this.isPaused = this.isPausedForIncoming = sAFAgentMBean.isIncomingPausedAtStartup();
        this.isPausedForForwarding = sAFAgentMBean.isForwardingPausedAtStartup();
        this.isLoggingEnabled = sAFAgentMBean.isLoggingEnabled();
        this.kernel = SAFService.getSAFService().getDeployer().getAgent(sAFAgentMBean.getName()).getBackEnd().getKernel();
        this.kernelQuota = SAFService.getSAFService().getDeployer().getAgent(sAFAgentMBean.getName()).getBackEnd().getQuota();
        this.initializeMaps();
    }

    private void initializeMaps() {
        this.conversations = new HashMap();
        this.dynamicNameToName = new HashMap();
        this.kernelTopics = new HashMap();
        this.conversationsByCreateConvMsgID = new HashMap();
        if (this.conversationInfosFromStore == null) {
            this.conversationInfosFromStore = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws SAFException {
        Object object = this;
        synchronized (object) {
            if ((this.state & 6) != 0) {
                return;
            }
            this.waitForState(1);
            this.state = 2;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' has recovered " + this.conversationInfosFromStore.size() + " conversation infos");
        }
        object = this.kernel.getTopics();
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' is starting: found " + object.size() + " topics");
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Topic topic = (Topic)iterator.next();
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Topic: " + topic.getName());
            }
            if (SendingAgentImpl.isNotWSRM(topic.getName())) continue;
            try {
                topic.setProperty("Quota", (Object)this.kernelQuota);
                topic.setFilter((Filter)new SQLFilter(this.kernel, SAFVariableBinder.THE_ONE));
                this.kernelTopics.put(topic.getName(), topic);
            }
            catch (KernelException kernelException) {
                if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                    kernelException.printStackTrace();
                }
                throw new SAFException(kernelException.getMessage(), kernelException);
            }
            if (!SAFDebug.SAFVerbose.isDebugEnabled() || !SAFDebug.SAFSendingAgent.isDebugEnabled()) continue;
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': recovered topic = " + topic.getName());
        }
        int n = this.convertQueuesToTopics();
        try {
            for (SAFConversationInfo sAFConversationInfo : this.conversationInfosFromStore.values()) {
                this.findOrCreateConversation(sAFConversationInfo);
                if (!SAFDebug.SAFVerbose.isDebugEnabled() || !SAFDebug.SAFSendingAgent.isDebugEnabled()) continue;
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': recovered conversation = " + sAFConversationInfo);
            }
        }
        catch (SAFException sAFException) {
            this.healthState = SendingAgentImpl.updateHealthState(this.healthState, 3, sAFException.getMessage());
            this.close();
            SendingAgentImpl sendingAgentImpl = this;
            synchronized (sendingAgentImpl) {
                this.state = 1;
            }
            throw sAFException;
        }
        try {
            this.activateAllKernelTopics();
        }
        catch (KernelException kernelException) {
            throw new SAFException(kernelException.getMessage());
        }
        if (n > 0) {
            this.moveQueueMessagesToTopic();
        }
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            this.state = 4;
            if (this.waitersCount > 0) {
                this.notifyAll();
            }
        }
    }

    private int convertQueuesToTopics() throws SAFException {
        Collection collection = this.kernel.getQueues();
        int n = 0;
        for (Queue queue : collection) {
            if (SendingAgentImpl.isNotWSRM(queue.getName())) continue;
            ++n;
            this.kernelTopics.put(queue.getName(), this.createKernelTopic(queue.getName(), queue.getProperties()));
            if (!SAFDebug.SAFVerbose.isDebugEnabled() || !SAFDebug.SAFSendingAgent.isDebugEnabled()) continue;
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': converted queue = " + queue.getName() + " to a topic");
        }
        return n;
    }

    private void moveQueueMessagesToTopic() throws SAFException {
        Collection collection = this.kernel.getQueues();
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' is starting: move messages " + "from pre9.0.1 saf reposity to post 9.0 one ");
        }
        for (Queue queue : collection) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Queue: " + queue.getName());
            }
            if (SendingAgentImpl.isNotWSRM(queue.getName())) continue;
            try {
                MessageElement messageElement;
                Cursor cursor = queue.createCursor(true, null, -1);
                KernelRequest kernelRequest = new KernelRequest();
                while ((messageElement = cursor.next()) != null) {
                    SAFRequest sAFRequest = (SAFRequest)messageElement.getMessage();
                    String string = sAFRequest.getConversationName();
                    Queue queue2 = this.kernel.findQueue(string);
                    Sequence sequence = queue2.findSequence(string);
                    sequence.setPassthru(true);
                    SendOptions sendOptions = new SendOptions();
                    sendOptions.setPersistent(sAFRequest.getDeliveryMode() == 2);
                    sendOptions.setTimeout(0L);
                    sendOptions.setSequence(sequence);
                    sendOptions.setSequenceNum(messageElement.getSequenceNum());
                    kernelRequest = queue2.send((Message)((SAFRequestImpl)sAFRequest), sendOptions);
                }
                cursor.close();
                kernelRequest.getResult();
                kernelRequest.reset();
                queue.delete(kernelRequest);
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                    kernelException.printStackTrace();
                }
                throw new SAFException(kernelException.getMessage(), kernelException);
            }
            if (!SAFDebug.SAFVerbose.isDebugEnabled() || !SAFDebug.SAFSendingAgent.isDebugEnabled()) continue;
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': recovered messages from queue = " + queue.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAllKernelTopics() throws KernelException {
        Iterator iterator;
        Iterator iterator2;
        Object object = this;
        synchronized (object) {
            iterator2 = this.kernelTopics.values().iterator();
            iterator = this.conversations.values().iterator();
        }
        while (iterator.hasNext()) {
            Sequence sequence;
            object = ((ConversationAssembler)iterator.next()).getConversationName();
            Queue queue = this.kernel.findQueue((String)object);
            if (queue == null || (sequence = queue.findSequence((String)object)) == null || !sequence.isPassthru()) continue;
            sequence.setPassthru(false);
        }
        while (iterator2.hasNext()) {
            object = (Topic)iterator2.next();
            object.resume(16384);
        }
    }

    void send(SAFRequest sAFRequest) throws SAFException {
        if (this.isPausedForIncoming()) {
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' == send(): agent is paused for incoming");
            }
            throw new SAFServiceNotAvailException("The agent is paused for incoming messages");
        }
        this.sendInternal(sAFRequest);
    }

    private ConversationAssembler prepareSAFRequest(SAFRequest sAFRequest) throws SAFException {
        ConversationAssembler conversationAssembler;
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' prepareSAFRequest(): timestamp =" + sAFRequest.getTimestamp() + " conversationName = " + sAFRequest.getConversationName());
        }
        if (sAFRequest.getTimestamp() == -1L || sAFRequest.getTimestamp() == 0L) {
            sAFRequest.setTimestamp(System.currentTimeMillis());
        }
        if (sAFRequest.getMessageId() == null) {
            sAFRequest.setMessageId(Util.generateID().toString());
        }
        if ((conversationAssembler = this.getConversation(sAFRequest.getConversationName())) == null) {
            throw new SAFConversationNotAvailException("Failed to send a message: conversation " + sAFRequest.getConversationName() + " has never been registered.");
        }
        if (conversationAssembler.isNotAvailAndClosed()) {
            throw new SAFConversationNotAvailException("Failed to send a message: conversation " + sAFRequest.getConversationName() + " has expired or terminated," + " or has been destroyed administratively");
        }
        if (this.getRemoteEndpoint(conversationAssembler.getInfo().getDestinationURL()).isPausedForIncoming()) {
            throw new SAFException("The endpoint " + conversationAssembler.getInfo().getDestinationURL() + " is paused for incoming messages");
        }
        if (sAFRequest.getTimeToLive() == -1L) {
            sAFRequest.setTimeToLive(this.timeToLiveDefault);
        }
        return conversationAssembler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(SAFRequest sAFRequest) throws SAFException {
        Object object = this;
        synchronized (object) {
            this.waitForState(4);
        }
        object = this.prepareSAFRequest(sAFRequest);
        Topic topic = this.findKernelTopic(SendingAgentImpl.getKernelTopicName(((ConversationAssembler)object).getInfo()));
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.getName() + "': message writer about to put message " + sAFRequest.getMessageId() + " to the SAF respository, persistent = " + (sAFRequest.getDeliveryMode() == 2));
        }
        try {
            SendOptions sendOptions = new SendOptions();
            sendOptions.setPersistent(sAFRequest.getDeliveryMode() == 2);
            sendOptions.setTimeout(0L);
            KernelRequest kernelRequest = topic.send((Message)((SAFRequestImpl)sAFRequest), sendOptions);
            if (kernelRequest != null) {
                kernelRequest.getResult();
            }
        }
        catch (QuotaException quotaException) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                quotaException.printStackTrace();
            }
            throw new SAFException("Failed to save a message to SAF repository because  quota has been exceeded", quotaException);
        }
        catch (KernelException kernelException) {
            throw new SAFException("Failed to store the request to messaging kernel", kernelException);
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' == send(): Message stored: " + sAFRequest.getMessageId());
        }
    }

    private void destroyConversation(String string) {
        ConversationAssembler conversationAssembler = this.getConversation(string);
        conversationAssembler.destroy();
    }

    private void closeConversation(String string) {
        block10: {
            ConversationAssembler conversationAssembler;
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': closing conversation " + string);
            }
            if ((conversationAssembler = this.getConversation(string)) == null || conversationAssembler.isNotAvailAndClosed()) {
                return;
            }
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Anget " + this.name + " closeConversation(): " + " send a fake request with endOfConversation flag");
            }
            SAFRequestImpl sAFRequestImpl = new SAFRequestImpl();
            sAFRequestImpl.setConversationName(string);
            sAFRequestImpl.setSequenceNumber(-1L);
            sAFRequestImpl.setEndOfConversation(true);
            sAFRequestImpl.setPayload(null);
            long l = conversationAssembler.getTimeLeft();
            if (l == 0L) {
                sAFRequestImpl.setTimeToLive(100L);
            } else {
                sAFRequestImpl.setTimeToLive(l);
            }
            sAFRequestImpl.setTimestamp(System.currentTimeMillis());
            int n = string.indexOf("NonPersistent");
            if (n != -1 && n + 13 == string.length()) {
                sAFRequestImpl.setDeliveryMode(1);
            } else {
                sAFRequestImpl.setDeliveryMode(2);
            }
            try {
                this.sendInternal(sAFRequestImpl);
            }
            catch (SAFException sAFException) {
                if (!SAFDebug.SAFVerbose.isDebugEnabled() || !SAFDebug.SAFSendingAgent.isDebugEnabled()) break block10;
                sAFException.printStackTrace();
            }
        }
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' == closeConversation(): " + " after sending a fake request with endOfConversation flag");
        }
    }

    void closeConversation(String string, boolean bl) {
        if (bl) {
            this.destroyConversation(string);
            return;
        }
        this.closeConversation(string);
    }

    RemoteEndpointRuntimeDelegate getRemoteEndpoint(String string) {
        return this.agentAdmin.getRemoteEndpoint(string);
    }

    synchronized Topic getKernelTopic(SAFConversationInfo sAFConversationInfo) {
        return this.kernel.findTopic(SendingAgentImpl.getKernelTopicName(sAFConversationInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findOrCreateKernelTopic(SAFConversationInfo sAFConversationInfo) throws SAFException {
        Topic topic;
        String string = SendingAgentImpl.getKernelTopicName(sAFConversationInfo);
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' == findOrCreateKernelTopic(): " + string);
        }
        boolean bl = false;
        Kernel kernel = this.kernel;
        synchronized (kernel) {
            topic = this.findKernelTopic(string);
            if (topic == null) {
                bl = true;
                topic = this.createKernelTopic(string, null);
            }
        }
        if (bl) {
            try {
                topic.resume(16384);
            }
            catch (KernelException kernelException) {
                throw new SAFException("Cannot create reader on the topic", kernelException);
            }
        }
    }

    private Topic findKernelTopic(String string) {
        return this.kernel.findTopic(string);
    }

    private Topic createKernelTopic(String string, Map hashMap) throws SAFException {
        if (hashMap == null) {
            hashMap = new HashMap<String, Boolean>();
            hashMap.put("Durable", new Boolean(true));
            hashMap.put("Quota", (Boolean)this.kernelQuota);
        }
        try {
            Topic topic = this.kernel.createTopic(string, hashMap);
            topic.setFilter((Filter)new SQLFilter(this.kernel, SAFVariableBinder.THE_ONE));
            return topic;
        }
        catch (KernelException kernelException) {
            throw new SAFException("Cannot create kernel topic", kernelException);
        }
    }

    public void suspend(boolean bl) {
        try {
            this.close();
        }
        catch (SAFException sAFException) {
            // empty catch block
        }
    }

    public void resume() throws SAFException {
        this.start();
    }

    private void close() throws SAFException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean bl) throws SAFException {
        SendingAgentImpl sendingAgentImpl;
        Object object = this;
        synchronized (object) {
            if ((this.state & 9) != 0) {
                return;
            }
            this.waitForState(6);
            this.state = 8;
            if (this.stateChangeListener != null) {
                runtimeAccess.getServerRuntime().removePropertyChangeListener(this.stateChangeListener);
            }
        }
        try {
            Object object2;
            this.unadvertise();
            Object object3 = this;
            synchronized (object3) {
                this.conversationsCurrentCount = 0L;
                object2 = (HashMap)this.conversations.clone();
                object = ((HashMap)object2).keySet().iterator();
                this.dynamicNameToName.clear();
            }
            while (object.hasNext()) {
                object3 = (String)object.next();
                object2 = (ConversationAssembler)this.conversations.get(object3);
                if (object2 == null) continue;
                if (bl) {
                    ((ConversationAssembler)object2).delete();
                    continue;
                }
                this.removeConversation((String)object3, false);
                ((ConversationAssembler)object2).close();
            }
            this.store.close();
            Object var7_7 = null;
            sendingAgentImpl = this;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SendingAgentImpl sendingAgentImpl2 = this;
            synchronized (sendingAgentImpl2) {
                this.conversations.clear();
                this.conversationsByCreateConvMsgID.clear();
                this.state = 1;
                if (this.waitersCount > 0) {
                    this.notifyAll();
                }
            }
            throw throwable;
        }
        synchronized (sendingAgentImpl) {
            this.conversations.clear();
            this.conversationsByCreateConvMsgID.clear();
            this.state = 1;
            if (this.waitersCount > 0) {
                this.notifyAll();
            }
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending agent '" + this.name + "' has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAFConversationInfo normalizeSAFConversationInfo(SAFConversationInfo sAFConversationInfo) {
        HashMap hashMap = this.conversationInfosFromStore;
        synchronized (hashMap) {
            return (SAFConversationInfo)this.conversationInfosFromStore.get(sAFConversationInfo.getConversationName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findOrCreateConversation(SAFConversationInfo sAFConversationInfo) throws SAFException {
        SAFConversationInfo sAFConversationInfo2;
        ConversationAssembler conversationAssembler;
        if (sAFConversationInfo == null) {
            throw new IllegalArgumentException("Cannot create a conversation with null conversation info");
        }
        boolean bl = false;
        this.findOrCreateKernelTopic(sAFConversationInfo);
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            conversationAssembler = this.getConversation(sAFConversationInfo.getConversationName());
            if (conversationAssembler != null) {
                if (conversationAssembler.isNotAvailAndClosed()) {
                    throw new SAFConversationNotAvailException("Conversation " + sAFConversationInfo.getConversationName() + " has expired" + " or has been terminated or destroyed");
                }
                SAFConversationInfo sAFConversationInfo3 = conversationAssembler.getInfo().getConversationOffer();
                if (sAFConversationInfo3 != sAFConversationInfo.getConversationOffer()) {
                    throw new SAFException(" Illegal usage of SAFConversation. Offer = " + sAFConversationInfo3 + " in SAFConversation already registered with the Sending Agent" + " does not match the current offer = " + sAFConversationInfo.getConversationOffer());
                }
                return false;
            }
            SAFConversationInfo sAFConversationInfo4 = this.normalizeSAFConversationInfo(sAFConversationInfo);
            if (sAFConversationInfo4 == null) {
                if (((SAFConversationInfoImpl)sAFConversationInfo).getTimestamp() == 0L) {
                    ((SAFConversationInfoImpl)sAFConversationInfo).setTimestamp(System.currentTimeMillis());
                }
                bl = true;
            }
            sAFConversationInfo2 = sAFConversationInfo4 != null ? sAFConversationInfo4 : sAFConversationInfo;
            String string = sAFConversationInfo2.getConversationName();
            try {
                conversationAssembler = new ConversationAssembler(this, sAFConversationInfo2, this.store, this.isLoggingEnabled, this.windowSize);
                this.addConversation(conversationAssembler);
            }
            catch (ManagementException managementException) {
                if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                    managementException.printStackTrace();
                    SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': failed to create a new conversation runtime MBean " + string);
                }
                throw new SAFException("Sending Agent '" + this.name + " Failed to create runtime MBEan for conversation " + string);
            }
        }
        conversationAssembler.setupSubscriptionQueue();
        safManager.addLocalSendingAgentId(sAFConversationInfo, this);
        safManager.addConversationInfoOnSendingSide(sAFConversationInfo);
        if (sAFConversationInfo2.getDynamicConversationName() != null && !sAFConversationInfo2.getDynamicConversationName().equals(sAFConversationInfo2.getConversationName())) {
            conversationAssembler.createAndRecordDynamicConversation(sAFConversationInfo2.getConversationName(), sAFConversationInfo2.getDynamicConversationName());
        }
        if (T3Srvr.getT3Srvr().getRunState() == 2) {
            conversationAssembler.startFromADiffThread();
        } else {
            sendingAgentImpl = this;
            synchronized (sendingAgentImpl) {
                if (this.stateChangeListener == null) {
                    this.stateChangeListener = new ServerStateChangeListener();
                    runtimeAccess.getServerRuntime().addPropertyChangeListener(this.stateChangeListener);
                }
            }
        }
        return bl;
    }

    RemoteEndpointRuntimeDelegate findOrCreateRemoteEndpointRuntime(String string, int n, Topic topic) throws ManagementException {
        return this.agentAdmin.findOrCreateRemoteEndpointRuntime(string, n, topic);
    }

    synchronized void addDynamicName(String string, String string2) {
        this.dynamicNameToName.put(string2, string);
        this.addConversation(string2, this.getConversation(string));
    }

    private synchronized String getOrginalName(String string) {
        return (String)this.dynamicNameToName.get(string);
    }

    private void addConversation(ConversationAssembler conversationAssembler) {
        if (this.conversations.get(conversationAssembler.getName()) == null) {
            ++this.conversationsCurrentCount;
            ++this.conversationsTotalCount;
            if (this.conversationsCurrentCount > this.conversationsHighCount) {
                this.conversationsHighCount = this.conversationsCurrentCount;
            }
            this.conversations.put(conversationAssembler.getName(), conversationAssembler);
            if (conversationAssembler.getInfo().isDynamic()) {
                this.conversationsByCreateConvMsgID.put(conversationAssembler.getInfo().getCreateConversationMessageID(), conversationAssembler);
            }
        }
    }

    private void addConversation(String string, ConversationAssembler conversationAssembler) {
        this.conversations.put(string, conversationAssembler);
    }

    public synchronized ConversationAssembler getConversation(String string) {
        return (ConversationAssembler)this.conversations.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConversationAssembler removeConversation(String string, boolean bl) {
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate;
        SAFConversationInfo sAFConversationInfo;
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "' : removing conversation " + string + " destroy = " + bl);
        }
        if ((sAFConversationInfo = this.getConversationInfo(string)) == null) {
            return null;
        }
        if (bl && this.store != null) {
            try {
                this.store.removeConversationInfo(sAFConversationInfo);
            }
            catch (SAFStoreException sAFStoreException) {
                // empty catch block
            }
        }
        if ((remoteEndpointRuntimeDelegate = this.getRemoteEndpoint(sAFConversationInfo.getDestinationURL())) != null) {
            remoteEndpointRuntimeDelegate.removeConversation(string);
        }
        safManager.removeLocalSendingAgentId(sAFConversationInfo);
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            if (this.conversations.get(string) != null) {
                --this.conversationsCurrentCount;
                ConversationAssembler conversationAssembler = (ConversationAssembler)this.conversations.remove(string);
                if (sAFConversationInfo.getDynamicConversationName() != null) {
                    this.conversations.remove(sAFConversationInfo.getDynamicConversationName());
                    this.dynamicNameToName.remove(sAFConversationInfo.getDynamicConversationName());
                }
                if (sAFConversationInfo.getCreateConversationMessageID() != null) {
                    this.conversations.remove(sAFConversationInfo.getCreateConversationMessageID());
                    this.removeConversationByCreateConvMsgID(sAFConversationInfo.getCreateConversationMessageID());
                }
                this.conversationInfosFromStore.remove(string);
                return conversationAssembler;
            }
        }
        return null;
    }

    private synchronized ConversationAssembler removeConversationByCreateConvMsgID(String string) {
        return (ConversationAssembler)this.conversationsByCreateConvMsgID.remove(string);
    }

    void registerConversationInfo(SAFConversationInfo sAFConversationInfo) throws SAFException {
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': registering conversation info: " + sAFConversationInfo);
        }
        if (this.findOrCreateConversation(sAFConversationInfo)) {
            this.storeConversationInfo(sAFConversationInfo);
        }
    }

    private synchronized SAFConversationInfo getConversationInfo(String string) {
        ConversationAssembler conversationAssembler = (ConversationAssembler)this.conversations.get(string);
        if (conversationAssembler == null) {
            conversationAssembler = (ConversationAssembler)this.conversationsByCreateConvMsgID.get(string);
        }
        return conversationAssembler == null ? null : conversationAssembler.getInfo();
    }

    synchronized double getDefaultRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    synchronized long getDefaultRetryDelayBase() {
        return this.retryDelayBase;
    }

    synchronized long getDefaultRetryDelayMaximum() {
        return this.retryDelayMaximum;
    }

    synchronized long getDefaultTimeToLive() {
        return this.timeToLiveDefault;
    }

    synchronized long getDefaultMaximumIdleTime() {
        return this.conversationIdleTimeMaximum;
    }

    void acknowledge(String string, long l, long l2) {
        block4: {
            String string2;
            ConversationAssembler conversationAssembler = this.getConversation(string);
            if (conversationAssembler == null && (string2 = this.getOrginalName(string)) != null) {
                conversationAssembler = this.getConversation(string2);
            }
            if (conversationAssembler == null) {
                return;
            }
            try {
                conversationAssembler.acknowledge(l, l2);
            }
            catch (SAFException sAFException) {
                if (!SAFDebug.SAFSendingAgent.isDebugEnabled() || !SAFDebug.SAFVerbose.isDebugEnabled()) break block4;
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': failed to acknowledge messages " + l + ":" + l2);
                sAFException.printStackTrace();
            }
        }
    }

    void handleAsyncFault(String string, String string2, Exception exception) {
        block4: {
            String string3;
            ConversationAssembler conversationAssembler = this.getConversation(string);
            if (conversationAssembler == null && (string3 = this.getOrginalName(string)) != null) {
                conversationAssembler = this.getConversation(string3);
            }
            if (conversationAssembler == null) {
                return;
            }
            try {
                conversationAssembler.handleAsyncFault(string2, exception);
            }
            catch (SAFException sAFException) {
                if (!SAFDebug.SAFSendingAgent.isDebugEnabled() || !SAFDebug.SAFVerbose.isDebugEnabled()) break block4;
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': failed to handle Fault related to " + string2);
                sAFException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCreateConversationSucceed(SAFConversationHandle sAFConversationHandle) {
        ConversationAssembler conversationAssembler = sAFConversationHandle.getCreateConversationMessageID() != null ? this.removeConversationByCreateConvMsgID(sAFConversationHandle.getCreateConversationMessageID()) : this.getConversation(sAFConversationHandle.getConversationName());
        if (conversationAssembler != null) {
            SendingAgentImpl sendingAgentImpl = this;
            synchronized (sendingAgentImpl) {
                conversationAssembler.onCreateConversationSucceed(sAFConversationHandle);
            }
        }
    }

    synchronized void increaseFailedMessagesCount() {
        ++this.failedMessagesTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SAFConversationRuntimeMBean[] getConversationRuntimeDelegates() {
        Iterator iterator;
        int n;
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            n = this.conversations.size();
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
        }
        int n2 = 0;
        SAFConversationRuntimeMBean[] sAFConversationRuntimeMBeanArray = new SAFConversationRuntimeMBean[n];
        while (iterator.hasNext()) {
            ConversationAssembler conversationAssembler = (ConversationAssembler)iterator.next();
            if (this.getConversation(conversationAssembler.getName()) == null) continue;
            sAFConversationRuntimeMBeanArray[n2++] = conversationAssembler.getRuntimeDelegate();
        }
        return sAFConversationRuntimeMBeanArray;
    }

    public synchronized long getConversationsCurrentCount() {
        return this.conversationsCurrentCount;
    }

    public synchronized long getConversationsHighCount() {
        return this.conversationsHighCount;
    }

    public synchronized long getConversationsTotalCount() {
        return this.conversationsTotalCount;
    }

    public synchronized long getFailedMessagesTotal() {
        return this.failedMessagesTotal;
    }

    public synchronized void pauseIncoming() {
        if (this.isPausedForIncoming) {
            return;
        }
        this.isPausedForIncoming = true;
        this.isPaused = true;
        this.unadvertise();
    }

    public synchronized void resumeIncoming() {
        if (!this.isPausedForIncoming) {
            return;
        }
        this.isPausedForIncoming = false;
        this.isPaused = false;
        this.advertise();
    }

    public synchronized boolean isPausedForIncoming() {
        return this.isPausedForIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseForwarding() throws SAFException {
        Iterator iterator;
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            if (this.isPausedForForwarding) {
                return;
            }
            this.isPausedForForwarding = true;
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': about to pause one conversation");
            }
            try {
                ((ConversationAssembler)iterator.next()).pauseReader();
            }
            catch (KernelException kernelException) {
                throw new SAFException("SAF Agent '" + this.name + "': failed to resume forwarding", kernelException);
            }
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("SAF Agent " + this.getName() + " is paused for forwarding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeForwarding() throws SAFException {
        Iterator iterator;
        SendingAgentImpl sendingAgentImpl = this;
        synchronized (sendingAgentImpl) {
            if (!this.isPausedForForwarding) {
                return;
            }
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
            this.isPausedForForwarding = false;
        }
        while (iterator.hasNext()) {
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.name + "': about to resume one reader");
            }
            try {
                ((ConversationAssembler)iterator.next()).resumeReader();
            }
            catch (KernelException kernelException) {
                throw new SAFException("SAF Agent '" + this.name + "': Failed to resume forwarding", kernelException);
            }
        }
    }

    public synchronized boolean isPausedForForwarding() {
        return this.isPausedForForwarding;
    }

    synchronized void setDefaultRetryDelayBase(long l) {
        this.retryDelayBase = l;
    }

    synchronized void setDefaultRetryDelayMaximum(long l) {
        this.retryDelayMaximum = l;
    }

    synchronized void setDefaultRetryDelayMultiplier(double d) {
        this.retryDelayMultiplier = d;
    }

    synchronized void setDefaultTimeToLive(long l) {
        this.timeToLiveDefault = l;
    }

    synchronized void setConversationIdleTimeMaximum(long l) {
        this.conversationIdleTimeMaximum = l;
    }

    synchronized void setLoggingEnabled(boolean bl) {
        this.isLoggingEnabled = bl;
    }

    void setWindowSize(int n) {
        this.windowSize = n;
    }

    HealthState getHealthState() {
        return this.healthState;
    }

    private static boolean isNotWSRM(String string) {
        return !string.substring(0, 3).equals("WS:");
    }

    private static String getKernelTopicName(SAFConversationInfo sAFConversationInfo) {
        int n = sAFConversationInfo.getDestinationType();
        String string = sAFConversationInfo.getDestinationURL();
        if (n == 2) {
            return "WS:" + string;
        }
        if (n == 3) {
            return "WS_JAXWS:" + string;
        }
        return string;
    }

    Kernel getKernel() {
        return this.kernel;
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        Object[] objectArray2;
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("SendingAgent");
        super.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeAttribute("failedMessagesTotal", String.valueOf(this.failedMessagesTotal));
        xMLStreamWriter.writeAttribute("retryDelayMultiplier", String.valueOf(this.retryDelayMultiplier));
        xMLStreamWriter.writeAttribute("retryDelayBase", String.valueOf(this.retryDelayBase));
        xMLStreamWriter.writeAttribute("retryDelayMaximum", String.valueOf(this.retryDelayMaximum));
        xMLStreamWriter.writeAttribute("timeToLiveDefault", String.valueOf(this.timeToLiveDefault));
        xMLStreamWriter.writeAttribute("conversationIdleTimeMaximum", String.valueOf(this.conversationIdleTimeMaximum));
        xMLStreamWriter.writeAttribute("isLoggingEnabled", String.valueOf(this.isLoggingEnabled));
        xMLStreamWriter.writeAttribute("windowSize", String.valueOf(this.windowSize));
        xMLStreamWriter.writeAttribute("isPausedForIncoming", String.valueOf(this.isPausedForIncoming));
        xMLStreamWriter.writeAttribute("isPausedForForwarding", String.valueOf(this.isPausedForForwarding));
        SAFDiagnosticImageSource.dumpHealthStateElement(xMLStreamWriter, this.getAgentAdmin().getHealthState());
        xMLStreamWriter.writeStartElement("DynamicNames");
        HashMap hashMap = (HashMap)this.dynamicNameToName.clone();
        xMLStreamWriter.writeAttribute("count", String.valueOf(hashMap.size()));
        for (Object[] objectArray2 : hashMap.keySet()) {
            xMLStreamWriter.writeStartElement("DynamicNameToName");
            xMLStreamWriter.writeAttribute("dynamicName", (String)objectArray2);
            xMLStreamWriter.writeAttribute("name", (String)hashMap.get(objectArray2));
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ConversationAssemblers");
        objectArray2 = this.conversations.values().toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray2.length));
        for (int i = 0; i < objectArray2.length; ++i) {
            ConversationAssembler conversationAssembler = (ConversationAssembler)objectArray2[i];
            conversationAssembler.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        ((KernelImpl)this.kernel).dump((MessagingKernelDiagnosticImageSource)sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    class ServerStateChangeListener
    implements PropertyChangeListener {
        ServerStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("State".equals(propertyChangeEvent.getPropertyName()) && "RUNNING".equals((String)propertyChangeEvent.getNewValue())) {
                SendingAgentImpl sendingAgentImpl = SendingAgentImpl.this;
                synchronized (sendingAgentImpl) {
                    for (ConversationAssembler conversationAssembler : SendingAgentImpl.this.conversations.values()) {
                        conversationAssembler.startFromADiffThread();
                    }
                }
            }
        }
    }
}

