/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.List;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.common.AgentDeliverRequest;
import weblogic.messaging.saf.common.AgentDeliverResponse;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.common.SAFResultImpl;
import weblogic.messaging.saf.internal.MessageReference;
import weblogic.messaging.saf.internal.QOSHandler;

public class WSQOSHandler
extends QOSHandler {
    private long lastAsyncAckNumHigh;

    public WSQOSHandler(SAFConversationInfo sAFConversationInfo, SAFTransport sAFTransport, long l) {
        super(sAFConversationInfo, sAFTransport);
    }

    private static boolean isDeliverSync(SAFRequest sAFRequest) {
        AgentDeliverRequest agentDeliverRequest = ((SAFRequestImpl)sAFRequest).getAgentRequest();
        return agentDeliverRequest != null && agentDeliverRequest.isSyncAck();
    }

    private final void sendSyncNack(SAFRequest sAFRequest) {
        this.setResult();
        AgentDeliverRequest agentDeliverRequest = ((SAFRequestImpl)sAFRequest).getAgentRequest();
        agentDeliverRequest.notifyResult(new AgentDeliverResponse(this.result));
    }

    protected void sendNack() {
        if (WSQOSHandler.isDeliverSync(this.currentSAFRequest)) {
            this.sendSyncNack(this.currentSAFRequest);
            return;
        }
        this.sendResult();
    }

    protected void sendAck() {
        long l = -1L;
        for (MessageReference messageReference = this.sequenceNumberLowMRef; messageReference != null; messageReference = messageReference.getNext()) {
            if (!WSQOSHandler.isDeliverSync(messageReference.getMessage())) continue;
            l = this.sendSyncAck(messageReference);
        }
        if (l < this.lastAsyncAckNumHigh && this.lastAsyncAckNumHigh != 0L) {
            this.sendAsyncAck();
        }
        this.sequenceNumberHighMRef = null;
        this.sequenceNumberLowMRef = null;
        this.lastAsyncAckNumHigh = 0L;
    }

    private long sendSyncAck(MessageReference messageReference) {
        SAFRequestImpl sAFRequestImpl = (SAFRequestImpl)messageReference.getMessage();
        AgentDeliverRequest agentDeliverRequest = sAFRequestImpl.getAgentRequest();
        long l = sAFRequestImpl.getSequenceNumber();
        List list = this.sequence.getAllSequenceNumberRanges();
        AgentDeliverResponse agentDeliverResponse = new AgentDeliverResponse(new SAFResultImpl(agentDeliverRequest.getConversationInfo(), list, 0, null));
        agentDeliverRequest.notifyResult(agentDeliverResponse);
        return l;
    }

    private void sendAsyncAck() {
        this.sequenceNumberLow = this.sequenceNumberLow < this.lastAsyncAckNumHigh ? this.sequenceNumberLow : this.lastAsyncAckNumHigh;
        this.sendAckInternal();
    }

    protected final void update(MessageReference messageReference, int n) {
        long l = messageReference.getSequenceNumber();
        this.result.setResultCode(n);
        if (n != 0) {
            return;
        }
        if (this.sequenceNumberLowMRef == null) {
            this.sequenceNumberLowMRef = messageReference;
            this.sequenceNumberHighMRef = messageReference;
        } else {
            this.sequenceNumberHighMRef.setNext(messageReference);
            this.sequenceNumberHighMRef = messageReference;
        }
        if (l >= this.sequenceNumberHigh) {
            this.sequenceNumberHigh = l;
        }
        if (l <= this.sequenceNumberLow) {
            this.sequenceNumberLow = l;
        }
        if (!WSQOSHandler.isDeliverSync(messageReference.getMessage()) && l >= this.lastAsyncAckNumHigh) {
            this.lastAsyncAckNumHigh = l;
        }
    }
}

