/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.store;

import java.util.HashMap;
import weblogic.common.CompletionRequest;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.Agent;
import weblogic.messaging.saf.internal.ReceivingAgent;
import weblogic.messaging.saf.internal.ReceivingAgentImpl;
import weblogic.messaging.saf.internal.SendingAgent;
import weblogic.messaging.saf.internal.SendingAgentImpl;
import weblogic.messaging.saf.store.SAFObjectHandler;
import weblogic.messaging.saf.store.SAFStoreException;
import weblogic.messaging.saf.store.SAFStoreRecord;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;

public final class SAFStore {
    private PersistentHandle SAStoreHandle;
    private PersistentHandle RAStoreHandle;
    private final HashMap conversationStoreHandles = new HashMap();
    private final HashMap conversationInfos = new HashMap();
    private SendingAgent sendingAgent;
    private ReceivingAgent receivingAgent;
    private final String agentName;
    private PersistentStore store;
    private final String storeName;
    private boolean recovered;
    private static final int NO_FLAGS = 0;
    private static final String CONN_NAME_PREFIX = "weblogic.messaging.";
    private static final SAFObjectHandler SAF_OBJECT_HANDLER = new SAFObjectHandler();
    private PersistentStoreConnection storeConnectionNotForMaps;

    SAFStore(String string, String string2, boolean bl) throws SAFException {
        this.storeName = string;
        this.agentName = string2;
        this.initPersistentStore();
        this.open(bl);
        if (SAFDebug.SAFStore.isDebugEnabled()) {
            SAFDebug.SAFStore.debug(" == SAFStore Created for Agent " + string2);
        }
    }

    private void initPersistentStore() throws SAFException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        if (this.storeName != null) {
            this.store = persistentStoreManager.getStore(this.storeName);
            if (this.store == null) {
                throw new AssertionError((Object)("Persistent Store Service should have already created a PersistentStore  for Name = <" + this.storeName + " > before SAFService is booted"));
            }
        } else {
            this.store = persistentStoreManager.getDefaultStore();
            if (this.store == null) {
                throw new SAFException("The default persistent store does not exist");
            }
            if (SAFDebug.SAFStore.isDebugEnabled()) {
                SAFDebug.SAFStore.debug("Agent using the server's default store");
            }
        }
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getEffectiveStoreName() {
        if (this.storeName != null) {
            return this.storeName;
        }
        if (this.store != null) {
            return this.store.getName();
        }
        return null;
    }

    public String toString() {
        return "<SAFStore> : storeName = " + this.storeName + " agentName =" + this.agentName;
    }

    public synchronized SendingAgent getSendingAgent() {
        return this.sendingAgent;
    }

    public synchronized ReceivingAgent getReceivingAgent() {
        return this.receivingAgent;
    }

    private void open(boolean bl) throws SAFStoreException {
        try {
            this.storeConnectionNotForMaps = this.store.createConnection(CONN_NAME_PREFIX + this.agentName, (ObjectHandler)SAF_OBJECT_HANDLER);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new SAFStoreException(this, (Throwable)persistentStoreException);
        }
        SAFStoreRecord sAFStoreRecord = this.recover();
        while (sAFStoreRecord != null) {
            SAFStoreRecord sAFStoreRecord2;
            block13: {
                Object object;
                sAFStoreRecord2 = sAFStoreRecord.getNext();
                sAFStoreRecord.setNext(null);
                try {
                    object = sAFStoreRecord.getStoreObject();
                }
                catch (PersistentStoreException persistentStoreException) {
                    break block13;
                }
                if (SAFDebug.SAFStore.isDebugEnabled()) {
                    SAFDebug.SAFStore.debug("*********** ***** <SAFStoreRecord> state= class=" + object.getClass().getName() + " code=" + SAF_OBJECT_HANDLER.getCode(object) + " obj=" + object);
                }
                switch (SAF_OBJECT_HANDLER.getCode(object)) {
                    case 15: {
                        this.sendingAgent = (SendingAgent)object;
                        break;
                    }
                    case 16: {
                        this.receivingAgent = (ReceivingAgent)object;
                        break;
                    }
                    case 17: {
                        SAFConversationInfo sAFConversationInfo = (SAFConversationInfo)object;
                        this.conversationInfos.put(sAFConversationInfo.getConversationName(), sAFConversationInfo);
                        this.conversationStoreHandles.put(sAFConversationInfo, sAFStoreRecord.getHandle());
                        break;
                    }
                }
            }
            sAFStoreRecord = sAFStoreRecord2;
        }
        if (this.sendingAgent != null) {
            ((SendingAgentImpl)this.sendingAgent).setConversationInfosFromStore(this.conversationInfos);
        }
        if (this.receivingAgent != null) {
            ((ReceivingAgentImpl)this.receivingAgent).setConversationInfosFromStore(this.conversationInfos);
        }
    }

    private SAFStoreRecord recover() throws SAFStoreException {
        if (this.recovered) {
            return null;
        }
        this.recovered = true;
        SAFStoreRecord sAFStoreRecord = null;
        SAFStoreRecord sAFStoreRecord2 = null;
        try {
            PersistentStoreRecord persistentStoreRecord;
            PersistentStoreConnection.Cursor cursor = this.storeConnectionNotForMaps.createCursor(0);
            while ((persistentStoreRecord = cursor.next()) != null) {
                SAFStoreRecord sAFStoreRecord3 = new SAFStoreRecord(persistentStoreRecord);
                if (sAFStoreRecord2 == null) {
                    sAFStoreRecord = sAFStoreRecord2 = sAFStoreRecord3;
                    continue;
                }
                sAFStoreRecord2.setNext(sAFStoreRecord3);
                sAFStoreRecord2 = sAFStoreRecord3;
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            SAFStoreException sAFStoreException = new SAFStoreException(this, (Throwable)persistentStoreException);
            sAFStoreException.initCause(persistentStoreException);
            throw sAFStoreException;
        }
        return sAFStoreRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap hashMap = this.conversationInfos;
        synchronized (hashMap) {
            this.conversationInfos.clear();
            this.conversationStoreHandles.clear();
        }
        if (this.storeConnectionNotForMaps != null) {
            this.storeConnectionNotForMaps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws SAFStoreException {
        this.delete(this.SAStoreHandle);
        this.delete(this.RAStoreHandle);
        HashMap hashMap = this.conversationInfos;
        synchronized (hashMap) {
            for (PersistentHandle persistentHandle : this.conversationStoreHandles.values()) {
                this.delete(persistentHandle);
            }
        }
    }

    public void addAgent(Agent agent) throws SAFStoreException {
        if (SAFDebug.SAFStore.isDebugEnabled()) {
            SAFDebug.SAFStore.debug(" == BEFORE ADDING Agent " + agent.getName() + " and store's agentName = " + this.agentName);
        }
        PersistentHandle persistentHandle = this.storeAgent(agent);
        if (agent instanceof SendingAgent) {
            this.sendingAgent = (SendingAgent)agent;
            this.SAStoreHandle = persistentHandle;
        } else if (agent instanceof ReceivingAgent) {
            this.receivingAgent = (ReceivingAgent)agent;
            this.RAStoreHandle = persistentHandle;
        }
        if (SAFDebug.SAFStore.isDebugEnabled()) {
            SAFDebug.SAFStore.debug(" == AFTER ADDING Agent " + agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversationInfo(SAFConversationInfo sAFConversationInfo) throws SAFStoreException {
        HashMap hashMap = this.conversationInfos;
        synchronized (hashMap) {
            if (this.conversationInfos.get(sAFConversationInfo.getConversationName()) == null) {
                PersistentHandle persistentHandle = this.storeSync(sAFConversationInfo);
                this.conversationInfos.put(sAFConversationInfo.getConversationName(), sAFConversationInfo);
                this.conversationStoreHandles.put(sAFConversationInfo, persistentHandle);
            } else {
                PersistentHandle persistentHandle = (PersistentHandle)this.conversationStoreHandles.get(sAFConversationInfo);
                this.updateSync(persistentHandle, sAFConversationInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversationInfo(SAFConversationInfo sAFConversationInfo) throws SAFStoreException {
        HashMap hashMap = this.conversationInfos;
        synchronized (hashMap) {
            if (this.conversationInfos.remove(sAFConversationInfo.getConversationName()) != null) {
                this.delete((PersistentHandle)this.conversationStoreHandles.remove(sAFConversationInfo));
            }
        }
    }

    private PersistentHandle storeAgent(Agent agent) throws SAFStoreException {
        return this.storeSync(agent);
    }

    private PersistentHandle storeInternal(Object object, CompletionRequest completionRequest) {
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        PersistentHandle persistentHandle = this.storeConnectionNotForMaps.create(persistentStoreTransaction, object, 0);
        persistentStoreTransaction.commit(completionRequest);
        return persistentHandle;
    }

    private void updateInternal(PersistentHandle persistentHandle, Object object, CompletionRequest completionRequest) {
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        this.storeConnectionNotForMaps.update(persistentStoreTransaction, persistentHandle, object, 0);
        persistentStoreTransaction.commit(completionRequest);
    }

    private PersistentHandle storeSync(Object object) throws SAFStoreException {
        CompletionRequest completionRequest = new CompletionRequest();
        PersistentHandle persistentHandle = this.storeInternal(object, completionRequest);
        try {
            completionRequest.getResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new SAFStoreException(this, throwable);
        }
        return persistentHandle;
    }

    private void updateSync(PersistentHandle persistentHandle, Object object) throws SAFStoreException {
        CompletionRequest completionRequest = new CompletionRequest();
        this.updateInternal(persistentHandle, object, completionRequest);
        try {
            completionRequest.getResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new SAFStoreException(this, throwable);
        }
    }

    private void delete(PersistentHandle persistentHandle) throws SAFStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        this.storeConnectionNotForMaps.delete(persistentStoreTransaction, persistentHandle, 0);
        try {
            persistentStoreTransaction.commit();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new SAFStoreException(this, (Throwable)persistentStoreException);
        }
    }
}

