/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.utils.concurrent.ConcurrentBlockingQueue;
import weblogic.utils.concurrent.ConcurrentFactory;
import weblogic.work.WorkManager;

public abstract class DeliveryList
implements Runnable {
    private final Object lockObject = new Object();
    protected final ConcurrentBlockingQueue deliveryQueue = ConcurrentFactory.createConcurrentBlockingQueue();
    private static final int DEFAULT_PUSH_SIZE_LIMIT = DeliveryList.getIntProperty("weblogic.messaging.PushSizeLimit", Integer.MAX_VALUE);
    private int pushSizeLimit = DEFAULT_PUSH_SIZE_LIMIT;
    private int pushImpatiencePoint = Integer.MAX_VALUE;
    private int pushDelay = 0;
    private int pushDelayStart = 0;
    private int maxTotalDelay;
    private int throughputEmphasis = 25;
    private long lastTime = 0L;
    private int totalMessages = 0;
    private int consecutiveEvents = 0;
    private int consecutiveNegativeEventsRequired;
    private int consecutivePositiveEventsRequired;
    private boolean neverAggregate = false;
    private boolean running;
    private WorkManager workManager;

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDeliveryList(int n, int n2, int n3, int n4) {
        Object object = this.lockObject;
        synchronized (object) {
            this.pushDelay = n3;
            this.pushDelayStart = n3;
            this.maxTotalDelay = n4;
            if (n2 <= 12) {
                this.neverAggregate = true;
                this.pushDelay = 0;
                this.pushDelayStart = 0;
                this.pushSizeLimit = 1;
            } else if (n2 <= 37) {
                this.pushDelay = 0;
                this.pushDelayStart = 0;
                this.pushSizeLimit = DEFAULT_PUSH_SIZE_LIMIT;
                this.pushImpatiencePoint = 1;
            } else if (n2 <= 62) {
                this.pushSizeLimit = 10240;
                this.pushImpatiencePoint = n / 2 + 1;
                this.consecutiveNegativeEventsRequired = 3;
                this.consecutivePositiveEventsRequired = 5;
                if (n4 == 0) {
                    this.maxTotalDelay = 10 * this.pushDelay;
                }
            } else if (n2 <= 87) {
                this.consecutiveNegativeEventsRequired = 5;
                this.consecutivePositiveEventsRequired = 5;
                this.pushSizeLimit = 20480;
                this.pushImpatiencePoint = n * 3 / 4 + 1;
                if (n4 == 0) {
                    this.maxTotalDelay = 20 * this.pushDelay;
                }
            } else {
                this.consecutiveNegativeEventsRequired = 5;
                this.consecutivePositiveEventsRequired = 2;
                this.pushSizeLimit = 40960;
                this.pushImpatiencePoint = n;
                if (n4 == 0) {
                    this.maxTotalDelay = 100 * this.pushDelay;
                }
            }
        }
    }

    public Runnable deliver(ListenRequest listenRequest, List list) {
        return this.deliver(list);
    }

    public Runnable deliver(ListenRequest listenRequest, MessageElement messageElement) {
        return this.deliver(messageElement);
    }

    public Runnable deliver(List list) {
        this.deliveryQueue.addAll((Collection)list);
        return this.checkAndStartRunning();
    }

    public final Runnable deliver(MessageElement messageElement) {
        this.deliveryQueue.add((Object)messageElement);
        return this.checkAndStartRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable checkAndStartRunning() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.running) {
                return null;
            }
            this.running = true;
            return this;
        }
    }

    protected List getPendingMessages() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = 0L;
        long l2 = 0L;
        if (this.pushDelayStart != 0) {
            l2 = System.currentTimeMillis();
            if (this.pushDelay != this.pushDelayStart && l2 - this.lastTime < (long)this.pushDelayStart) {
                ++this.consecutiveEvents;
                if (this.consecutiveEvents >= this.consecutivePositiveEventsRequired) {
                    this.pushDelay = this.pushDelayStart;
                    this.consecutiveEvents = 0;
                }
            } else {
                this.consecutiveEvents = 0;
            }
        }
        boolean bl = false;
        int n = 0;
        do {
            object = null;
            try {
                long l3;
                int n2;
                object = this.deliveryQueue.poll();
                if (!this.neverAggregate && object == null && !bl && this.pushDelay != 0 && (object = this.deliveryQueue.poll((long)(n2 = arrayList.size() >= this.pushImpatiencePoint ? 0 : this.pushDelay))) != null && this.maxTotalDelay != 0 && (l3 = System.currentTimeMillis()) - l2 >= (long)this.maxTotalDelay) {
                    bl = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (object == null || ((MessageElement)object).getMessage() == null) break;
            arrayList.add(object);
        } while ((n = (int)((long)n + ((MessageElement)object).getMessage().size())) < this.pushSizeLimit);
        if (this.pushDelay > 0) {
            if (arrayList.size() == 1) {
                ++this.consecutiveEvents;
                if (this.consecutiveEvents >= this.consecutiveNegativeEventsRequired) {
                    this.pushDelay = 0;
                    this.consecutiveEvents = 0;
                }
            } else {
                this.consecutiveEvents = 0;
            }
        }
        if (this.pushDelayStart != 0 && n < this.pushSizeLimit) {
            this.lastTime = l2;
        }
        this.totalMessages += arrayList.size();
        return arrayList;
    }

    protected List getAllPendingMessages() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((object = this.deliveryQueue.poll()) != null) {
            arrayList.add(object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            List list;
            if (!(list = this.getPendingMessages()).isEmpty()) {
                this.pushMessages(list);
            }
            Object object = this.lockObject;
            synchronized (object) {
                if (this.deliveryQueue.isEmpty()) {
                    this.lockObject.notifyAll();
                    this.running = false;
                    return;
                }
            }
        } while (!this.workManager.scheduleIfBusy((Runnable)this));
    }

    protected abstract void pushMessages(List var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilIdle() {
        Object object = this.lockObject;
        synchronized (object) {
            while (this.running) {
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static int getIntProperty(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return n;
        }
        int n2 = n;
        String string3 = "Syntax Error, using default " + n;
        try {
            n2 = Integer.parseInt(string2);
            string3 = "Changed from default " + n + " to " + n2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.out.println("DeliveryList: Prop [" + string + "]" + string3 + ".");
        return n2;
    }
}

