/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.util;

import java.util.NoSuchElementException;
import weblogic.messaging.util.Element;
import weblogic.messaging.util.ListIterator;

public class List {
    int size;
    Element first;
    Element last;

    public void add(Element element) {
        if (element.getList() != null) {
            throw new IllegalArgumentException();
        }
        element.setNext(null);
        if (this.first == null) {
            this.first = element;
        } else {
            this.last.setNext(element);
        }
        element.setPrev(this.last);
        this.last = element;
        element.setList(this);
        ++this.size;
    }

    public void add(List list) {
        if (list == this) {
            throw new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            return;
        }
        if (this.first == null) {
            this.first = list.getFirst();
        } else {
            this.last.setNext(list.getFirst());
            list.getFirst().setPrev(this.last);
        }
        this.last = list.getLast();
        this.size += list.size();
        for (Element element = list.getFirst(); element != null; element = element.getNext()) {
            element.setList(this);
        }
        list.last = null;
        list.first = null;
        list.size = 0;
    }

    public void clear() {
        while (this.first != null) {
            this.remove(this.first);
        }
    }

    public boolean contains(Element element) {
        return element.getList() == this;
    }

    public Element remove(Element element) {
        if (!this.contains(element)) {
            throw new NoSuchElementException();
        }
        if (element.getNext() != null) {
            element.getNext().setPrev(element.getPrev());
        } else {
            this.last = element.getPrev();
        }
        if (element.getPrev() == null) {
            this.first = element.getNext();
        } else {
            element.getPrev().setNext(element.getNext());
        }
        element.setList(null);
        element.setPrev(null);
        element.setNext(null);
        --this.size;
        return element;
    }

    public List split(Element element, boolean bl) {
        if (!this.contains(element)) {
            throw new NoSuchElementException();
        }
        List list = new List();
        if (bl) {
            if (element == this.last) {
                return list;
            }
            list.first = element.getNext();
            list.last = this.last;
            this.last = element;
            list.first.setPrev(null);
            this.last.setNext(null);
        } else {
            list.first = element;
            list.last = this.last;
            if (element == this.first) {
                this.last = null;
                this.first = null;
            } else {
                this.last = element.getPrev();
                this.last.setNext(null);
                element.setPrev(null);
            }
        }
        element = list.getFirst();
        while (element != null) {
            element.setList(list);
            element = element.getNext();
            ++list.size;
            --this.size;
        }
        return list;
    }

    public Element getFirst() {
        return this.first;
    }

    public Element getLast() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ListIterator iterator(Element element) {
        return new ListIterator(this, element);
    }

    public ListIterator iterator() {
        return this.iterator(this.first);
    }

    public Element[] toArray(Element[] elementArray) {
        Element[] elementArray2 = elementArray != null && elementArray.length >= this.size ? elementArray : new Element[this.size];
        int n = 0;
        Element element = this.first;
        while (element != null) {
            elementArray2[n] = element;
            element = element.getNext();
            ++n;
        }
        return elementArray2;
    }
}

