/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.util;

import weblogic.messaging.util.Element;
import weblogic.messaging.util.List;

public final class ListIterator {
    private List list;
    private Element cursor;
    private Element element;

    ListIterator(List list, Element element) {
        this.list = list;
        this.initialize(element);
    }

    public void initialize(Element element) {
        if (element != null && !this.list.contains(element)) {
            throw new IllegalArgumentException("List does not contain the specified element");
        }
        this.cursor = element;
        this.element = null;
    }

    public boolean hasNext() {
        return this.cursor != null;
    }

    public boolean hasPrevious() {
        if (this.cursor == null) {
            return this.list.getLast() != null;
        }
        return this.cursor.getPrev() != null;
    }

    public Element next() {
        this.element = this.cursor;
        if (this.element != null) {
            this.cursor = this.cursor.getNext();
        }
        return this.element;
    }

    public Element previous() {
        if (this.cursor != null) {
            if (this.cursor.getPrev() != null) {
                this.element = this.cursor = this.cursor.getPrev();
                return this.cursor;
            }
        } else if (this.list.getLast() != null) {
            this.element = this.cursor = this.list.getLast();
            return this.cursor;
        }
        return this.element;
    }

    public Element remove() {
        if (this.element == null) {
            throw new IllegalStateException();
        }
        if (this.element == this.cursor) {
            this.cursor = this.cursor.getNext();
        }
        this.list.remove(this.element);
        Element element = this.element;
        this.element = null;
        return element;
    }

    public void set(Object object) {
        if (this.element == null) {
            throw new IllegalStateException();
        }
        Element element = (Element)object;
        this.remove();
        this.add(element);
        if (this.cursor == this.element) {
            this.cursor = element;
        }
        this.element = element;
    }

    public void add(Element element) {
        if (element.getList() != null) {
            throw new IllegalArgumentException();
        }
        if (this.cursor != null) {
            element.setNext(this.cursor);
            element.setPrev(this.cursor.getPrev());
            this.cursor.setPrev(element);
        } else {
            element.setNext(null);
            element.setPrev(this.list.getLast());
            this.list.last = element;
        }
        if (element.getPrev() == null) {
            this.list.first = element;
        } else {
            element.getPrev().setNext(element);
        }
        this.element = null;
        element.setList(this.list);
        ++this.list.size;
    }

    public int nextIndex() {
        if (this.cursor == null) {
            return this.list.size;
        }
        int n = 0;
        for (Element element = this.cursor.getPrev(); element != null; element = element.getPrev()) {
            ++n;
        }
        return n;
    }

    public int previousIndex() {
        if (this.cursor == null) {
            return this.list.size - 1;
        }
        Element element = this.cursor.getPrev();
        int n = -1;
        while (element != null) {
            element = element.getPrev();
            ++n;
        }
        return n;
    }
}

