/*
 * Decompiled with CFR 0.152.
 */
package weblogic.metadata.management;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.AnnotationOverridesBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.ModuleProviderBean;
import weblogic.logging.NonCatalogLogger;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.GenericClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationOverridesModule
implements Module,
UpdateListener {
    private static final String ROOT_ELEMENT_NAME = "annotation-overrides";
    private static final String PLAN_UPDATE_URI = "META-INF/annotation-overrides.xml";
    private static final String PLAN_DIR_NAME = "plan";
    private static final String PLAN_FILENAME = "Plan.xml";
    private ModuleProviderBean _provider;
    private GenericClassLoader _classloader;
    private Map<String, DescriptorBean> _descriptorMap = new HashMap<String, DescriptorBean>();
    private String _appName;
    private CustomModuleBean _customModuleBean;
    private DescriptorManager _descriptorManager;
    private ApplicationContextInternal _applicationContext;
    private static NonCatalogLogger _logger = new NonCatalogLogger("AnnotationOverridesModule");
    private long _overrideVersion = 0L;
    private Map<String, List<DescriptorBean>> _pendingUpdateDescriptors;
    private Map<String, String> _webUriMapping;

    @Override
    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    @Override
    public void adminToProduction() {
    }

    @Override
    public void forceProductionToAdmin() throws ModuleException {
    }

    @Override
    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
    }

    public AnnotationOverridesModule(ModuleProviderBean moduleProviderBean, CustomModuleBean customModuleBean) {
        this._provider = moduleProviderBean;
        this._customModuleBean = customModuleBean;
        this._descriptorManager = new DescriptorManager();
        this._pendingUpdateDescriptors = new HashMap<String, List<DescriptorBean>>();
    }

    @Override
    public String getId() {
        return this._customModuleBean.getUri();
    }

    @Override
    public String getType() {
        return WebLogicModuleType.MODULETYPE_CONFIG;
    }

    @Override
    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[0];
    }

    private String getLogPrefix() {
        return "[ _appName: " + this._appName + " ][ uri: " + this._customModuleBean.getUri() + " ] ";
    }

    @Override
    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this._applicationContext = (ApplicationContextInternal)applicationContext;
        this._appName = this._applicationContext.getApplicationId();
        registration.addUpdateListener(this);
        this._classloader = genericClassLoader;
        this._webUriMapping = new HashMap<String, String>();
        ApplicationBean applicationBean = this._applicationContext.getApplicationDD();
        if (applicationBean != null) {
            for (ModuleBean moduleBean : applicationBean.getModules()) {
                WebBean webBean = moduleBean.getWeb();
                if (webBean == null) continue;
                String string = webBean.getContextRoot();
                String string2 = webBean.getWebUri();
                this._webUriMapping.put(string2, string);
            }
        }
        return genericClassLoader;
    }

    @Override
    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration);
    }

    private Map<String, DescriptorBean> getAnnotationOverrideDescriptors() throws ModuleException {
        HashMap<String, DescriptorBean> hashMap = new HashMap<String, DescriptorBean>();
        try {
            DeploymentPlanBean deploymentPlanBean = this.getDeploymentPlanBean();
            if (deploymentPlanBean == null) {
                _logger.debug(this.getLogPrefix() + ":No Deployment Plan");
            } else {
                String string = deploymentPlanBean.getConfigRoot();
                _logger.info("ConfigRoot is " + string);
                StringBuilder stringBuilder = new StringBuilder();
                ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
                for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                    ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
                    String string2 = moduleOverrideBean.getModuleName();
                    String string3 = moduleOverrideBean.getModuleType();
                    boolean bl = deploymentPlanBean.rootModule(string2);
                    ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
                    for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                        ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[j];
                        String string4 = moduleDescriptorBean.getUri();
                        String string5 = moduleDescriptorBean.getRootElement();
                        if (!string5.equals(ROOT_ELEMENT_NAME)) continue;
                        String string6 = null;
                        String string7 = string2;
                        stringBuilder.delete(0, stringBuilder.length());
                        stringBuilder.append(string);
                        if (bl) {
                            string7 = "__WLS ROOT MODULE URI__";
                            stringBuilder.append(File.separatorChar);
                            stringBuilder.append(string4);
                        } else {
                            stringBuilder.append(File.separatorChar);
                            stringBuilder.append(string2);
                            stringBuilder.append(File.separatorChar);
                            stringBuilder.append(string4);
                        }
                        string6 = stringBuilder.toString();
                        FileInputStream fileInputStream = null;
                        try {
                            File file = new File(string6);
                            if (!file.exists()) continue;
                            if (!file.canRead()) {
                                _logger.debug(this.getLogPrefix() + ": unable to load anootation override for " + string7 + " due to file permission");
                                continue;
                            }
                            fileInputStream = new FileInputStream(file);
                            DescriptorBean descriptorBean = this._descriptorManager.createDescriptor((InputStream)fileInputStream).getRootBean();
                            hashMap.put(string7, descriptorBean);
                            if (!this._webUriMapping.containsKey(string7)) continue;
                            String string8 = this._webUriMapping.get(string7);
                            hashMap.put(string8, descriptorBean);
                            continue;
                        }
                        catch (Exception exception) {
                            throw new ModuleException(exception);
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                    }
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    @Override
    public void prepare() throws ModuleException {
        _logger.info(this.getLogPrefix() + ":prepare()");
        this._descriptorMap = this.getAnnotationOverrideDescriptors();
    }

    private DeploymentPlanBean getDeploymentPlanBean() throws FileNotFoundException, IOException, XMLStreamException {
        AppDeploymentMBean appDeploymentMBean = this._applicationContext.getAppDeploymentMBean();
        assert (appDeploymentMBean != null);
        DeploymentPlanBean deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
        if (deploymentPlanBean == null) {
            String string = this.getConfigDir(appDeploymentMBean);
            if (string == null) {
                return null;
            }
            File file = new File(string + File.separator + PLAN_FILENAME);
            if (file.exists() && file.canRead()) {
                deploymentPlanBean = new DeploymentPlanDescriptorLoader(file).getDeploymentPlanBean();
                deploymentPlanBean.setConfigRoot(string);
            }
        }
        return deploymentPlanBean;
    }

    private String getConfigDir(AppDeploymentMBean appDeploymentMBean) {
        String string = null;
        String string2 = appDeploymentMBean.getSourcePath();
        File file = new File(string2);
        boolean bl = file.isDirectory();
        if (bl) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                string = file2.getAbsolutePath();
            }
        } else {
            File file3;
            File file4 = file.getParentFile();
            if (file4 != null && (file3 = file4.getParentFile()) != null) {
                string = file3.getAbsolutePath();
            }
        }
        if (string != null) {
            return string + File.separator + PLAN_DIR_NAME;
        }
        return null;
    }

    @Override
    public void activate() throws ModuleException {
        _logger.info(this.getLogPrefix() + ":activate()");
        Map map = this._applicationContext.getApplicationParameters();
        if (map == Collections.EMPTY_MAP || map == null) {
            this._applicationContext.setApplicationParameters(new HashMap());
        }
        this._applicationContext.getApplicationParameters().put("weblogic.metadata.management.AnnotationOverrideDescriptors", this._descriptorMap);
        this._applicationContext.getApplicationParameters().put("weblogic.metadata.management.AnnotationOverrideDescriptorsVersionID", this._overrideVersion);
    }

    @Override
    public boolean acceptURI(String string) {
        return string != null && string.endsWith(PLAN_UPDATE_URI);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareUpdate(String string) throws ModuleException {
        _logger.info(this.getLogPrefix() + ":prepareUpdate()");
        LinkedList<DescriptorBean> linkedList = new LinkedList<DescriptorBean>();
        this._pendingUpdateDescriptors.put(string, linkedList);
        String string2 = AnnotationOverridesModule.getModuleNameFromURI(string);
        if (string2 == null || string2.length() <= 0) throw new ModuleException(this.getLogPrefix() + " Unexpected uri format: " + string);
        Map<String, DescriptorBean> map = this.getAnnotationOverrideDescriptors();
        DescriptorBean descriptorBean = map.get(string2);
        DescriptorBean descriptorBean2 = this._descriptorMap.get(string2);
        if (descriptorBean == null || descriptorBean2 == null) {
            return;
        }
        try {
            AnnotationOverridesBean annotationOverridesBean = (AnnotationOverridesBean)descriptorBean;
            AnnotationOverridesBean annotationOverridesBean2 = (AnnotationOverridesBean)descriptorBean2;
            DescriptorDiff descriptorDiff = descriptorBean2.getDescriptor().computeDiff(descriptorBean.getDescriptor());
            if (descriptorDiff.size() <= 0) return;
            _logger.info(this.getLogPrefix() + ":[moduleName:" + string2 + "] had diffs, # of diffs = " + descriptorDiff.size());
            annotationOverridesBean.setUpdateCount(annotationOverridesBean2.getUpdateCount() + 1L);
            descriptorBean2.getDescriptor().prepareUpdate(descriptorBean.getDescriptor());
            linkedList.add(descriptorBean2);
            return;
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            _logger.error(this.getLogPrefix() + ":prepareUpdate()", (Throwable)descriptorUpdateRejectedException);
            this._pendingUpdateDescriptors.remove(string);
            throw new ModuleException("Failed on module:" + string2, descriptorUpdateRejectedException);
        }
    }

    @Override
    public void activateUpdate(String string) throws ModuleException {
        _logger.info(this.getLogPrefix() + ":activateUpdate()");
        boolean bl = false;
        List<DescriptorBean> list = this._pendingUpdateDescriptors.remove(string);
        for (DescriptorBean descriptorBean : list) {
            try {
                descriptorBean.getDescriptor().activateUpdate();
            }
            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                _logger.error(this.getLogPrefix() + ":activateUpdate()" + (Object)((Object)descriptorUpdateFailedException));
                bl = true;
            }
        }
        if (!bl) {
            this._applicationContext.getApplicationParameters().put("weblogic.metadata.management.AnnotationOverrideDescriptorsVersionID", ++this._overrideVersion);
        }
    }

    @Override
    public void start() throws ModuleException {
    }

    @Override
    public void deactivate() throws ModuleException {
    }

    @Override
    public void unprepare() throws ModuleException {
    }

    @Override
    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        registration.removeUpdateListener(this);
    }

    @Override
    public void rollbackUpdate(String string) {
    }

    @Override
    public void remove() throws ModuleException {
    }

    private static String getModuleNameFromURI(String string) {
        if (string != null && string.length() > 0) {
            if (string.equals(PLAN_UPDATE_URI)) {
                return "__WLS ROOT MODULE URI__";
            }
            int n = string.indexOf(PLAN_UPDATE_URI);
            if (n > 0) {
                return string.substring(0, n - 1);
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        DescriptorManager descriptorManager = new DescriptorManager();
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream("D:/Development/oamApp/plan/OAMPgFlowWeb/META-INF/annotation-overrides.xml");
            Descriptor descriptor = descriptorManager.createDescriptor((InputStream)fileInputStream);
            AnnotationOverridesBean annotationOverridesBean = (AnnotationOverridesBean)descriptor.getRootBean();
            outputStream = new FileOutputStream("D:/temp/anno-ovr.xml");
            descriptorManager.writeDescriptorAsXML(descriptor, (OutputStream)new BufferedOutputStream(outputStream));
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (outputStream != null) {
                outputStream.flush();
            }
        }
    }
}

