/*
 * Decompiled with CFR 0.152.
 */
package weblogic.metadata.management;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import weblogic.j2ee.descriptor.wl.AnnotationInstanceBean;
import weblogic.j2ee.descriptor.wl.ArrayMemberBean;
import weblogic.j2ee.descriptor.wl.MemberBean;
import weblogic.j2ee.descriptor.wl.NestedAnnotationBean;

public class AnnotationProxy
implements InvocationHandler {
    private AnnotationInstanceBean _annotationOverrides;
    private String _annotationClassName;
    private HashSet<String> _annotationMembers = new HashSet();
    private Annotation _originalAnnotation;

    public static Annotation newInstance(Class clazz, AnnotationInstanceBean annotationInstanceBean) {
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?>[] classArray = clazz.getInterfaces();
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new AnnotationProxy(clazz, annotationInstanceBean));
        return (Annotation)object;
    }

    private AnnotationProxy(Class clazz, AnnotationInstanceBean annotationInstanceBean) {
        this._annotationClassName = clazz.getName();
        this._annotationOverrides = annotationInstanceBean;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._annotationMembers.add(methodArray[i].getName());
        }
    }

    public void setDelegate(Annotation annotation) {
        this._originalAnnotation = annotation;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        assert (objectArray == null);
        Object object2 = null;
        String string = method.getName();
        if (!this._annotationMembers.contains(string)) {
            object2 = this._originalAnnotation == null ? method.invoke((Object)this, objectArray) : method.invoke((Object)this._originalAnnotation, objectArray);
            return object2;
        }
        Class<?> clazz = method.getReturnType();
        return AnnotationProxy.getValueForMember(string, clazz, this._annotationOverrides);
    }

    public static Object getValueForMember(MemberBean memberBean, Class clazz, AnnotationInstanceBean annotationInstanceBean) throws NoSuchMethodException {
        String string = memberBean.getMemberName();
        Method method = clazz.getDeclaredMethod(string, new Class[0]);
        Class<?> clazz2 = method.getReturnType();
        return AnnotationProxy.getValueForMember(string, clazz2, annotationInstanceBean);
    }

    public static Object getValueForMember(String string, Class clazz, AnnotationInstanceBean annotationInstanceBean) {
        Object object = null;
        try {
            if (clazz.isArray()) {
                String[] stringArray;
                if (Annotation.class.isAssignableFrom(clazz.getComponentType())) {
                    throw new RuntimeException("Arrays of annotations not yet implemented");
                }
                ArrayMemberBean[] arrayMemberBeanArray = annotationInstanceBean.getArrayMembers();
                ArrayMemberBean arrayMemberBean = AnnotationProxy.findMemberArray(arrayMemberBeanArray, string);
                if (arrayMemberBean != null && (stringArray = arrayMemberBean.getOverrideValues()) != null && stringArray.length > 0) {
                    object = AnnotationProxy.buildReturnValues(clazz, stringArray, annotationInstanceBean, string);
                }
            } else {
                String string2;
                MemberBean memberBean = AnnotationProxy.findMember(annotationInstanceBean.getMembers(), string);
                if (memberBean != null && (string2 = memberBean.getOverrideValue()) != null && !string2.trim().equals("")) {
                    object = AnnotationProxy.buildReturnValue(clazz, string2, annotationInstanceBean, string);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error Getting Override Value. method:" + string, exception);
        }
        return object;
    }

    private static NestedAnnotationBean findNestedAnnotation(NestedAnnotationBean[] nestedAnnotationBeanArray, String string) {
        NestedAnnotationBean nestedAnnotationBean = null;
        for (int i = 0; i < nestedAnnotationBeanArray.length; ++i) {
            if (!nestedAnnotationBeanArray[i].getMemberName().equals(string)) continue;
            nestedAnnotationBean = nestedAnnotationBeanArray[i];
        }
        return nestedAnnotationBean;
    }

    private static ArrayMemberBean findMemberArray(ArrayMemberBean[] arrayMemberBeanArray, String string) {
        ArrayMemberBean arrayMemberBean = null;
        for (int i = 0; i < arrayMemberBeanArray.length; ++i) {
            if (!arrayMemberBeanArray[i].getMemberName().equals(string)) continue;
            arrayMemberBean = arrayMemberBeanArray[i];
        }
        assert (arrayMemberBean != null);
        return arrayMemberBean;
    }

    private static MemberBean findMember(MemberBean[] memberBeanArray, String string) {
        MemberBean memberBean = null;
        for (int i = 0; i < memberBeanArray.length; ++i) {
            if (!memberBeanArray[i].getMemberName().equals(string)) continue;
            memberBean = memberBeanArray[i];
        }
        assert (memberBean != null);
        return memberBean;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object buildReturnValues(Class clazz, String[] stringArray, AnnotationInstanceBean annotationInstanceBean, String string) {
        void var4_15;
        assert (clazz.isArray());
        assert (stringArray != null);
        Object var4_4 = null;
        Class<?> clazz2 = clazz.getComponentType();
        int n = stringArray.length;
        if (clazz2 == String.class) {
            String[] stringArray2 = stringArray;
            return var4_15;
        } else if (clazz2.isPrimitive()) {
            if (clazz2 == Byte.TYPE) {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = Byte.valueOf(stringArray[i]);
                }
                byte[] byArray2 = byArray;
                return var4_15;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = Short.valueOf(stringArray[i]);
                }
                short[] sArray2 = sArray;
                return var4_15;
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.valueOf(stringArray[i]);
                }
                int[] nArray2 = nArray;
                return var4_15;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = Long.valueOf(stringArray[i]);
                }
                long[] lArray2 = lArray;
                return var4_15;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.valueOf(stringArray[i]);
                }
                double[] dArray2 = dArray;
                return var4_15;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = Float.valueOf(stringArray[i]).floatValue();
                }
                float[] fArray2 = fArray;
                return var4_15;
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = stringArray[i].charAt(0);
                }
                char[] cArray2 = cArray;
                return var4_15;
            } else {
                if (clazz2 != Boolean.TYPE) throw new RuntimeException("Unknown primitive type:" + clazz2.getName());
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = Boolean.valueOf(stringArray[i]);
                }
                boolean[] blArray2 = blArray;
            }
            return var4_15;
        } else {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = AnnotationProxy.buildReturnValue(clazz2, stringArray[i], annotationInstanceBean, string);
            }
            Object[] objectArray2 = objectArray;
        }
        return var4_15;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object buildReturnValue(Class clazz, String string, AnnotationInstanceBean annotationInstanceBean, String string2) {
        Byte by = null;
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return Byte.valueOf(string);
            }
            if (clazz == Short.TYPE) {
                return Short.valueOf(string);
            }
            if (clazz == Integer.TYPE) {
                return Integer.valueOf(string);
            }
            if (clazz == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (clazz == Double.TYPE) {
                return Double.valueOf(string);
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(string);
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz != Boolean.TYPE) throw new RuntimeException("Unknown primitive type:" + clazz.getName());
            return Boolean.valueOf(string);
        }
        if (clazz.equals(String.class)) {
            return string;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Enum.valueOf(clazz, string);
        }
        if (Class.class.isAssignableFrom(clazz)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(AnnotationProxy.class.getName() + ": unable to load class: " + string);
            }
            return by;
        } else {
            if (!Annotation.class.isAssignableFrom(clazz)) throw new RuntimeException("Unknown Member Type:" + clazz);
            NestedAnnotationBean nestedAnnotationBean = AnnotationProxy.findNestedAnnotation(annotationInstanceBean.getNestedAnnotations(), string2);
            if (nestedAnnotationBean == null) throw new RuntimeException("unable to find NestedAnnotationBean - memberName = " + string2);
            AnnotationInstanceBean annotationInstanceBean2 = nestedAnnotationBean.getAnnotation();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz2 = classLoader.loadClass(annotationInstanceBean2.getAnnotationClassName());
                return AnnotationProxy.newInstance(clazz2, annotationInstanceBean2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(AnnotationProxy.class.getName() + ": unable to load class: " + string);
            }
        }
        return by;
    }
}

