/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.KernelStatus;
import weblogic.net.http.AsyncResponseCallback;
import weblogic.net.http.ContextAwareAsyncResponseCallback;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.HttpsURLConnection;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.JSSESocket;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketMuxer;
import weblogic.socket.utils.JSSEUtils;
import weblogic.utils.Debug;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.work.ContextWrap;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class AsyncResponseHandler {
    private static boolean disableAsyncResponse = Boolean.getBoolean("weblogic.http.DisableAsyncResponse");
    private static boolean disableAsyncResponseForHTTPS = Boolean.getBoolean("weblogic.http.DisableAsyncResponseForHTTPS");

    private AsyncResponseHandler() {
    }

    public static AsyncResponseHandler getInstance() {
        return Factory.THE_ONE;
    }

    public static void disableAsyncResponse() {
        disableAsyncResponse = true;
    }

    public static void disableAsyncResponseForHTTPS() {
        disableAsyncResponseForHTTPS = true;
    }

    public void writeRequestAndRegister(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback) throws IOException {
        this.writeRequestAndRegister(httpURLConnection, asyncResponseCallback, WorkManagerFactory.getInstance().getDefault());
    }

    public void writeRequestAndRegister(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, String string) throws IOException {
        WorkManager workManager = WorkManagerFactory.getInstance().find(string);
        if (workManager == null) {
            throw new IllegalArgumentException("WorkManager with name '" + string + "' cannot be found");
        }
        this.writeRequestAndRegister(httpURLConnection, asyncResponseCallback, workManager);
    }

    public void writeRequestAndRegister(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
        if (this.handleSynchronously(httpURLConnection, asyncResponseCallback, workManager)) {
            return;
        }
        Debug.assertion((boolean)KernelStatus.isServer(), (String)"HTTP async response API cannot be used on clients");
        Debug.assertion((boolean)httpURLConnection.isConnected(), (String)"HTTP async response API cannot be invoked on a disconnected HttpURLConnection");
        if (workManager == null) {
            throw new IllegalArgumentException("WorkManager cannot be null !");
        }
        httpURLConnection.writeRequestForAsyncResponse();
        MuxableSocketHTTPAsyncResponse muxableSocketHTTPAsyncResponse = this.getExistingMuxableSocket(httpURLConnection);
        if (muxableSocketHTTPAsyncResponse != null) {
            muxableSocketHTTPAsyncResponse.reRegister(httpURLConnection, asyncResponseCallback, workManager);
            AsyncResponseHandler.reRegisterWithMuxer(muxableSocketHTTPAsyncResponse);
        }
        if (muxableSocketHTTPAsyncResponse == null) {
            this.registerWithMuxer(httpURLConnection, asyncResponseCallback, workManager);
        }
    }

    private void registerWithMuxer(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
        MuxableSocketHTTPAsyncResponse muxableSocketHTTPAsyncResponse = new MuxableSocketHTTPAsyncResponse(httpURLConnection, asyncResponseCallback, workManager);
        httpURLConnection.setMuxableSocket(muxableSocketHTTPAsyncResponse);
        if (httpURLConnection instanceof HttpsURLConnection) {
            SSLSocket sSLSocket = (SSLSocket)httpURLConnection.getSocket();
            JSSESocket jSSESocket = JSSEUtils.getJSSESocket(sSLSocket);
            if (jSSESocket != null) {
                JSSEUtils.registerJSSEFilter(jSSESocket, muxableSocketHTTPAsyncResponse);
                if (muxableSocketHTTPAsyncResponse.isMessageComplete()) {
                    muxableSocketHTTPAsyncResponse.dispatch();
                } else {
                    SocketMuxer.getMuxer().read(jSSESocket.getFilter());
                }
                httpURLConnection.setScavenger(new Scavenger(jSSESocket.getFilter()));
            } else {
                SSLIOContext sSLIOContext = SSLIOContextTable.findContext(sSLSocket);
                SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
                muxableSocketHTTPAsyncResponse.setSocketFilter(sSLFilter);
                sSLFilter.setDelegate(muxableSocketHTTPAsyncResponse);
                sSLFilter.activateNoRegister();
                SocketMuxer.getMuxer().register(sSLFilter);
                SocketMuxer.getMuxer().read(sSLFilter);
                httpURLConnection.setScavenger(new Scavenger(sSLFilter));
            }
        } else {
            SocketMuxer.getMuxer().register(muxableSocketHTTPAsyncResponse);
            httpURLConnection.setScavenger(new Scavenger(muxableSocketHTTPAsyncResponse));
            SocketMuxer.getMuxer().read(muxableSocketHTTPAsyncResponse);
        }
    }

    private static void reRegisterWithMuxer(MuxableSocket muxableSocket) {
        MuxableSocket muxableSocket2 = muxableSocket.getSocketFilter();
        if (muxableSocket2 instanceof SSLFilter) {
            ((SSLFilter)muxableSocket2).asyncOn();
        }
        SocketMuxer.getMuxer().read(muxableSocket2);
    }

    private MuxableSocketHTTPAsyncResponse getExistingMuxableSocket(HttpURLConnection httpURLConnection) {
        return (MuxableSocketHTTPAsyncResponse)httpURLConnection.getMuxableSocket();
    }

    private boolean handleSynchronously(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
        if (disableAsyncResponse) {
            this.bypassMuxer(httpURLConnection, asyncResponseCallback, workManager);
            return true;
        }
        if (disableAsyncResponseForHTTPS && httpURLConnection instanceof HttpsURLConnection) {
            this.bypassMuxer(httpURLConnection, asyncResponseCallback, workManager);
            return true;
        }
        return false;
    }

    private void bypassMuxer(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
        httpURLConnection.writeRequests();
        workManager.schedule((Runnable)new MuxableSocketHTTPAsyncResponse.RunnableCallback(asyncResponseCallback, httpURLConnection));
    }

    private static class Scavenger
    implements Runnable {
        private MuxableSocket ms;

        Scavenger(MuxableSocket muxableSocket) {
            this.ms = muxableSocket;
        }

        public void run() {
            SocketMuxer.getMuxer().closeSocket(this.ms);
        }
    }

    static class MuxableSocketHTTPAsyncResponse
    extends AbstractMuxableSocket {
        private static final boolean DEBUG = false;
        private AsyncResponseCallback callback;
        private HttpURLConnection connection;
        private InputStream socketInputStream;
        private WorkManager workManager;
        private Runnable runnable;
        private Throwable exception;
        private boolean responseAvailable;

        MuxableSocketHTTPAsyncResponse(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
            super(Chunk.getChunk(), httpURLConnection.getSocket(), ServerChannelManager.findDefaultLocalServerChannel());
            this.init(httpURLConnection, asyncResponseCallback, workManager);
        }

        public synchronized int getIdleTimeoutMillis() {
            if (this.connection != null && this.connection.getTimeout() > 0) {
                return this.connection.getTimeout();
            }
            return super.getIdleTimeoutMillis();
        }

        public boolean isMessageComplete() {
            return true;
        }

        public synchronized void dispatch() {
            if (this.connection != null && this.workManager != null) {
                this.invokeCallback();
            } else {
                this.responseAvailable = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeCallback() {
            try {
                Object object;
                if (this.getSocketFilter() instanceof SSLFilter) {
                    object = (SSLFilter)this.getSocketFilter();
                    object.asyncOff();
                }
                object = new SequenceInputStream((InputStream)new ChunkedInputStream(this.head, 0), this.socketInputStream);
                this.connection.setInputStream((InputStream)object);
                this.responseAvailable = false;
                this.workManager.schedule(this.runnable);
            }
            finally {
                this.reset();
            }
        }

        private synchronized void handleError(Throwable throwable) {
            if (this.workManager != null) {
                this.invokeCallbackWithErrorStream(new SocketClosedNotification());
            } else {
                this.exception = throwable;
            }
        }

        private synchronized void handleTimeout() {
            if (this.connection == null || this.workManager == null) {
                return;
            }
            this.invokeCallbackWithErrorStream(new SocketTimeoutNotification());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeCallbackWithErrorStream(InputStream inputStream) {
            try {
                this.connection.setInputStream(inputStream);
                this.responseAvailable = false;
                this.workManager.schedule(this.runnable);
            }
            finally {
                this.reset();
            }
        }

        private void init(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
            this.callback = asyncResponseCallback;
            this.connection = httpURLConnection;
            this.socketInputStream = new BufferedInputStream(httpURLConnection.getSocket().getInputStream());
            this.workManager = workManager;
            this.runnable = this.getRunnable();
        }

        public boolean closeSocketOnError() {
            return false;
        }

        private void reset() {
            this.callback = null;
            this.connection = null;
            this.workManager = null;
            this.runnable = null;
            this.socketInputStream = null;
            this.responseAvailable = false;
            this.prepareForReuse();
        }

        synchronized void reRegister(HttpURLConnection httpURLConnection, AsyncResponseCallback asyncResponseCallback, WorkManager workManager) throws IOException {
            if (this.exception != null) {
                String string = this.exception.getMessage();
                this.exception = null;
                throw new IOException(string);
            }
            this.init(httpURLConnection, asyncResponseCallback, workManager);
            if (this.responseAvailable) {
                this.invokeCallback();
            }
        }

        public void hasException(Throwable throwable) {
            super.hasException(throwable);
            this.handleError(throwable);
        }

        public void endOfStream() {
            super.endOfStream();
            this.handleError(new IOException("End of stream delivered on " + this));
        }

        public boolean timeout() {
            this.handleTimeout();
            return true;
        }

        private Runnable getRunnable() {
            RunnableCallback runnableCallback = new RunnableCallback(this.callback, this.connection);
            if (this.callback instanceof ContextAwareAsyncResponseCallback) {
                return new ContextWrap(runnableCallback);
            }
            return runnableCallback;
        }

        private void debug(String string) {
        }

        private static class SocketClosedNotification
        extends InputStream {
            private static final IOException IOE = new IOException("SocketMuxer detected socket closure while waiting for a response");

            private SocketClosedNotification() {
            }

            public int read() throws IOException {
                throw IOE;
            }
        }

        private static class SocketTimeoutNotification
        extends InputStream {
            private static final SocketTimeoutException STOE = new SocketTimeoutException();

            private SocketTimeoutNotification() {
            }

            public int read() throws IOException {
                throw STOE;
            }
        }

        private static class RunnableCallback
        implements Runnable {
            private final AsyncResponseCallback callback;
            private final HttpURLConnection connection;

            RunnableCallback(AsyncResponseCallback asyncResponseCallback, HttpURLConnection httpURLConnection) {
                this.callback = asyncResponseCallback;
                this.connection = httpURLConnection;
            }

            public void run() {
                this.callback.handleResponse(this.connection);
            }
        }
    }

    private static final class Factory {
        static final AsyncResponseHandler THE_ONE = new AsyncResponseHandler();

        private Factory() {
        }
    }
}

