/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public final class ContentLengthOutputStream
extends OutputStream {
    private boolean closed;
    private int count;
    private int clen;
    private OutputStream os;

    public ContentLengthOutputStream(OutputStream outputStream, int n) {
        this.os = outputStream;
        this.clen = n;
        this.closed = false;
        this.count = 0;
    }

    public synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (this.count + 1 > this.clen) {
            throw new ProtocolException("Exceeding stated content length of " + this.clen);
        }
        this.os.write(n);
        ++this.count;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (this.count + n2 > this.clen) {
            throw new ProtocolException("Exceeding stated content length of " + this.clen);
        }
        this.os.write(byArray, n, n2);
        this.count += n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.count != this.clen) {
            throw new ProtocolException("Did not meet stated content length of OutputStream:  you wrote " + this.count + " bytes and I was expecting " + " you to write exactly " + this.clen + " bytes!!!");
        }
        this.closed = true;
        this.os.flush();
    }
}

