/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Properties;
import weblogic.net.NetLogger;
import weblogic.net.http.NETEnvironment;
import weblogic.net.http.SOAPHttpURLConnection;
import weblogic.net.http.SOAPHttpsURLConnection;

public class Handler
extends URLStreamHandler {
    private boolean isHTTP = true;
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String[] NEEDED_CLASSES = new String[]{"weblogic.net.http.Handler", "weblogic.net.http.Handler$1", "weblogic.net.http.HttpClient", "weblogic.net.http.HttpOutputStream", "weblogic.net.http.HttpURLConnection", "weblogic.net.http.HttpUnauthorizedException", "weblogic.net.http.KeepAliveCache", "weblogic.net.http.KeepAliveStream", "weblogic.net.http.MessageHeader", "weblogic.net.http.KeepAliveKey", "weblogic.net.http.HttpsURLConnection", "weblogic.net.http.HttpsClient"};
    private static boolean inited = false;

    public Handler() {
    }

    public Handler(boolean bl) {
        this.isHTTP = bl;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return this.openConnection(uRL, null);
    }

    protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        String string = uRL.getProtocol().toLowerCase();
        if (string.equals("http")) {
            return new SOAPHttpURLConnection(uRL, proxy);
        }
        if (string.equals("https")) {
            return new SOAPHttpsURLConnection(uRL, proxy);
        }
        return null;
    }

    protected int getDefaultPort() {
        return this.isHTTP ? 80 : 443;
    }

    public static void init() {
        if (NETEnvironment.getNETEnvironment().useSunHttpHandler()) {
            return;
        }
        if (inited) {
            return;
        }
        inited = true;
        try {
            if (Boolean.getBoolean("UseSunHttpHandler")) {
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            String string;
            String string2 = System.getProperty("javaplugin.enabled");
            for (int i = 0; i < NEEDED_CLASSES.length; ++i) {
                try {
                    Class.forName(NEEDED_CLASSES[i]);
                    continue;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (string2 == null || string2.equals("false")) {
                Properties properties = System.getProperties();
                String string3 = properties.getProperty("java.protocol.handler.pkgs");
                string3 = string3 == null ? "weblogic.net" : string3 + "|weblogic.net";
                properties.put("java.protocol.handler.pkgs", string3);
                System.setProperties(properties);
            }
            if ((string = System.getProperty("weblogic.net.http.URLStreamHandlerFactory")) != null) {
                boolean bl = false;
                try {
                    Class<?> clazz = Class.forName(string);
                    Class[] classArray = new Class[]{String[].class};
                    Object[] objectArray = new Object[]{new String[0]};
                    clazz.getMethod("main", classArray).invoke(null, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    bl = true;
                    NetLogger.logHandlerInitFailure((String)"IllegalAccessException", (String)string, (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    bl = true;
                    NetLogger.logHandlerInitFailure((String)"InvocationTargetException", (String)string, (Throwable)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl = true;
                    NetLogger.logHandlerInitFailure((String)"NoSuchMethodException", (String)string, (Throwable)noSuchMethodException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                    NetLogger.logHandlerInitFailure((String)"ClassNotFoundException", (String)string, (Throwable)classNotFoundException);
                }
                catch (Error error) {
                    bl = true;
                    NetLogger.logHandlerInitFailure((String)"Error", (String)string, (Throwable)error);
                }
                if (!bl) {
                    return;
                }
            }
            URLStreamHandlerFactory uRLStreamHandlerFactory = new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String string) {
                    if ("http".equals(string)) {
                        return new Handler(true);
                    }
                    if ("https".equals(string)) {
                        return new Handler(false);
                    }
                    return null;
                }
            };
            if (string2 == null || string2.equals("false")) {
                URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
            }
        }
        catch (SecurityException securityException) {
            System.out.println("caught a SecurityException.  That's OK.");
            return;
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

