/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import weblogic.net.NetLogger;
import weblogic.net.http.HttpOutputStream;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.KeepAliveCache;
import weblogic.net.http.KeepAliveStream;
import weblogic.net.http.MessageHeader;
import weblogic.socket.WeblogicSocketFactory;
import weblogic.socket.utils.RegexpPool;
import weblogic.utils.http.HttpChunkInputStream;

class HttpClient {
    public static final String HTTP_10 = "HTTP/1.0";
    public static final String HTTP_11 = "HTTP/1.1";
    private static final int httpPortNumber = 80;
    protected Proxy instProxy;
    static String proxyHost = null;
    static int proxyPort = 80;
    private static KeepAliveCache kac = new KeepAliveCache();
    protected InputStream kas;
    protected Socket serverSocket;
    protected HttpOutputStream serverOutput;
    protected InputStream serverInput;
    protected boolean usingHttp11;
    private SocketFactory socketFactory;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected int numReq = 0;
    private static boolean keepAliveProp = true;
    boolean keepingAlive = false;
    protected int readTimeout = -1;
    protected int connectTimeout = -1;
    protected URL url;
    protected HttpURLConnection connection;
    protected boolean ignoreSystemNonPorxyHosts = false;
    protected static RegexpPool dontProxy;
    long lastUsed = System.currentTimeMillis();
    protected Object muxableSocket;
    protected Runnable scavenger;

    private static void resetProperties() {
        try {
            String string;
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = Integer.getInteger("http.proxyPort", 80);
            if (proxyHost == null) {
                proxyHost = System.getProperty("proxyHost");
                proxyPort = Integer.getInteger("proxyPort", 80);
            }
            if (proxyHost != null && proxyHost.length() == 0) {
                proxyHost = null;
            }
            if ((string = System.getProperty("http.nonProxyHosts")) == null) {
                string = System.getProperty("nonProxyHosts");
            }
            if (string != null) {
                dontProxy = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    if (dontProxy.add(stringTokenizer.nextToken().toLowerCase())) continue;
                    bl = true;
                }
                if (bl) {
                    NetLogger.logDuplicateExpression((String)"http", (String)string, null);
                }
            }
        }
        catch (SecurityException securityException) {
            proxyHost = null;
            proxyPort = 80;
        }
    }

    protected HttpClient(URL uRL, Proxy proxy, SocketFactory socketFactory, boolean bl, int n, int n2, boolean bl2) throws IOException {
        this.url = uRL;
        this.port = uRL.getPort();
        this.host = uRL.getHost();
        this.setSocketFactory(socketFactory);
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setReadTimeout(n2);
        this.connectTimeout = n;
        this.instProxy = proxy == null ? Proxy.NO_PROXY : proxy;
        this.numReq = 0;
        this.usingHttp11 = bl;
        this.ignoreSystemNonPorxyHosts = bl2;
    }

    public void setHttp11(boolean bl) {
        this.usingHttp11 = bl;
    }

    public String toString() {
        return super.toString() + "[url:" + this.url + " sock:" + this.serverSocket + " requests:" + this.numReq + " ka:" + this.keepingAlive + "]";
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    void setKeepingAlive(boolean bl) {
        this.keepingAlive = bl;
    }

    public InputStream getInputStream() {
        if (this.kas != null) {
            return this.kas;
        }
        return this.serverInput;
    }

    public HttpOutputStream getOutputStream() {
        return this.serverOutput;
    }

    Proxy getProxy() {
        return this.instProxy;
    }

    URL getURL() {
        return this.url;
    }

    Object getClientInfo() {
        return null;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory == null ? SocketFactory.getDefault() : this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    protected int getDefaultPort() {
        return 80;
    }

    protected static HttpClient findInCache(URL uRL, Object object, Proxy proxy) {
        return kac.get(uRL, object, proxy);
    }

    static HttpClient New(URL uRL, Proxy proxy, SocketFactory socketFactory, boolean bl, int n, int n2, boolean bl2, boolean bl3) throws IOException {
        HttpClient httpClient = null;
        if (bl2) {
            httpClient = HttpClient.findInCache(uRL, null, proxy);
        }
        if (httpClient == null) {
            httpClient = new HttpClient(uRL, proxy, socketFactory, bl, n, n2, bl3);
            httpClient.openServer();
        } else {
            httpClient.url = uRL;
            httpClient.setReadTimeout(n2 < 0 ? 0 : n2);
            httpClient.setHttp11(bl);
        }
        return httpClient;
    }

    public static void finished(HttpClient httpClient) {
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("Closing " + httpClient);
        }
        if (httpClient.isKeepingAlive()) {
            ++httpClient.numReq;
            httpClient.kas = null;
            httpClient.usingHttp11 = false;
            if (httpClient.connection != null) {
                httpClient.connection.finish();
                httpClient.connection = null;
            }
            kac.put(httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    public void setLastUsed(long l) {
        this.lastUsed = l;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    protected void openServer(String string, int n) throws IOException {
        this.resetAsyncState();
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        for (int i = 0; i < inetAddressArray.length; ++i) {
            try {
                if (this.connectTimeout > 0) {
                    SocketFactory socketFactory = this.getSocketFactory();
                    if (socketFactory instanceof WeblogicSocketFactory) {
                        this.serverSocket = ((WeblogicSocketFactory)socketFactory).createSocket(inetAddressArray[i], n, this.connectTimeout);
                        break;
                    }
                    this.serverSocket = this.getSocketFactory().createSocket();
                    this.serverSocket.connect(new InetSocketAddress(inetAddressArray[i], n), this.connectTimeout);
                    break;
                }
                this.serverSocket = this.getSocketFactory().createSocket(inetAddressArray[i], n);
                break;
            }
            catch (ConnectException connectException) {
                continue;
            }
        }
        if (this.serverSocket == null) {
            throw new ConnectException("Tried all: '" + inetAddressArray.length + "' addresses, but could not connect" + " over HTTP to server: '" + string + "', port: '" + n + "'");
        }
        this.serverSocket.setTcpNoDelay(true);
        if (this.readTimeout > -1) {
            this.serverSocket.setSoTimeout(this.readTimeout);
        }
        this.serverOutput = new HttpOutputStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected String getProtocol() {
        return "http";
    }

    protected static boolean isProxyAllowed(String string) {
        boolean bl = true;
        if (dontProxy != null) {
            if (dontProxy.match(string)) {
                bl = false;
            } else {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    String string2 = inetAddress.getHostName();
                    if (dontProxy.match(string2)) {
                        bl = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected synchronized void openServer() throws IOException {
        HttpClient.resetProperties();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.isKeepingAlive()) {
            return;
        }
        String string = this.url.getProtocol();
        if (!this.getProtocol().equals(string)) {
            throw new ProtocolException("Unsupported protocol: " + string + "'");
        }
        if (this.instProxy != Proxy.NO_PROXY && (this.ignoreSystemNonPorxyHosts || HttpClient.isProxyAllowed(this.host))) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.instProxy.address();
            try {
                this.openServer(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                NetLogger.logIOException((String)inetSocketAddress.getHostName(), (String)("" + inetSocketAddress.getPort()), (String)this.host, (String)("" + this.port), (Throwable)iOException);
                throw iOException;
            }
        }
        if (proxyHost != null && HttpClient.isProxyAllowed(this.host)) {
            try {
                this.openServer(proxyHost, proxyPort);
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                NetLogger.logIOException((String)proxyHost, (String)("" + proxyPort), (String)this.host, (String)("" + this.port), (Throwable)iOException);
            }
        }
        this.openServer(this.host, this.port);
    }

    public String getURLFile() {
        if (this.usingProxy) {
            String string = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string = string + ":" + this.url.getPort();
            }
            return string + this.url.getFile();
        }
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        return string;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
        if (this.serverSocket != null && this.readTimeout > -1) {
            try {
                this.serverSocket.setSoTimeout(this.readTimeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    void setConnection(HttpURLConnection httpURLConnection) {
        this.connection = httpURLConnection;
    }

    void parseHTTP(MessageHeader messageHeader) throws IOException {
        this.keepingAlive = false;
        try {
            messageHeader.parseHeader(this.serverInput);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.resetAsyncState();
            throw interruptedIOException;
        }
        String string = messageHeader.getValue(0);
        boolean bl = string != null && string.startsWith(HTTP_11);
        int n = -1;
        try {
            n = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.usingHttp11) {
            this.keepingAlive = true;
        }
        String string2 = null;
        if (this.usingProxy) {
            string2 = messageHeader.findValue("Proxy-Connection");
        }
        if (string2 == null) {
            string2 = messageHeader.findValue("Connection");
        }
        if (string2 != null) {
            if ((string2 = string2.toLowerCase()).equals("keep-alive")) {
                if (n > 0) {
                    this.keepingAlive = true;
                }
            } else if (string2.equals("close")) {
                this.keepingAlive = false;
            }
        } else if (!bl) {
            this.keepingAlive = false;
        }
        this.kas = this.serverInput;
        if (this.usingHttp11) {
            String string3 = messageHeader.findValue("Transfer-Encoding");
            if (string3 != null && string3.equalsIgnoreCase("chunked")) {
                this.kas = new HttpChunkInputStream(this.serverInput);
                n = -1;
            } else if (n == -1) {
                this.keepingAlive = false;
            }
        }
        this.kas = new KeepAliveStream(this, this.kas, n);
    }

    void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
            this.resetAsyncState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("Closed " + this);
        }
    }

    protected void finalize() throws Throwable {
        this.resetAsyncState();
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    Socket getSocket() {
        return this.serverSocket;
    }

    void setInputStream(InputStream inputStream) {
        this.serverInput = inputStream;
    }

    void setMuxableSocket(Object object) {
        this.muxableSocket = object;
    }

    Object getMuxableSocket() {
        return this.muxableSocket;
    }

    private void resetAsyncState() {
        if (this.scavenger != null) {
            try {
                this.scavenger.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.muxableSocket = null;
        this.scavenger = null;
    }

    void setScavenger(Runnable runnable) {
        this.scavenger = runnable;
    }

    static {
        try {
            String string = System.getProperty("http.keepAlive");
            if (string != null) {
                keepAliveProp = Boolean.valueOf(string);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

