/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.net.SocketFactory;
import weblogic.common.ProxyAuthenticator;
import weblogic.net.http.ContentLengthOutputStream;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpUnauthorizedException;
import weblogic.net.http.MessageHeader;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.http.HttpChunkOutputStream;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpReasonPhraseCoder;
import weblogic.utils.io.NullInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static String userAgent;
    private static boolean strictPostRedirect;
    private static String proxyAuthClassName;
    private static String proxyAuthString;
    private static boolean http11;
    private static boolean bufferPostForRetry;
    static final boolean debug;
    private static final String acceptString = "text/html, image/gif, image/jpeg, */*; q=.2";
    private static final int MAX_REDIRECTS = 5;
    private static final int MAX_TRIES = 3;
    private static final int MAX_LENGTH_OF_REQUEST_METHOD = 32;
    protected HttpClient http;
    protected Proxy instProxy;
    protected MessageHeader requests;
    protected MessageHeader responses;
    protected InputStream inputStream = null;
    protected OutputStream streamedPostOS = null;
    protected UnsyncByteArrayOutputStream bufferedPostOS = null;
    protected boolean setRequests = false;
    protected boolean useHttp11 = http11;
    private boolean wroteRequests = false;
    private SocketFactory socketFactory;
    private String redirectCookieStr = null;
    private static final String COOKIE_SEPARATOR = ";";
    private static boolean sendCookiesRedirect;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = defaultConnectTimeout;
    private int chunkLength = -1;
    private int fixedContentLength = -1;
    private static int defaultReadTimeout;
    protected static int defaultConnectTimeout;
    protected IOException rememberedException = null;
    protected boolean ignoreSystemNonPorxyHosts = false;
    private static SocketFactory defaultSocketFactory;

    public HttpURLConnection(URL uRL) {
        this(uRL, null);
    }

    public HttpURLConnection(URL uRL, Proxy proxy) {
        super(uRL);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.instProxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    protected String getProtocol() {
        return "http";
    }

    public final void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final SocketFactory getSocketFactory() {
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        return defaultSocketFactory;
    }

    public static void setDefaultSocketFactory(SocketFactory socketFactory) {
        defaultSocketFactory = socketFactory;
    }

    protected synchronized void writeRequests() throws IOException {
        if (this.wroteRequests) {
            return;
        }
        this.wroteRequests = true;
        if (!this.setRequests) {
            this.doSetRequests();
        }
        this.requests.print(this.http.getOutputStream());
        this.http.getOutputStream().flush();
        if (debug) {
            HttpURLConnection.p("wrote request - " + this.requests);
        }
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.bufferedPostOS != null) {
            this.bufferedPostOS.writeTo((OutputStream)this.http.getOutputStream());
            this.http.getOutputStream().flush();
        }
    }

    public void setIgnoreSystemNonPorxyHosts(boolean bl) {
        this.ignoreSystemNonPorxyHosts = bl;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            this.http = HttpClient.New(this.url, this.instProxy, this.getSocketFactory(), this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), true, this.ignoreSystemNonPorxyHosts);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.rememberedException = socketTimeoutException;
            throw socketTimeoutException;
        }
        this.http.setConnection(this);
        this.connected = true;
        if (debug) {
            HttpURLConnection.p("connected " + this.http + " HTTP/1." + (this.useHttp11 ? "1" : "0"));
        }
    }

    protected HttpClient getHttpClient() throws IOException {
        HttpClient httpClient = HttpClient.New(this.url, this.instProxy, this.getSocketFactory(), this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), false, this.ignoreSystemNonPorxyHosts);
        httpClient.setConnection(this);
        this.connected = true;
        if (debug) {
            HttpURLConnection.p("new HttpClient=" + httpClient);
        }
        return httpClient;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (("HEAD".equals(this.method) || "OPTIONS".equals(this.method) || "DELETE".equals(this.method) || "TRACE".equals(this.method)) && this.getProtocol().equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            String string = this.getRequestProperty("Content-Length");
            if (string == null && this.useHttp11 && this.fixedContentLength > 0) {
                string = Integer.toString(this.fixedContentLength);
                this.setRequestProperty("Content-Length", string);
            }
            if (!bufferPostForRetry && string != null) {
                this.connect();
                this.writeRequests();
                this.streamedPostOS = new ContentLengthOutputStream(this.http.getOutputStream(), Integer.parseInt(string));
                if (debug) {
                    HttpURLConnection.p("using content length streaming. CL=" + string);
                }
                return this.streamedPostOS;
            }
            if (!bufferPostForRetry && this.useHttp11 && this.chunkLength > 0) {
                this.setRequestProperty("Transfer-Encoding", "chunked");
                this.connect();
                this.writeRequests();
                this.streamedPostOS = new HttpChunkOutputStream((OutputStream)this.http.getOutputStream(), this.chunkLength);
                if (debug) {
                    HttpURLConnection.p("using chunked streaming. ChunkSize=" + this.chunkLength);
                }
                return this.streamedPostOS;
            }
            if (this.bufferedPostOS == null) {
                this.bufferedPostOS = new UnsyncByteArrayOutputStream();
            } else if (!this.connected) {
                this.bufferedPostOS.reset();
            }
            if (debug) {
                HttpURLConnection.p("using buffered stream");
            }
            return this.bufferedPostOS;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    protected static String getProxyAuthString() {
        return proxyAuthString;
    }

    public static String getAuthInfo(String string, int n, String string2) throws IOException {
        if (debug) {
            HttpURLConnection.p("getAuthInfo(" + string + ", " + n + ", " + string2 + ") called");
        }
        if (proxyAuthClassName == null || string2 == null) {
            throw new HttpUnauthorizedException("Proxy or Server Authentication Required");
        }
        if (debug) {
            HttpURLConnection.p("using ProxyAuthenticator = " + proxyAuthClassName);
        }
        ProxyAuthenticator proxyAuthenticator = null;
        String string3 = null;
        String string4 = null;
        String string5 = string2.trim();
        int n2 = string5.indexOf(32);
        if (n2 == -1) {
            string3 = string5;
            string4 = "Login to Proxy";
        } else {
            string3 = string5.substring(0, n2);
            string4 = string5.substring(n2 + 1);
            if ((n2 = string4.indexOf(61)) != -1) {
                string4 = string4.substring(n2 + 1);
            }
        }
        try {
            proxyAuthenticator = (ProxyAuthenticator)Class.forName(proxyAuthClassName).newInstance();
        }
        catch (Exception exception) {
            throw new HttpUnauthorizedException("Proxy authenticator " + proxyAuthClassName + " failed: " + exception);
        }
        proxyAuthenticator.init(string, n, string3, string4);
        String[] stringArray = proxyAuthenticator.getLoginAndPassword();
        if (stringArray == null || stringArray.length != 2) {
            throw new HttpUnauthorizedException("Proxy authentication failed");
        }
        String string6 = stringArray[0] + ':' + stringArray[1];
        byte[] byArray = string6.getBytes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string7 = "Basic " + bASE64Encoder.encodeBuffer(byArray);
        if (debug) {
            HttpURLConnection.p("getAuthString() returning '" + string7 + "'");
        }
        return string7;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.responseCode >= 400 && this.rememberedException != null) {
            throw this.rememberedException;
        }
        if (this.inputStream != null) {
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        }
        if (this.streamedPostOS != null) {
            try {
                this.streamedPostOS.close();
            }
            catch (IOException iOException) {
                this.disconnect();
                throw iOException;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 3;
        do {
            Object object;
            try {
                if (debug) {
                    HttpURLConnection.p("########### connecting try " + n2 + " of " + n3);
                }
                this.connect();
                this.writeRequests();
                this.http.parseHTTP(this.responses);
            }
            catch (HttpUnauthorizedException httpUnauthorizedException) {
                if (debug) {
                    HttpURLConnection.p("Authentication required for this request");
                }
                this.disconnect();
                this.wroteRequests = false;
                this.setRequests = false;
                this.requests = new MessageHeader();
                object = new String("-Authenticate: Basic Realm=WebLogic Realm");
                proxyAuthString = HttpURLConnection.getAuthInfo(this.getURL().getHost(), this.getURL().getPort(), httpUnauthorizedException.getMessage() + (String)object);
                continue;
            }
            catch (ConnectException connectException) {
                if (debug) {
                    HttpURLConnection.p("ConnectException " + connectException.getMessage());
                }
                throw connectException;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (debug) {
                    HttpURLConnection.p("InterruptedIOException " + interruptedIOException.getMessage());
                }
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                if (debug) {
                    HttpURLConnection.p("IOException " + iOException.getMessage());
                }
                if (this.rememberedException != null && this.rememberedException instanceof SocketTimeoutException) {
                    throw iOException;
                }
                if (++n2 >= n3) {
                    throw iOException;
                }
                this.wroteRequests = false;
                if (this.http != null) {
                    this.http.closeServer();
                }
                try {
                    Thread.sleep(n2 * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connected = false;
                this.http = this.getHttpClient();
                continue;
            }
            this.inputStream = this.http.getInputStream();
            int n4 = this.getResponseCode();
            if (debug) {
                HttpURLConnection.p("response - " + this.responses);
            }
            if (n4 == 100) {
                this.handleContinueResponse();
            }
            if (this.followRedirect()) {
                this.wroteRequests = false;
                ++n;
                continue;
            }
            if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                this.disconnect();
                if (this.http != null) {
                    this.http.setLastUsed(System.currentTimeMillis());
                }
                this.inputStream = new NullInputStream();
                return this.inputStream;
            }
            if (n4 == 407) {
                if (debug) {
                    HttpURLConnection.p("Proxy Authentication required");
                }
                this.disconnect();
                this.wroteRequests = false;
                if (this.instProxy != Proxy.NO_PROXY) {
                    object = (InetSocketAddress)this.instProxy.address();
                    proxyAuthString = HttpURLConnection.getAuthInfo(((InetSocketAddress)object).getHostName(), ((InetSocketAddress)object).getPort(), this.responses.findValue("Proxy-Authenticate"));
                } else {
                    proxyAuthString = HttpURLConnection.getAuthInfo(HttpClient.proxyHost, HttpClient.proxyPort, this.responses.findValue("Proxy-Authenticate"));
                }
                if (proxyAuthString == null) continue;
                this.requests.set("Proxy-Authorization", proxyAuthString);
                continue;
            }
            if (n4 >= 400) {
                object = HttpReasonPhraseCoder.getReasonPhrase((int)n4);
                throw new FileNotFoundException("Response: '" + n4 + ": " + (String)object + "' for url: '" + this.toStringWithoutUserinfo(this.url) + "'");
            }
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        } while (n < 5);
        throw new ProtocolException("Server redirected too many times (" + n + ")");
    }

    void writeRequestForAsyncResponse() throws IOException {
        int n = 0;
        while (true) {
            try {
                this.connect();
                this.writeRequests();
                return;
            }
            catch (IOException iOException) {
                if (++n >= 3) {
                    throw iOException;
                }
                this.wroteRequests = false;
                if (this.http != null) {
                    this.http.closeServer();
                }
                try {
                    Thread.sleep(n * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connected = false;
                this.http = this.getHttpClient();
                continue;
            }
            break;
        }
    }

    private void handleContinueResponse() throws IOException {
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.http.parseHTTP(this.responses);
        this.inputStream = this.http.getInputStream();
        this.http.setLastUsed(System.currentTimeMillis());
        if (debug) {
            HttpURLConnection.p("handled 100 Continue. status=" + this.getResponseCode());
        }
    }

    public InputStream getErrorStream() {
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.connected && this.responseCode >= 400) {
            return this.inputStream;
        }
        return null;
    }

    protected boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 307 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        URL uRL = new URL(this.getURL(), string);
        if (!uRL.getProtocol().equals(uRL.getProtocol())) {
            return false;
        }
        if (debug) {
            HttpURLConnection.p("followRedirect Location=" + string);
        }
        this.disconnect();
        MessageHeader messageHeader = this.responses;
        this.responses = new MessageHeader();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (true) {
            String string2 = messageHeader.getKey(n2);
            String string3 = messageHeader.getValue(n2);
            if (string2 == null && string3 == null) break;
            if (string2 != null && string3 != null && string2.equalsIgnoreCase("Set-Cookie")) {
                if (sendCookiesRedirect) {
                    stringBuffer.append(string3.split(COOKIE_SEPARATOR, 2)[0]);
                    stringBuffer.append(COOKIE_SEPARATOR);
                } else {
                    this.responses.add(string2, string3);
                }
            }
            ++n2;
        }
        if (sendCookiesRedirect && stringBuffer.length() != 0) {
            this.redirectCookieStr = stringBuffer.substring(0, stringBuffer.length() - COOKIE_SEPARATOR.length());
            this.requests.add("Cookie", this.redirectCookieStr);
        }
        if (n == 305) {
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (this.method.equals("POST") && !strictPostRedirect) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.bufferedPostOS = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.http != null) {
            if (debug) {
                HttpURLConnection.p("disconnect called on " + this.http);
            }
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    boolean isConnected() {
        return this.connected;
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String string) {
        block2: {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                if (!(iOException instanceof SocketTimeoutException)) break block2;
                this.rememberedException = iOException;
            }
        }
        return this.responses.findValue(string);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getHeaders();
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (string.length() > 0) {
            this.requests.add(string, string2);
        }
    }

    public Map getRequestProperties() {
        return this.requests.getHeaders();
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (string.length() > 0) {
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                this.requests.add(string, string2);
            } else {
                this.requests.set(string, string2);
            }
        }
    }

    public void setEmptyRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string.length() > 0) {
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                this.requests.add(string, "");
            } else {
                this.requests.set(string, "");
            }
        }
    }

    public String getRequestProperty(String string) {
        return this.requests.findValue(string);
    }

    String getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetRequests() {
        this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        int n = this.url.getPort();
        String string = this.url.getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        this.requests.setIfNotSet("Host", string);
        this.requests.setIfNotSet("Accept", acceptString);
        if (proxyAuthString != null) {
            this.requests.set("Proxy-Authorization", proxyAuthString);
        }
        if (sendCookiesRedirect && this.redirectCookieStr != null) {
            this.requests.setIfNotSet("Cookie", this.redirectCookieStr);
        }
        if (this.http.getHttpKeepAliveSet()) {
            if (this.http.usingProxy) {
                this.requests.setIfNotSet("Proxy-Connection", "Keep-Alive");
            } else {
                this.requests.setIfNotSet("Connection", "Keep-Alive");
            }
        }
        if (this.bufferedPostOS != null) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this.bufferedPostOS;
            synchronized (unsyncByteArrayOutputStream) {
                this.requests.setIfNotSet("Content-Type", "application/x-www-form-urlencoded");
                this.requests.set("Content-Length", String.valueOf(this.bufferedPostOS.size()));
            }
        }
        this.setRequests = true;
    }

    public void setTimeout(int n) {
        this.setReadTimeout(n);
    }

    public int getTimeout() {
        return this.getReadTimeout();
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
        if (this.http != null) {
            this.http.setReadTimeout(n);
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setFixedLengthStreamingMode(int n) {
        this.fixedContentLength = n;
    }

    public void setChunkedStreamingMode(int n) {
        this.chunkLength = n;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.rememberedException != null && this.rememberedException instanceof SocketTimeoutException) {
            throw this.rememberedException;
        }
        IOException iOException = null;
        try {
            this.getInputStream();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.rememberedException = socketTimeoutException;
            throw socketTimeoutException;
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        String string = this.getHeaderField(0);
        if (string == null && iOException != null) {
            throw iOException;
        }
        this.rememberedException = iOException;
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            this.responseCode = Integer.parseInt(string.substring(n, n + 3));
            this.responseMessage = string.substring(n + 4).trim();
            return this.responseCode;
        }
        catch (Exception exception) {
            return this.responseCode;
        }
    }

    String getHttpVersion() {
        if (this.useHttp11) {
            return "HTTP/1.1";
        }
        return "HTTP/1.0";
    }

    private String toStringWithoutUserinfo(URL uRL) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRL.getProtocol());
        stringBuilder.append(":");
        String string2 = string = uRL.getPort() == -1 ? uRL.getHost() : uRL.getHost() + ":" + uRL.getPort();
        if (string != null && string.length() > 0) {
            stringBuilder.append("//");
            stringBuilder.append(string);
        }
        if (uRL.getPath() != null) {
            stringBuilder.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuilder.append('?');
            stringBuilder.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuilder.append("#");
            stringBuilder.append(uRL.getRef());
        }
        return stringBuilder.toString();
    }

    public void u11() {
        if (!this.connected) {
            this.useHttp11 = true;
            if (debug) {
                HttpURLConnection.p("will use HTTP/1.1");
            }
        }
    }

    void finish() {
        this.http = null;
    }

    static final void p(String string) {
        System.out.println("[" + new Date() + "] [" + Thread.currentThread().getName() + "] " + string);
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    Socket getSocket() {
        return this.http.getSocket();
    }

    void setInputStream(InputStream inputStream) {
        this.http.setInputStream(inputStream);
    }

    public void setMuxableSocket(Object object) {
        this.http.setMuxableSocket(object);
    }

    Object getMuxableSocket() {
        return this.http.getMuxableSocket();
    }

    void setScavenger(Runnable runnable) {
        this.http.setScavenger(runnable);
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        if (string == null) {
            throw new ProtocolException("Invalid HTTP method: " + string);
        }
        if (string.length() > 32) {
            throw new ProtocolException("Invalid HTTP method: " + string + ", maximum length allowed is " + 32);
        }
        if (!HttpParsing.isTokenClean((String)string)) {
            throw new ProtocolException("Invalid HTTP method: " + string + ", invalid character(s) was found");
        }
        this.method = string;
    }

    static {
        strictPostRedirect = false;
        proxyAuthString = null;
        http11 = true;
        bufferPostForRetry = false;
        sendCookiesRedirect = false;
        boolean bl = false;
        userAgent = "Java" + System.getProperty("java.version");
        try {
            userAgent = System.getProperty("http.agent", userAgent);
            defaultReadTimeout = Integer.getInteger("weblogic.http.client.defaultReadTimeout", -1);
            defaultConnectTimeout = Integer.getInteger("weblogic.http.client.defaultConnectTimeout", -1);
            strictPostRedirect = HttpURLConnection.getBoolean("http.strictPostRedirect", strictPostRedirect);
            sendCookiesRedirect = HttpURLConnection.getBoolean("weblogic.http.sendCookiesRedirect", sendCookiesRedirect);
            bl = HttpURLConnection.getBoolean("http.debug", bl);
            http11 = HttpURLConnection.getBoolean("http.11", http11);
            bufferPostForRetry = HttpURLConnection.getBoolean("http.bufferPostForRetry", bufferPostForRetry);
            proxyAuthClassName = System.getProperty("weblogic.net.proxyAuthenticatorClassName");
        }
        catch (SecurityException securityException) {
            defaultReadTimeout = -1;
            defaultConnectTimeout = -1;
        }
        debug = bl;
    }
}

