/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import weblogic.net.NetLogger;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpOutputStream;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.HttpUnauthorizedException;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.acl.internal.Security;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.security.utils.SSLSetup;
import weblogic.socket.utils.RegexpPool;
import weblogic.utils.StringUtils;

final class HttpsClient
extends HttpClient {
    static final int MAX_TRIES = 3;
    static final int defaultHTTPSPort = 443;
    private static String SSLProxyHost = null;
    private static int SSLProxyPort = -1;
    private static String proxyAuthStr = null;
    private static Hashtable proxyAuthStrTable = new Hashtable();
    private String proxyAuthStrHeader = null;
    private SSLClientInfo sslInfo;
    private weblogic.security.SSL.SSLSocketFactory sslSocketFactory;

    public SSLClientInfo getSSLClientInfo() {
        return this.sslInfo;
    }

    public void setSSLClientInfo(SSLClientInfo sSLClientInfo) {
        this.sslInfo = sSLClientInfo;
    }

    Object getClientInfo() {
        return this.getSSLClientInfo();
    }

    public weblogic.security.SSL.SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(weblogic.security.SSL.SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    private void resetSSLProperties() {
        try {
            String string;
            try {
                string = System.getProperty("https.proxyPort");
                if (string == null) {
                    string = System.getProperty("ssl.proxyPort");
                }
                if (string == null) {
                    return;
                }
                SSLProxyPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            SSLProxyHost = System.getProperty("https.proxyHost");
            if (SSLProxyHost == null) {
                SSLProxyHost = System.getProperty("ssl.proxyHost");
            }
            if ((string = System.getProperty("https.nonProxyHosts")) != null) {
                dontProxy = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    if (dontProxy.add(stringTokenizer.nextToken().toLowerCase())) continue;
                    bl = true;
                }
                if (bl) {
                    NetLogger.logDuplicateExpression((String)"https", (String)string, null);
                }
            }
        }
        catch (SecurityException securityException) {
            SSLProxyPort = -1;
            SSLProxyHost = null;
        }
    }

    private static byte[] getConnectBytes(String string, int n, String string2) {
        String string3 = "CONNECT " + string + ':' + n + " HTTP/1.0";
        if (string2 != null) {
            string3 = string3 + "\r\n" + string2;
        }
        string3 = string3 + "\r\n\r\n";
        return string3.getBytes();
    }

    public static Socket getLayeredSocketUsingProxy(String string, int n) throws IOException {
        String string2;
        Socket socket;
        int n2 = 0;
        while (true) {
            String string3;
            socket = new Socket(SSLProxyHost, SSLProxyPort);
            socket.setTcpNoDelay(true);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(HttpsClient.getConnectBytes(string, n, proxyAuthStr));
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            string2 = dataInputStream.readLine();
            if (string2 == null || string2.length() == 0) {
                throw new ProtocolException("Empty response is detected from SSL proxy : '" + SSLProxyHost + ":" + SSLProxyPort + "'");
            }
            String[] stringArray = StringUtils.splitCompletely((String)string2);
            if (stringArray.length < 2 || !stringArray[0].equals("HTTP/1.0") && !stringArray[0].equals("HTTP/1.1")) {
                socket.close();
                throw new ProtocolException("unrecognized response from SSL proxy: '" + string2 + "'");
            }
            if (stringArray.length < 2 || !stringArray[0].equals("HTTP/1.0") && !stringArray[0].equals("HTTP/1.1")) continue;
            if (stringArray[1].equals("200")) {
                while ((string2 = dataInputStream.readLine()) != null && string2.length() > 0) {
                }
                return socket;
            }
            if (!stringArray[1].equals("407")) break;
            if (n2 > 3) {
                throw new ProtocolException("Server redirected too many times (" + n2 + ")");
            }
            while ((string3 = dataInputStream.readLine()) != null && string3.length() > 0) {
                String[] stringArray2 = StringUtils.split((String)string3, (char)':');
                if (!stringArray2[0].equalsIgnoreCase("Proxy-Authenticate")) continue;
                proxyAuthStr = HttpURLConnection.getAuthInfo(SSLProxyHost, SSLProxyPort, stringArray2[1]);
                if (proxyAuthStr == null) {
                    throw new HttpUnauthorizedException("Proxy Authentication required (407)");
                }
                proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
            }
            ++n2;
        }
        socket.close();
        throw new ProtocolException("unrecognized response from SSL proxy: '" + string2 + "'");
    }

    static String getProxyHost() {
        return SSLProxyHost;
    }

    static int getProxyPort() {
        return SSLProxyPort;
    }

    private HttpsClient(URL uRL, Proxy proxy, SocketFactory socketFactory, SSLClientInfo sSLClientInfo, weblogic.security.SSL.SSLSocketFactory sSLSocketFactory, boolean bl, int n, int n2, String string, boolean bl2) throws IOException {
        super(uRL, proxy, socketFactory, bl, n, n2, bl2);
        this.sslInfo = sSLClientInfo;
        this.sslSocketFactory = sSLSocketFactory;
        if (string != null) {
            this.proxyAuthStrHeader = "Proxy-Authorization: " + string;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.serverSocket != null && this.serverSocket instanceof SSLSocket) {
                SSLIOContextTable.removeContext((SSLSocket)this.serverSocket);
            }
            if (this.scavenger != null) {
                this.scavenger.run();
            }
            this.scavenger = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected int getDefaultPort() {
        return 443;
    }

    private SocketFactory getInternalSocketFactory() throws IOException {
        if (this.sslSocketFactory == null) {
            if (this.sslInfo == null) {
                this.sslInfo = Security.getThreadSSLClientInfo();
            }
            this.sslSocketFactory = weblogic.security.SSL.SSLSocketFactory.getInstance(this.sslInfo);
        }
        return this.sslSocketFactory;
    }

    protected void openServer(String string, int n) throws IOException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        SocketFactory socketFactory = this.getInternalSocketFactory();
        for (int i = 0; i < inetAddressArray.length; ++i) {
            try {
                if (this.connectTimeout > 0) {
                    this.serverSocket = this.openWrappedSSLSocket(inetAddressArray[i], n, this.connectTimeout);
                    break;
                }
                this.serverSocket = socketFactory.createSocket(inetAddressArray[i], n);
                break;
            }
            catch (ConnectException connectException) {
                continue;
            }
        }
        if (this.serverSocket == null) {
            throw new ConnectException("Tried all: " + inetAddressArray.length + " addresses, but could not connect" + " over HTTPS to server: " + string + " port: " + n);
        }
        this.serverSocket.setTcpNoDelay(true);
        if (this.readTimeout != -1) {
            this.serverSocket.setSoTimeout(this.readTimeout);
        }
        this.serverOutput = new HttpOutputStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected String getProtocol() {
        return "https";
    }

    protected synchronized void openServer() throws IOException {
        this.resetSSLProperties();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        if (!this.url.getProtocol().equals(this.getProtocol())) {
            throw new ProtocolException("unsupported protocol: " + this.url.getProtocol());
        }
        if (this.instProxy != Proxy.NO_PROXY && (this.ignoreSystemNonPorxyHosts || HttpsClient.isProxyAllowed(this.host))) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.instProxy.address();
            String string = inetSocketAddress.getHostName();
            int n = inetSocketAddress.getPort();
            try {
                this.makeConnectionUsingProxy(string, n, true);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (SSLProxyHost != null && HttpsClient.isProxyAllowed(this.host)) {
            try {
                this.makeConnectionUsingProxy(SSLProxyHost, SSLProxyPort, false);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.openServer(this.host, this.port);
    }

    private void makeConnectionUsingProxy(String string, int n, boolean bl) throws IOException {
        try {
            String string2;
            Socket socket;
            SSLContextWrapper sSLContextWrapper = SSLSetup.getSSLContext(this.sslInfo);
            sSLContextWrapper.getHostnameVerifier().setProxyMapping(string, this.host);
            sSLContextWrapper.getTrustManager().setProxyMapping(string, this.host);
            SSLSocketFactory sSLSocketFactory = sSLContextWrapper.getSSLSocketFactory();
            if (bl) {
                proxyAuthStr = (String)proxyAuthStrTable.get(this.instProxy);
            }
            if (proxyAuthStr == null) {
                try {
                    proxyAuthStr = HttpURLConnection.getAuthInfo(string, n, "Basic");
                    proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
                    if (bl) {
                        proxyAuthStrTable.put(this.instProxy, proxyAuthStr);
                    }
                }
                catch (HttpUnauthorizedException httpUnauthorizedException) {
                    // empty catch block
                }
            }
            int n2 = 0;
            while (true) {
                socket = this.getSocketFactory().createSocket(string, n);
                socket.setTcpNoDelay(true);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(HttpsClient.getConnectBytes(this.host, this.port, this.proxyAuthStrHeader != null ? this.proxyAuthStrHeader : proxyAuthStr));
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                string2 = dataInputStream.readLine();
                if (string2 == null || string2.length() == 0) {
                    socket.close();
                    throw new ProtocolException("Empty response is detected from SSL proxy : '" + string + ":" + n + "'");
                }
                String[] stringArray = StringUtils.splitCompletely((String)string2);
                if (stringArray.length < 2 || !stringArray[0].equals("HTTP/1.0") && !stringArray[0].equals("HTTP/1.1")) {
                    socket.close();
                    throw new ProtocolException("unrecognized response from SSL proxy: '" + string2 + "'");
                }
                if (stringArray[1].equals("200")) {
                    while ((string2 = dataInputStream.readLine()) != null && string2.length() > 0) {
                    }
                    this.serverSocket = sSLSocketFactory.createSocket(socket, this.host, this.port, true);
                    this.serverOutput = new HttpOutputStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
                    this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
                    this.usingProxy = true;
                    return;
                }
                if (!stringArray[1].equals("407")) break;
                if (n2 > 3) {
                    throw new ProtocolException("Server redirected too many times (" + n2 + ")");
                }
                while ((string2 = dataInputStream.readLine()) != null && string2.length() > 0) {
                    String[] stringArray2 = StringUtils.split((String)string2, (char)':');
                    if (!stringArray2[0].equalsIgnoreCase("Proxy-Authenticate")) continue;
                    proxyAuthStr = HttpURLConnection.getAuthInfo(string, n, stringArray2[1]);
                    if (proxyAuthStr == null) {
                        throw new HttpUnauthorizedException("Proxy Authentication required (407)");
                    }
                    proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
                    if (!bl) continue;
                    proxyAuthStrTable.put(this.instProxy, proxyAuthStr);
                }
                socket.close();
                ++n2;
            }
            socket.close();
            throw new ProtocolException("Unrecognized response from SSL proxy: '" + string2 + "'");
        }
        catch (IOException iOException) {
            NetLogger.logIOException((String)string, (String)("" + n), (String)this.host, (String)("" + this.port), (Throwable)iOException);
            throw iOException;
        }
    }

    public String getURLFile() {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        return string;
    }

    public SSLSession getSSLSession() {
        if (this.serverSocket != null && this.serverSocket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)this.serverSocket;
            return sSLSocket.getSession();
        }
        return null;
    }

    static HttpsClient New(URL uRL, Proxy proxy, SocketFactory socketFactory, SSLClientInfo sSLClientInfo, weblogic.security.SSL.SSLSocketFactory sSLSocketFactory, boolean bl, int n, int n2, boolean bl2, String string, boolean bl3) throws IOException {
        HttpsClient httpsClient = null;
        if (bl2) {
            httpsClient = (HttpsClient)HttpsClient.findInCache(uRL, sSLClientInfo, proxy);
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(uRL, proxy, socketFactory, sSLClientInfo, sSLSocketFactory, bl, n, n2, string, bl3);
            httpsClient.openServer();
        } else {
            httpsClient.url = uRL;
            httpsClient.setReadTimeout(n2 < 0 ? 0 : n2);
            httpsClient.setHttp11(bl);
        }
        return httpsClient;
    }

    private Socket openWrappedSSLSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(inetAddress, n), n2);
        Socket socket2 = this.sslSocketFactory.createSocket(socket, inetAddress.getHostAddress(), n, true);
        return socket2;
    }
}

