/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.HttpsClient;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.UnknownProtocolException;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.HostnameVerifierJSSE;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.Security;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLContextManager;

public class HttpsURLConnection
extends HttpURLConnection {
    private SSLSocketFactory sslSocketFactory;
    private SSLClientInfo sslinfo;
    private SSLSession sslSession = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public HttpsURLConnection(URL uRL, SSLClientInfo sSLClientInfo) {
        super(uRL);
        this.sslinfo = sSLClientInfo != null ? sSLClientInfo : Security.getThreadSSLClientInfo();
    }

    public HttpsURLConnection(URL uRL) {
        this(uRL, (Proxy)null);
    }

    public HttpsURLConnection(URL uRL, Proxy proxy) {
        this(uRL, (SSLClientInfo)null);
        this.instProxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    public void loadLocalIdentity(InputStream[] inputStreamArray) {
        this.setSSLClientCertificate(inputStreamArray);
    }

    private SSLClientInfo getSSLInfo() {
        if (this.sslinfo == null) {
            this.sslinfo = new SSLClientInfo();
        }
        return this.sslinfo;
    }

    public void loadLocalIdentity(InputStream inputStream, InputStream inputStream2, char[] cArray) {
        this.getSSLInfo().loadLocalIdentity(inputStream, inputStream2, cArray);
    }

    public void loadLocalIdentity(Certificate[] certificateArray, PrivateKey privateKey) {
        this.getSSLInfo().loadLocalIdentity(certificateArray, privateKey);
    }

    public void setSSLClientCertificate(InputStream[] inputStreamArray) {
        if (inputStreamArray != null) {
            this.getSSLInfo().setSSLClientCertificate(inputStreamArray);
            this.updateFactoryClientInfo();
        }
    }

    public void setTrustManager(TrustManager trustManager) {
        this.getSSLInfo().setTrustManager(trustManager);
        this.updateFactoryClientInfo();
    }

    public TrustManager getTrustManager() {
        if (this.sslinfo != null) {
            return this.sslinfo.getTrustManager();
        }
        return Security.getThreadSSLClientInfo().getTrustManager();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.getSSLInfo().setHostnameVerifier(hostnameVerifier);
        this.updateFactoryClientInfo();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.sslinfo != null) {
            return this.sslinfo.getHostnameVerifier();
        }
        return Security.getThreadSSLClientInfo().getHostnameVerifier();
    }

    public void setHostnameVerifierJSSE(HostnameVerifierJSSE hostnameVerifierJSSE) {
        if (hostnameVerifierJSSE != null) {
            this.getSSLInfo().setHostnameVerifierJSSE(hostnameVerifierJSSE);
            this.updateFactoryClientInfo();
        }
    }

    public HostnameVerifierJSSE getHostnameVerifierJSSE() {
        if (this.sslinfo != null) {
            return this.sslinfo.getHostnameVerifierJSSE();
        }
        return HttpsURLConnection.getDefaultHostnameVerifierJSSE();
    }

    public static HostnameVerifierJSSE getDefaultHostnameVerifierJSSE() {
        return Security.getThreadSSLClientInfo().getHostnameVerifierJSSE();
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        return HttpsURLConnection.getDefaultSSLSocketFactory();
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public String getCipherSuite() {
        if (this.sslSession != null) {
            return this.sslSession.getCipherSuite();
        }
        return null;
    }

    public X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.sslSession != null) {
            return this.sslSession.getPeerCertificateChain();
        }
        return null;
    }

    public SSLSession getSSLSession() {
        return this.sslSession;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.checkClientSSLInfo();
        try {
            this.http = HttpsClient.New(this.url, this.instProxy, this.getSocketFactory(), this.sslinfo, this.sslSocketFactory, this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), true, this.getRequestProperty("Proxy-Authorization"), this.ignoreSystemNonPorxyHosts);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.rememberedException = socketTimeoutException;
            throw socketTimeoutException;
        }
        this.http.setConnection(this);
        this.connected = true;
        HttpsClient httpsClient = (HttpsClient)this.http;
        if (this.sslSocketFactory == null) {
            this.setSSLSocketFactory(httpsClient.getSSLSocketFactory());
        }
        this.sslSession = httpsClient.getSSLSession();
    }

    private void checkClientSSLInfo() {
        java.security.cert.X509Certificate[] x509CertificateArray;
        if (!KernelStatus.isServer()) {
            return;
        }
        if (this.sslinfo != null && (x509CertificateArray = this.sslinfo.getClientLocalIdentityCert()) != null && x509CertificateArray.length > 0) {
            return;
        }
        x509CertificateArray = ManagementService.getRuntimeAccess(kernelId);
        if (x509CertificateArray == null) {
            return;
        }
        SSLMBean sSLMBean = x509CertificateArray.getServer().getSSL();
        if (sSLMBean == null) {
            return;
        }
        if (!sSLMBean.isUseServerCerts()) {
            return;
        }
        if (debug) {
            SecurityLogger.logUsingServerCerts();
        }
        try {
            SSLClientInfo sSLClientInfo;
            sSLMBean = ProtocolManager.findProtocol((String)this.getProtocol()).getHandler().getDefaultServerChannel();
            this.sslinfo = sSLClientInfo = SSLContextManager.getChannelSSLClientInfo((ServerChannel)sSLMBean, kernelId);
        }
        catch (ConfigurationException configurationException) {
            SecurityLogger.logCantUseServerCerts();
        }
        catch (CertificateException certificateException) {
            SecurityLogger.logCantUseServerCerts();
        }
        catch (UnknownProtocolException unknownProtocolException) {
            SecurityLogger.logCantUseServerCerts();
        }
        catch (Exception exception) {
            SecurityLogger.logCantUseServerCerts();
        }
    }

    public void disconnect() {
        this.sslSession = null;
        super.disconnect();
    }

    protected String getProtocol() {
        return "https";
    }

    protected HttpClient getHttpClient() throws IOException {
        HttpsClient httpsClient = HttpsClient.New(this.url, this.instProxy, this.getSocketFactory(), this.sslinfo, this.sslSocketFactory, this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), false, this.getRequestProperty("Proxy-Authorization"), this.ignoreSystemNonPorxyHosts);
        httpsClient.setConnection(this);
        this.connected = true;
        return httpsClient;
    }

    public SSLClientInfo getSSLClientInfo() {
        return this.sslinfo;
    }

    private void updateFactoryClientInfo() {
        if (this.sslSocketFactory != null) {
            this.sslSocketFactory.setSSLClientInfo(this.sslinfo);
        }
    }
}

