/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.KeepAliveKey;
import weblogic.utils.AssertionError;

public final class KeepAliveCache {
    private static int LIFETIME = 15000;
    private static int PROXY_LIFETIME = 20000;
    private static int INTERVAL_RATE = 2;
    private static int HEALTH_CHECK_TIMOUT = 0;
    private Timer timer;
    private final ConcurrentMap<KeepAliveKey, List<HttpClient>> cache;
    private Random random = new Random();

    public KeepAliveCache() {
        this.cache = new ConcurrentHashMap<KeepAliveKey, List<HttpClient>>();
        this.timer = new Timer(true);
    }

    public void put(HttpClient httpClient) {
        if (this.isClientTimeout(httpClient)) {
            httpClient.closeServer();
            return;
        }
        final KeepAliveKey keepAliveKey = new KeepAliveKey(httpClient.getURL(), httpClient.getClientInfo(), httpClient.instProxy);
        Vector<HttpClient> vector = (Vector<HttpClient>)this.cache.get(keepAliveKey);
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("cache connection: " + httpClient);
        }
        if (vector == null) {
            vector = new Vector<HttpClient>();
            List list = this.cache.putIfAbsent(keepAliveKey, vector);
            if (list != null) {
                list.add(httpClient);
                return;
            }
            vector.add(httpClient);
            int n = httpClient.usingProxy ? PROXY_LIFETIME : LIFETIME;
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List list = (List)KeepAliveCache.this.cache.get(keepAliveKey);
                    if (list == null) {
                        this.cancel();
                        return;
                    }
                    List list2 = list;
                    synchronized (list2) {
                        HttpClient httpClient;
                        int n;
                        if (list.isEmpty()) {
                            if (HttpURLConnection.debug) {
                                HttpURLConnection.p("cancel cleanup timer task: " + this);
                            }
                            KeepAliveCache.this.cache.remove(keepAliveKey);
                            this.cancel();
                            return;
                        }
                        for (n = 0; n < list.size() && KeepAliveCache.this.isClientTimeout(httpClient = (HttpClient)list.get(n)); ++n) {
                            if (HttpURLConnection.debug) {
                                HttpURLConnection.p("cleanup invalid client: " + httpClient);
                            }
                            httpClient.closeServer();
                        }
                        list.subList(0, n).clear();
                    }
                }
            };
            try {
                if (HttpURLConnection.debug) {
                    HttpURLConnection.p("init timer task: " + timerTask);
                }
                this.timer.schedule(timerTask, n, (long)(n / INTERVAL_RATE));
            }
            catch (IllegalStateException illegalStateException) {
                throw new AssertionError("Keep-Alive timer task cancelled: " + timerTask);
            }
        } else {
            vector.add(httpClient);
        }
    }

    public HttpClient get(URL uRL, Object object) {
        return this.get(uRL, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient get(URL uRL, Object object, Proxy proxy) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL, object, proxy);
        List list = (List)this.cache.get(keepAliveKey);
        if (list == null || list.isEmpty()) {
            if (HttpURLConnection.debug) {
                HttpURLConnection.p("doesn't hit for: " + keepAliveKey);
            }
            return null;
        }
        HttpClient httpClient = null;
        List list2 = list;
        synchronized (list2) {
            if (list.size() == 0) {
                return null;
            }
            httpClient = (HttpClient)list.remove(this.random.nextInt(list.size()));
        }
        if (httpClient != null && !this.isClientTimeout(httpClient)) {
            if (HEALTH_CHECK_TIMOUT > 0 && !this.isSocketHealthy(httpClient)) {
                httpClient.closeServer();
                return null;
            }
            if (HttpURLConnection.debug) {
                HttpURLConnection.p("reuse connection from cache: " + httpClient);
            }
            return httpClient;
        }
        if (httpClient != null) {
            httpClient.closeServer();
        }
        return null;
    }

    private boolean isClientTimeout(HttpClient httpClient) {
        long l = System.currentTimeMillis() - httpClient.lastUsed;
        return httpClient.usingProxy ? l > (long)PROXY_LIFETIME : l > (long)LIFETIME;
    }

    private boolean isSocketHealthy(HttpClient httpClient) {
        try {
            httpClient.serverSocket.setSoTimeout(HEALTH_CHECK_TIMOUT);
            httpClient.serverSocket.getInputStream().read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        try {
            LIFETIME = Integer.getInteger("http.keepAliveCache.lifeTime", LIFETIME);
            PROXY_LIFETIME = Integer.getInteger("http.keepAliveCache.proxyLifeTime", PROXY_LIFETIME);
            HEALTH_CHECK_TIMOUT = Integer.getInteger("http.keepAliveCache.socketHealthCheckTimeout", HEALTH_CHECK_TIMOUT);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

