/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.net.Proxy;
import java.net.URL;

class KeepAliveKey {
    private String protocol = null;
    private String host = null;
    private int port = 0;
    private Object clientInfo = null;
    private Proxy proxy = null;

    public KeepAliveKey(URL uRL, Object object) {
        this(uRL, object, null);
    }

    public KeepAliveKey(URL uRL, Object object, Proxy proxy) {
        this.protocol = uRL.getProtocol();
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        this.clientInfo = object;
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeepAliveKey)) {
            return false;
        }
        KeepAliveKey keepAliveKey = (KeepAliveKey)object;
        return this.host.equals(keepAliveKey.host) && this.port == keepAliveKey.port && this.protocol.equals(keepAliveKey.protocol) && (this.clientInfo == keepAliveKey.clientInfo || this.clientInfo != null && this.clientInfo.equals(keepAliveKey.clientInfo)) && this.proxy.equals(keepAliveKey.proxy);
    }

    public int hashCode() {
        int n = (this.protocol.hashCode() * 31 + this.host.hashCode()) * 31 + this.port;
        n *= 31;
        if (this.clientInfo != null) {
            n += this.clientInfo.hashCode();
            n *= 31;
        }
        return n += this.proxy.hashCode();
    }

    public String toString() {
        return "protocol: " + this.protocol + ", host: " + this.host + ", port: " + this.port + ", clientInfo: " + this.clientInfo + ", proxy: " + this.proxy;
    }
}

