/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.net.http.HttpClient;
import weblogic.utils.io.NullInputStream;

public final class KeepAliveStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected int markedCount = 0;
    protected int markLimit = -1;
    protected HttpClient client;

    public KeepAliveStream(HttpClient httpClient, InputStream inputStream, int n) {
        super((InputStream)(n == 0 ? NullInputStream.getInstance() : inputStream));
        this.expected = n;
        this.client = httpClient;
    }

    private final void justRead(int n) throws IOException {
        if (n == -1) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count > this.markLimit) {
            this.markLimit = -1;
        }
        if (this.isMarked()) {
            return;
        }
        if (this.expected != -1 && this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count <= this.markLimit;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            this.justRead(1);
        } else {
            this.justRead(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        this.justRead(n3);
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int n = (int)l;
        if (this.expected != -1 && l > (long)(this.expected - this.count)) {
            n = this.expected - this.count;
        }
        l = this.in.skip(n);
        this.justRead((int)l);
        return l;
    }

    public int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        boolean bl = false;
        try {
            if (this.expected == -1) {
                boolean bl2 = bl = this.in.read() != -1;
            }
            if (bl || this.expected > this.count) {
                this.client.setKeepingAlive(false);
                this.in.close();
            }
            Object var3_2 = null;
            this.closed = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closed = true;
            HttpClient.finished(this.client);
            throw throwable;
        }
        HttpClient.finished(this.client);
    }

    public void mark(int n) {
        if (this.closed || this.client.isKeepingAlive()) {
            return;
        }
        super.mark(n);
        this.markedCount = this.count;
        this.markLimit = n;
    }

    public void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.client.isKeepingAlive()) {
            throw new IOException("mark/reset not supported");
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    public boolean markSupported() {
        if (this.closed || this.client.isKeepingAlive()) {
            return false;
        }
        return super.markSupported();
    }
}

