/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.net.http.HttpOutputStream;

final class MessageHeader {
    private static final byte[] HTTP_PROTOCOL_BYTES = new byte[]{72, 84, 84, 80, 47, 49, 46};
    private static final int HTTP_PROTOCOL_LEN = 7;
    private String[] keys;
    private String[] vals;
    private int nkeys;
    private byte[] byteBuffer = new byte[7];

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(InputStream inputStream) throws IOException {
        this.parseHeader(inputStream);
    }

    public String findValue(String string) {
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                return this.vals[n];
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                return this.vals[n];
            }
        }
        return null;
    }

    public String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.vals[n];
    }

    public void print(HttpOutputStream httpOutputStream) throws IOException {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            httpOutputStream.print(this.keys[i]);
            if (this.vals[i] != null) {
                httpOutputStream.print(": ");
                httpOutputStream.print(this.vals[i]);
            }
            httpOutputStream.print("\r\n");
        }
        httpOutputStream.print("\r\n");
    }

    public void print(PrintStream printStream) {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            printStream.print(this.keys[i] + (this.vals[i] != null ? ": " + this.vals[i] : "") + "\r\n");
        }
        printStream.print("\r\n");
        printStream.flush();
    }

    public void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.vals[this.nkeys] = string2;
        ++this.nkeys;
    }

    public void prepend(String string, String string2) {
        this.grow();
        for (int i = this.nkeys; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.vals[i] = this.vals[i - 1];
        }
        this.keys[0] = string;
        this.vals[0] = string2;
        ++this.nkeys;
    }

    public void set(int n, String string, String string2) {
        this.grow();
        if (n < 0) {
            return;
        }
        if (n > this.nkeys) {
            this.add(string, string2);
        } else {
            this.keys[n] = string;
            this.vals[n] = string2;
        }
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, stringArray, 0, this.nkeys);
            }
            if (this.vals != null) {
                System.arraycopy(this.vals, 0, stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.vals = stringArray2;
        }
    }

    public void set(String string, String string2) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.keys[n])) continue;
            this.vals[n] = string2;
            return;
        }
        this.add(string, string2);
    }

    public void setIfNotSet(String string, String string2) {
        if (this.findValue(string) == null) {
            this.add(string, string2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void parseHeader(InputStream inputStream) throws IOException {
        this.nkeys = 0;
        if (inputStream == null || !this.isHTTP(inputStream)) {
            return;
        }
        char[] cArray = new char[10];
        int n = inputStream.read();
        if (n < 0) {
            throw new IOException("Response contained no data");
        }
        while (true) {
            Object object;
            void var2_3;
            int n2;
            int n3;
            block21: {
                int n4;
                boolean bl;
                if (n != 10 && n != 13 && n >= 0) {
                    n3 = 0;
                    n2 = -1;
                    bl = n > 32;
                    var2_3[n3++] = (char)n;
                } else {
                    return;
                }
                while ((n4 = inputStream.read()) >= 0) {
                    switch (n4) {
                        case 58: {
                            if (bl && n3 > 0) {
                                n2 = n3;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n4 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n = inputStream.read();
                            if (n4 == 13 && n == 10 && (n = inputStream.read()) == 13) {
                                n = inputStream.read();
                            }
                            if (n == 10 || n == 13 || n > 32) break block21;
                            n4 = 32;
                        }
                    }
                    if (n3 >= ((void)var2_3).length) {
                        object = new char[((void)var2_3).length * 2];
                        System.arraycopy(var2_3, 0, object, 0, n3);
                        Object object2 = object;
                    }
                    var2_3[n3++] = (char)n4;
                }
                n = -1;
            }
            while (n3 > 0 && var2_3[n3 - 1] <= 32) {
                --n3;
            }
            if (n2 <= 0) {
                object = null;
                n2 = 0;
            } else {
                object = String.copyValueOf((char[])var2_3, 0, n2);
                if (n2 < n3 && var2_3[n2] == 58) {
                    ++n2;
                }
                while (n2 < n3 && var2_3[n2] <= 32) {
                    ++n2;
                }
            }
            String string = n2 >= n3 ? new String() : String.copyValueOf((char[])var2_3, n2, n3 - n2);
            this.add((String)object, string);
        }
    }

    private boolean isHTTP(InputStream inputStream) throws IOException {
        block4: {
            boolean bl;
            if (!inputStream.markSupported()) {
                return true;
            }
            inputStream.mark(7);
            try {
                if (7 != inputStream.read(this.byteBuffer, 0, 7)) break block4;
                bl = Arrays.equals(HTTP_PROTOCOL_BYTES, this.byteBuffer);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                inputStream.reset();
                throw throwable;
            }
            inputStream.reset();
            return bl;
        }
        throw new EOFException("Response contained no data");
    }

    public String toString() {
        String string = super.toString();
        for (int i = 0; i < this.keys.length; ++i) {
            string = string + "{" + this.keys[i] + ": " + this.vals[i] + "}";
        }
        return string;
    }

    public synchronized Map getHeaders() {
        HashMap hashMap = new HashMap();
        int n = this.nkeys;
        while (--n >= 0) {
            Object object = hashMap.get(this.keys[n]);
            if (object == null) {
                object = new ArrayList();
                hashMap.put(this.keys[n], object);
            }
            ((List)object).add(this.vals[n]);
        }
        Set set = hashMap.keySet();
        for (Object object : set) {
            List list = (List)hashMap.get(object);
            hashMap.put((String)object, Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

