/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.nodemanager.NodeManagerLogger;
import weblogic.nodemanager.common.StateInfo;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.nodemanager.server.DomainDir;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.util.ConcurrentFile;
import weblogic.nodemanager.util.ProcessControl;
import weblogic.nodemanager.util.ProcessControlFactory;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.Debug;

public class NMService
extends AbstractServerService
implements PropertyChangeListener {
    private boolean started;
    private String startupMode;
    private String srvrURL;
    private StateInfo stateInfo;
    private ConcurrentFile stateFile;
    private ConcurrentFile pidFile;
    private ConcurrentFile urlFile;
    public static final String SERVICE_ENABLED_PROP = "weblogic.nodemanager.ServiceEnabled";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static NMService instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMService() {
        Class<NMService> clazz = NMService.class;
        synchronized (NMService.class) {
            Debug.assertion((instance == null ? 1 : 0) != 0);
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static NMService getInstance() {
        return instance;
    }

    public synchronized void start() throws ServiceFailureException {
        if (this.started) {
            return;
        }
        if (!Boolean.getBoolean(SERVICE_ENABLED_PROP)) {
            return;
        }
        this.stateInfo = new StateInfo();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.startupMode = serverMBean.getStartupMode();
        ServerDir serverDir = this.getServerDir();
        this.pidFile = serverDir.getPidFile();
        this.urlFile = serverDir.getURLFile();
        this.stateFile = serverDir.getStateFile();
        this.writeProcessId();
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        serverRuntimeMBean.addPropertyChangeListener(this);
        serverMBean.getServerStart().addPropertyChangeListener(this);
        if (serverMBean.getAutoKillIfFailed()) {
            OverloadProtectionMBean overloadProtectionMBean = serverMBean.getOverloadProtection();
            overloadProtectionMBean.setFailureAction("force-shutdown");
            overloadProtectionMBean.setPanicAction("system-exit");
        }
        this.started = true;
    }

    private boolean writeProcessId() {
        ProcessControl processControl = null;
        try {
            processControl = ProcessControlFactory.getProcessControl();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (processControl == null) {
            NodeManagerLogger.logNativePidSupportUnavailable();
            return false;
        }
        try {
            this.pidFile.writeLine(processControl.getProcessId());
        }
        catch (IOException iOException) {
            NodeManagerLogger.logErrorWritingPidFile((String)this.pidFile.getPath(), (Throwable)iOException);
            return false;
        }
        return true;
    }

    private boolean writeServerURL() {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        this.srvrURL = serverRuntimeMBean.getURL("http");
        if (this.srvrURL == null) {
            this.srvrURL = serverRuntimeMBean.getURL("https");
        }
        try {
            this.urlFile.writeLine(this.srvrURL);
        }
        catch (IOException iOException) {
            NodeManagerLogger.logErrorWritingURLFile((String)this.urlFile.getPath(), (Throwable)iOException);
            return false;
        }
        return true;
    }

    private ServerDir getServerDir() {
        DomainDir domainDir = new DomainDir(BootStrap.getRootDirectory());
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        return domainDir.getServerDir(string);
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public synchronized void halt() throws ServiceFailureException {
        if (!this.started) {
            return;
        }
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        T3Srvr t3Srvr = T3Srvr.getT3Srvr();
        String string = t3Srvr.getState();
        assert (string.equals("SHUTTING_DOWN"));
        assert (string.equals("FORCE_SHUTTING_DOWN"));
        this.stateInfo.setState(string);
        this.stateInfo.setStarted(t3Srvr.isStarted());
        this.stateInfo.setFailed(serverRuntimeMBean.isShuttingDownDueToFailure());
        this.finishHalting();
    }

    private synchronized void finishHalting() throws ServiceFailureException {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        serverRuntimeMBean.removePropertyChangeListener(this);
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        serverMBean.getServerStart().removePropertyChangeListener(this);
        this.writeStateInfo();
        this.pidFile.delete();
        this.started = false;
    }

    public void hardShutdown() throws ServiceFailureException {
        if (!this.started) {
            return;
        }
        this.stateInfo.setState("FORCE_SHUTTING_DOWN");
        this.stateInfo.setStarted(true);
        this.stateInfo.setFailed(false);
        this.finishHalting();
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.started) {
            return;
        }
        if ("State".equals(propertyChangeEvent.getPropertyName())) {
            String string = (String)propertyChangeEvent.getNewValue();
            ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
            this.stateInfo.setState(string);
            if (serverRuntimeMBean.isStartupAbortedInAdminState()) {
                this.stateInfo.setStarted(true);
                this.writeServerURL();
                string = string + "_ON_ABORTED_STARTUP";
                this.stateInfo.setState(string);
            } else if (string.equals(this.startupMode)) {
                this.stateInfo.setStarted(true);
                this.writeServerURL();
            } else if ("FORCE_SHUTTING_DOWN".equals(string) && serverRuntimeMBean.isShuttingDownDueToFailure()) {
                this.stateInfo.setFailed(true);
            }
            this.writeStateInfo();
        } else {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(serverMBean);
            try {
                nodeManagerRuntime.updateServerProps(serverMBean);
            }
            catch (IOException iOException) {
                NodeManagerLogger.logErrorUpdatingServerProps((String)serverMBean.getName(), (Throwable)iOException);
            }
        }
    }

    private void writeStateInfo() {
        try {
            this.stateInfo.save(this.stateFile);
        }
        catch (IOException iOException) {
            NodeManagerLogger.logStateChangeNotificationFailureMsg((Throwable)iOException);
            Runtime.getRuntime().halt(1);
        }
    }
}

