/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.client;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Properties;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.ScriptExecutionFailureException;
import weblogic.nodemanager.client.PlainClient;
import weblogic.nodemanager.client.RSHClient;
import weblogic.nodemanager.client.SSHClient;
import weblogic.nodemanager.client.SSLClient;
import weblogic.nodemanager.client.ShellClient;
import weblogic.nodemanager.client.VMMClient;
import weblogic.nodemanager.common.ServerType;

public abstract class NMClient {
    protected String host;
    protected int port;
    protected String nmDir;
    protected String domainName;
    protected String domainDir;
    protected String serverName;
    protected ServerType serverType;
    protected static final String ENCODING = "UTF-8";
    protected byte[] nmUser;
    protected byte[] nmPass;
    protected boolean verbose;
    protected PrintStream stdout = System.out;
    public static final String PLAIN = "plain";
    public static final String SSL = "ssl";
    public static final String SSH = "ssh";
    public static final String RSH = "rsh";
    public static final String SHELL = "shell";
    public static final String VMM = "vmm-";
    public static final String VMM_SECURE = "vmms-";
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    NMClient() {
        this.serverType = ServerType.WebLogic;
    }

    public static NMClient getInstance(String string) {
        if (PLAIN.equalsIgnoreCase(string)) {
            return new PlainClient();
        }
        if (SSL.equalsIgnoreCase(string)) {
            return new SSLClient();
        }
        if (SHELL.equalsIgnoreCase(string)) {
            return new ShellClient();
        }
        if (SSH.equalsIgnoreCase(string)) {
            return new SSHClient();
        }
        if (RSH.equalsIgnoreCase(string)) {
            return new RSHClient();
        }
        if ((string + "-").toLowerCase().startsWith(VMM.toLowerCase()) || (string + "-").toLowerCase().startsWith(VMM_SECURE.toLowerCase())) {
            return new VMMClient(string);
        }
        throw new IllegalArgumentException(nmText.getUnknownClient(string));
    }

    protected void checkNullOrEmpty(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(nmText.getNullOrEmpty(string2));
        }
    }

    public synchronized void setHost(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidHostName());
        this.checkNotConnected();
        this.host = string;
    }

    public synchronized void setPort(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(nmText.getInvalidPort(Integer.toString(n)));
        }
        this.checkNotConnected();
        this.port = n;
    }

    public synchronized void setDomainName(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidDomain());
        this.checkNotConnected();
        this.domainName = string;
    }

    public synchronized void setDomainDir(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidDomainDir());
        this.checkNotConnected();
        this.domainDir = string;
    }

    public synchronized void setServerName(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidServerName());
        this.serverName = string;
    }

    public synchronized void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public synchronized void setNMDir(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidNMHome());
        this.checkNotConnected();
        this.nmDir = string;
    }

    public synchronized void setNMUser(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidUser());
        this.checkNotConnected();
        try {
            this.nmUser = string.getBytes(ENCODING);
        }
        catch (IOException iOException) {
            this.nmUser = null;
        }
    }

    public synchronized void setNMPass(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidPwd());
        this.checkNotConnected();
        try {
            this.nmPass = string.getBytes(ENCODING);
        }
        catch (IOException iOException) {
            this.nmPass = null;
        }
    }

    public void execScript(String string, long l) throws IOException, ScriptExecutionFailureException {
        this.checkNullOrEmpty(string, nmText.getInvalidScriptPath());
        this.executeScript(string, l);
    }

    public synchronized void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public abstract String getStates(int var1) throws IOException;

    public abstract String getState(int var1) throws IOException;

    public abstract String getVersion() throws IOException;

    public abstract void getNMLog(Writer var1) throws IOException;

    public abstract void getLog(Writer var1) throws IOException;

    public abstract void start() throws IOException;

    public abstract void start(Properties var1) throws IOException;

    public abstract void kill() throws IOException;

    public abstract void done() throws IOException;

    public abstract void quit() throws IOException;

    protected abstract void checkNotConnected() throws IllegalStateException;

    public abstract void executeScript(String var1, long var2) throws IOException, ScriptExecutionFailureException;

    public abstract void updateServerProps(Properties var1) throws IOException;

    public void setOutputStream(PrintStream printStream) {
        this.stdout = printStream;
    }
}

