/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.common.Command;
import weblogic.nodemanager.common.DataFormat;
import weblogic.nodemanager.common.ServerType;

public class NMClientTool {
    private String host;
    private int port = -1;
    private String domainName = "mydomain";
    private String domainDir;
    private String serverName = "myserver";
    private ServerType serverType = SERVER_TYPE;
    private String nmUser;
    private String nmPass;
    private String nmDir;
    private String clientType = "ssl";
    private String scriptPath;
    private String timeout;
    private Command cmd;
    private boolean verbose;
    private static final String SERVER_NAME = "myserver";
    private static final String DOMAIN_NAME = "mydomain";
    private static final String CLIENT_TYPE = "ssl";
    private static final ServerType SERVER_TYPE = ServerType.WebLogic;
    private static final String[] USAGE = new String[]{"Usage: java weblogic.nodemanager.client.NMClientTool [OPTIONS] CMD", "", "Where OPTIONS include:", "  -type <type>      Node manager client type (ssl, plain, rsh, ssh, or vmm[s][-adapter_type][_adapter_version])", "                    (default is 'ssl')", "  -host <host>      Node manager host name (default is 'localhost')", "  -port <port>      Node manager port (default based on client type)", "  -nmdir <nmdir>    Node manager home directory", "  -server <server>  Server name (default is 'myserver')", "  -domain <domain>  Domain name (default is 'mydomain')", "  -serverType <st>  Server type (default is '" + SERVER_TYPE + "') - one of " + NMClientTool.getServerTypeAsString(), "  -root <dir>       Domain root directory", "  -user <username>  Node manager username", "  -pass <password>  Node manager password", "  -verbose          Enable verbose output", "  -help             Print this help message", "", "And CMD is one of the following:", "  START       Start server", "  KILL        Kill server", "  STAT        Get server status", "  GETLOG      Retrieve WLS server log", "  GETNMLOG    Retrieve node manager server log", "  VERSION     Return node manager server version", "  QUIT        Asks the nodemanager to quit", ""};

    NMClientTool(String[] stringArray) {
        int n = this.parseOptions(stringArray);
        if (n >= stringArray.length) {
            this.printUsage();
            System.exit(1);
        }
        try {
            this.cmd = Command.parse(stringArray[n]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Unrecognized command: " + stringArray[n]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws Throwable {
        Object object;
        if ((this.clientType.equalsIgnoreCase(CLIENT_TYPE) || this.clientType.equalsIgnoreCase("vmms-")) && ((Properties)(object = System.getProperties())).getProperty("weblogic.security.TrustKeyStore") == null) {
            ((Properties)object).setProperty("weblogic.security.TrustKeyStore", "DemoTrust");
        }
        object = NMClient.getInstance(this.clientType);
        try {
            int n = this.doCommand((NMClient)object);
            return n;
        }
        finally {
            ((NMClient)object).done();
        }
    }

    private int doCommand(NMClient nMClient) throws IOException {
        if (this.host != null) {
            nMClient.setHost(this.host);
        }
        if (this.port > 0) {
            nMClient.setPort(this.port);
        }
        if (this.nmDir != null) {
            nMClient.setNMDir(this.nmDir);
        }
        if (this.domainName != null) {
            nMClient.setDomainName(this.domainName);
        }
        if (this.domainDir != null) {
            nMClient.setDomainDir(this.domainDir);
        }
        if (this.serverName != null) {
            nMClient.setServerName(this.serverName);
        }
        if (this.serverType != null) {
            nMClient.setServerType(this.serverType);
        }
        if (this.nmUser != null) {
            nMClient.setNMUser(this.nmUser);
        }
        if (this.nmPass != null) {
            nMClient.setNMPass(this.nmPass);
        }
        if (this.verbose) {
            nMClient.setVerbose(true);
        }
        if (this.cmd == Command.STAT) {
            System.out.println(nMClient.getState(0));
        } else if (this.cmd == Command.VERSION) {
            System.out.println(nMClient.getVersion());
        } else if (this.cmd == Command.START) {
            nMClient.start();
        } else if (this.cmd == Command.STARTP) {
            Properties properties = new Properties();
            DataFormat.readProperties(new BufferedReader(new InputStreamReader(System.in)), properties);
            nMClient.start(properties);
        } else if (this.cmd == Command.KILL) {
            nMClient.kill();
        } else if (this.cmd == Command.GETSTATES) {
            System.out.println(nMClient.getStates(0));
        } else if (this.cmd == Command.GETLOG) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            nMClient.getLog(outputStreamWriter);
            ((Writer)outputStreamWriter).flush();
        } else if (this.cmd == Command.GETNMLOG) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            nMClient.getNMLog(outputStreamWriter);
            ((Writer)outputStreamWriter).flush();
        } else if (this.cmd == Command.EXECSCRIPT) {
            nMClient.execScript(this.scriptPath, Long.valueOf(this.timeout));
        } else if (this.cmd == Command.QUIT) {
            nMClient.quit();
        } else {
            System.err.println("Unrecognized command: " + this.cmd);
            return 1;
        }
        return 0;
    }

    private static String getServerTypeAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ServerType serverType : ServerType.values()) {
            stringBuilder.append(serverType.toString()).append(" ");
        }
        return stringBuilder.toString();
    }

    private void printUsage() {
        for (String string : USAGE) {
            System.out.println(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseOptions(String[] stringArray) {
        int n = 0;
        try {
            while (n < stringArray.length && stringArray[n].startsWith("-")) {
                String string;
                if ((string = stringArray[n++]).equals("-host")) {
                    this.host = stringArray[n++];
                    continue;
                }
                if (string.equals("-port")) {
                    String string2 = stringArray[n++];
                    try {
                        this.port = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Invalid port number: " + string2);
                        System.exit(1);
                        continue;
                    }
                }
                if (string.equals("-nmdir") || string.equals("-n")) {
                    this.nmDir = stringArray[n++];
                    continue;
                }
                if (string.equals("-server") || string.equals("-s")) {
                    this.serverName = stringArray[n++];
                    continue;
                }
                if (string.equals("-serverType")) {
                    this.serverType = ServerType.valueOf((String)stringArray[n++]);
                    continue;
                }
                if (string.equals("-domain") || string.equals("-d")) {
                    this.domainName = stringArray[n++];
                    continue;
                }
                if (string.equals("-root") || string.equals("-r")) {
                    this.domainDir = stringArray[n++];
                    continue;
                }
                if (string.equals("-user")) {
                    this.nmUser = stringArray[n++];
                    continue;
                }
                if (string.equals("-pass")) {
                    this.nmPass = stringArray[n++];
                    continue;
                }
                if (string.equals("-type") || string.equals("-t")) {
                    this.clientType = stringArray[n++];
                    continue;
                }
                if (string.equals("-verbose") || string.equals("-v")) {
                    this.verbose = true;
                    continue;
                }
                if (string.equals("-script_path") || string.equals("-sp")) {
                    this.scriptPath = stringArray[n++];
                    continue;
                }
                if (string.equals("-script_timeout") || string.equals("-st")) {
                    this.timeout = stringArray[n++];
                    continue;
                }
                if (string.equals("-help") || string.equals("-?")) {
                    this.printUsage();
                    System.exit(0);
                    continue;
                }
                System.err.println("Invalid option: " + string);
                System.exit(1);
            }
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("Invalid argument syntax");
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) throws Throwable {
        NMClientTool nMClientTool = new NMClientTool(stringArray);
        System.exit(nMClientTool.run());
    }
}

