/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Properties;
import weblogic.nodemanager.NMConnectException;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.ScriptExecutionFailureException;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.common.Command;
import weblogic.nodemanager.common.DataFormat;
import weblogic.nodemanager.common.ServerType;

abstract class NMServerClient
extends NMClient {
    private Socket sock;
    private BufferedReader in;
    private BufferedWriter out;
    private boolean connected;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    NMServerClient() {
    }

    public synchronized String getState(int n) throws IOException {
        this.checkConnected(n);
        this.sendServer();
        this.sendCmd(Command.STAT);
        return this.checkResponse();
    }

    public synchronized String getStates(int n) throws IOException {
        this.checkConnected(n);
        this.sendCmd(Command.GETSTATES);
        return this.checkResponse();
    }

    public synchronized String getVersion() throws IOException {
        this.checkConnected();
        this.sendCmd(Command.VERSION);
        return this.checkResponse();
    }

    public synchronized void getNMLog(Writer writer) throws IOException {
        this.checkConnected();
        this.sendCmd(Command.GETNMLOG);
        DataFormat.copy(this.in, writer);
        this.checkResponse();
    }

    public synchronized void getLog(Writer writer) throws IOException {
        this.checkConnected();
        this.sendServer();
        this.sendCmd(Command.GETLOG);
        DataFormat.copy(this.in, writer);
        this.checkResponse();
    }

    public synchronized void start() throws IOException {
        this.start(null);
    }

    public synchronized void start(Properties properties) throws IOException {
        this.checkConnected();
        this.sendServer();
        if (properties != null) {
            this.sendCmd(Command.STARTP);
            DataFormat.writeProperties(this.out, properties);
        } else {
            this.sendCmd(Command.START);
        }
        this.checkResponse();
    }

    public synchronized void kill() throws IOException {
        this.checkConnected();
        this.sendServer();
        this.sendCmd(Command.KILL);
        this.checkResponse();
    }

    public synchronized void chgCred(String string, String string2, String string3, String string4) throws IOException {
        this.setNMUser(string);
        this.setNMPass(string2);
        this.checkConnected();
        this.sendCmd(Command.CHGCRED, new String[]{string3, string4});
        this.checkResponse();
    }

    private void sendHello() throws IOException {
        this.sendCmd(Command.HELLO);
    }

    public synchronized void done() throws IOException {
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void quit() throws IOException {
        this.checkConnected();
        this.sendCmd(Command.QUIT);
        this.checkResponse();
    }

    protected abstract Socket createSocket(String var1, int var2, int var3) throws IOException;

    protected void checkNotConnected() throws IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException(nmText.getAlreadyConnected());
        }
    }

    public void executeScript(String string, long l) throws IOException, ScriptExecutionFailureException {
        if (string == null || string.equals("")) {
            throw new IOException(nmText.getInvalidPath(string));
        }
        this.checkConnected();
        this.sendCmd(Command.EXECSCRIPT, new String[]{string, String.valueOf(l)});
        this.checkResponse(string);
    }

    public void updateServerProps(Properties properties) throws IOException {
        this.checkConnected();
        this.sendServer();
        this.sendCmd(Command.UPDATEPROPS);
        DataFormat.writeProperties(this.out, properties);
        this.checkResponse();
    }

    private void checkConnected(int n) throws IOException {
        if (!this.connected) {
            this.connect(n);
            this.connected = true;
        }
    }

    private void checkConnected() throws IOException {
        this.checkConnected(0);
    }

    private void connect(int n) throws IOException {
        if (this.domainName == null) {
            throw new IllegalStateException(nmText.getDomainNotSet());
        }
        if (this.nmUser != null && this.nmPass == null) {
            throw new IllegalStateException(nmText.getNoPassword());
        }
        if (this.nmPass != null && this.nmUser == null) {
            throw new IllegalStateException(nmText.getNoUser());
        }
        try {
            this.sock = this.createSocket(this.host, this.port, n);
        }
        catch (IOException iOException) {
            NMConnectException nMConnectException = new NMConnectException(iOException.getMessage() + ". " + nmText.getNoConnect(this.host, Integer.toString(this.port)), this.host, this.port);
            nMConnectException.setStackTrace(iOException.getStackTrace());
            throw nMConnectException;
        }
        this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream()));
        this.sendHello();
        this.checkResponse();
        if (this.domainDir != null) {
            this.sendCmd(Command.DOMAIN, new String[]{this.domainName, this.domainDir});
        } else {
            this.sendCmd(Command.DOMAIN, new String[]{this.domainName});
        }
        this.checkResponse();
        if (this.nmUser != null && this.nmPass != null) {
            this.sendCmd(Command.USER, new String[]{new String(this.nmUser, "UTF-8")});
            this.checkResponse();
            this.sendCmd(Command.PASS, new String[]{new String(this.nmPass, "UTF-8")});
            this.checkResponse();
        }
    }

    private void sendServer() throws IOException {
        if (this.serverName == null) {
            throw new IllegalStateException(nmText.getServerNotSet());
        }
        Command command = this.serverType == ServerType.Coherence ? Command.COHERENCESERVER : Command.SERVER;
        this.sendCmd(command, new String[]{this.serverName});
        this.checkResponse();
    }

    private synchronized void disconnect() throws IOException {
        if (this.connected) {
            this.sock.close();
            this.connected = false;
        }
    }

    private String checkResponse(String string) throws IOException {
        String string2 = this.in.readLine();
        if (string2 == null) {
            throw new IOException(nmText.getEndOfStream());
        }
        String string3 = DataFormat.parseERR(string2);
        if (string3 != null) {
            if (string != null) {
                int n = 0;
                n = DataFormat.parseScriptERR(string2);
                if (n != 0) {
                    throw new ScriptExecutionFailureException(string, n);
                }
            }
            throw new NMException(string3);
        }
        string3 = DataFormat.parseOK(string2);
        if (string3 != null) {
            return string3;
        }
        throw new IOException(nmText.getUnexpectedResponse(string2));
    }

    private String checkResponse() throws IOException {
        return this.checkResponse(null);
    }

    private void sendCmd(Command command) throws IOException {
        DataFormat.writeCommand(this.out, command, null);
    }

    private void sendCmd(Command command, String[] stringArray) throws IOException {
        DataFormat.writeCommand(this.out, command, stringArray);
    }
}

