/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.ScriptExecutionFailureException;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.common.Command;
import weblogic.nodemanager.util.Platform;
import weblogic.utils.StringUtils;

public class ShellClient
extends NMClient {
    private Process proc;
    private BufferedWriter out;
    private BufferedReader in;
    private boolean connected;
    private String shellCommand;
    private String script;
    private ErrDrainer errDrainer;
    int connectTimeout;
    private static boolean debug = false;
    private static final String SCRIPT_SPECIFIER = "-e ";
    public static final String SHELL_COMMAND_PROP = "weblogic.nodemanager.ShellCommand";
    public static final String SHELL_COMMAND = "wlscontrol.sh -d %D -r %R -s %S %C";
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();
    private Vector removedOptions;

    public ShellClient() {
        this(System.getProperty(SHELL_COMMAND_PROP, SHELL_COMMAND));
    }

    public ShellClient(String string) {
        this.shellCommand = string;
    }

    public synchronized String getVersion() throws IOException {
        String string;
        this.checkConnected(false);
        this.execCmd(Command.VERSION);
        String string2 = null;
        while ((string = this.readLine()) != null) {
            string2 = string;
        }
        this.checkResponse();
        return string2;
    }

    public synchronized String getState(int n) throws IOException {
        this.checkConnected(true);
        String string = null;
        NMCommandRunner nMCommandRunner = new NMCommandRunner(Command.STAT);
        nMCommandRunner.start();
        try {
            nMCommandRunner.join(n);
            if (nMCommandRunner.isAlive()) {
                throw new IOException(nmText.getOperationTimedOut(Command.STAT.toString()));
            }
            IOException iOException = nMCommandRunner.getIOException();
            if (iOException != null) {
                throw iOException;
            }
            string = nMCommandRunner.getResult();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(nmText.getOperationInterrupted(Command.STAT.toString()));
        }
        return string;
    }

    public synchronized String getStates(int n) throws IOException {
        if (this.domainName == null) {
            throw new IllegalStateException(nmText.getDomainNotSet());
        }
        String string = null;
        NMCommandRunner nMCommandRunner = new NMCommandRunner(Command.GETSTATES);
        nMCommandRunner.start();
        try {
            nMCommandRunner.join(n);
            if (nMCommandRunner.isAlive()) {
                throw new IOException(nmText.getOperationTimedOut(Command.GETSTATES.toString()));
            }
            IOException iOException = nMCommandRunner.getIOException();
            if (iOException != null) {
                throw iOException;
            }
            string = nMCommandRunner.getResult();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(nmText.getOperationInterrupted(Command.GETSTATES.toString()));
        }
        return string;
    }

    public synchronized void getNMLog(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write(nmText.getCommandNotAvailable(Command.GETNMLOG.toString()));
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    public synchronized void getLog(Writer writer) throws IOException {
        this.checkConnected(true);
        this.execCmd(Command.GETLOG);
        this.copyTo(new BufferedWriter(writer), false);
        this.checkResponse();
    }

    public synchronized void start() throws IOException {
        this.checkConnected(true);
        this.execCmd(Command.START);
        this.checkResponse();
    }

    public synchronized void start(Properties properties) throws IOException {
        this.checkConnected(true);
        this.execCmd(Command.STARTP);
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            this.writeLine(string + "=" + string2);
        }
        this.endOutput();
        this.checkResponse();
    }

    public synchronized void kill() throws IOException {
        this.checkConnected(true);
        this.execCmd(Command.KILL);
        this.checkResponse();
    }

    public synchronized void quit() throws IOException {
        this.stdout.println(nmText.getCommandNotAvailable(Command.QUIT.toString()));
        this.stdout.flush();
    }

    protected void checkNotConnected() {
        assert (!this.connected);
    }

    public void executeScript(String string, long l) throws IOException, ScriptExecutionFailureException {
        if (string == null || string.equals("")) {
            throw new IOException(nmText.getInvalidPath(string));
        }
        this.script = string;
        this.execCmd(Command.EXECSCRIPT);
        this.checkResponse();
    }

    public void updateServerProps(Properties properties) throws IOException {
    }

    public void setShellCommand(String string) {
        this.shellCommand = string;
    }

    private void checkConnected(boolean bl) {
        if (!this.connected) {
            if (this.domainName == null) {
                throw new IllegalStateException(nmText.getDomainNotSet());
            }
            if (bl && this.serverName == null) {
                throw new IllegalStateException(nmText.getServerNotSet());
            }
            this.connected = true;
        }
    }

    private void execCmd(Command command) throws IOException {
        String[] stringArray = this.getCommandLine(command, this.shellCommand);
        if (this.verbose) {
            this.stdout.println("DEBUG: ShellClient: Executing shell command: " + StringUtils.join((String[])stringArray, (String)" "));
        }
        this.proc = Runtime.getRuntime().exec(stringArray);
        this.errDrainer = new ErrDrainer(this.proc.getErrorStream());
        this.errDrainer.start();
    }

    protected String[] getCommandLine(Command command, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.removedOptions = new Vector();
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.parse(command, stringArray[i]));
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        if (this.removedOptions.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-[");
            for (int i = 0; i < this.removedOptions.size(); ++i) {
                stringBuffer.append(this.removedOptions.get(i));
            }
            stringBuffer.append("]");
            String string2 = stringBuffer.toString();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].matches(string2)) continue;
                stringArray2[i] = "";
            }
        }
        return stringArray2;
    }

    private String parse(Command command, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        block9: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '%') {
                c = string.charAt(n++);
                switch (c) {
                    case 'H': 
                    case 'h': {
                        stringBuffer.append(this.host);
                        continue block9;
                    }
                    case 'P': 
                    case 'p': {
                        stringBuffer.append(Integer.toString(this.port));
                        continue block9;
                    }
                    case 'N': 
                    case 'n': {
                        stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                        stringBuffer.append(this.nmDir != null ? this.nmDir : System.getProperty("user.dir"));
                        stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                        continue block9;
                    }
                    case 'S': 
                    case 's': {
                        if (this.serverName != null) {
                            stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                            stringBuffer.append(this.serverName);
                            stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                            continue block9;
                        }
                        this.removedOptions.add(new String("Ss"));
                        continue block9;
                    }
                    case 'D': 
                    case 'd': {
                        stringBuffer.append(this.domainName);
                        continue block9;
                    }
                    case 'R': 
                    case 'r': {
                        if (this.domainDir != null) {
                            stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                            stringBuffer.append(this.domainDir != null ? this.domainDir : ".");
                            stringBuffer.append(Platform.isUnix() ? "\\'" : "\"");
                            continue block9;
                        }
                        this.removedOptions.add(new String("Rr"));
                        continue block9;
                    }
                    case 'C': 
                    case 'c': {
                        if (this.script != null) {
                            stringBuffer.append(SCRIPT_SPECIFIER);
                            stringBuffer.append(this.script + " ");
                        }
                        stringBuffer.append(command.getName());
                        continue block9;
                    }
                }
                stringBuffer.append('%');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public void done() {
    }

    private void checkResponse() throws IOException {
        int n;
        String string = null;
        this.endOutput();
        while (this.readLine() != null) {
        }
        try {
            n = this.proc.waitFor();
            this.errDrainer.join();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(nmText.getIOInterrupted());
        }
        if (n != 0 || (string = this.errDrainer.getLastLine()) != null) {
            if (n != 0) {
                string = this.errDrainer.getLastLine();
            }
            if (string == null) {
                string = "nmText.getUnknownSHError(rc)";
            }
        }
        this.proc.destroy();
        this.proc = null;
        this.out = null;
        this.in = null;
        this.connected = false;
        if (n == -100) {
            throw new AssertionError((Object)"Script is reporting a usage error: -100");
        }
        if (string != null) {
            throw new NMException(string);
        }
    }

    private void endOutput() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    private static void p(String string) {
        if (debug) {
            System.out.println("ShellClient => " + string);
        }
    }

    private BufferedReader getReader() {
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
        }
        return this.in;
    }

    private String readLine() throws IOException {
        String string = this.getReader().readLine();
        if (this.verbose && string != null) {
            this.stdout.println("DEBUG: ShellClient: STDOUT: " + string);
        }
        return string;
    }

    private void writeLine(String string) throws IOException {
        BufferedWriter bufferedWriter = this.getWriter();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        if (this.verbose) {
            this.stdout.println("DEBUG: ShellClient: STDIN: " + string);
        }
    }

    private BufferedWriter getWriter() {
        if (this.out == null) {
            this.out = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
        }
        return this.out;
    }

    private void copyTo(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        String string;
        while ((string = this.readLine()) != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            if (!bl) continue;
            bufferedWriter.flush();
        }
        bufferedWriter.flush();
    }

    private class NMCommandRunner
    extends Thread {
        private Command cmd;
        private String result;
        private IOException ioe;

        NMCommandRunner(Command command) {
            this.cmd = command;
        }

        public void run() {
            try {
                String string;
                ShellClient.this.execCmd(this.cmd);
                while ((string = ShellClient.this.readLine()) != null) {
                    this.result = string;
                }
                ShellClient.this.checkResponse();
            }
            catch (IOException iOException) {
                this.ioe = iOException;
            }
            catch (Throwable throwable) {
                this.ioe = (IOException)new IOException("Exception: " + throwable.getMessage()).initCause(throwable);
            }
        }

        String getResult() {
            return this.result;
        }

        IOException getIOException() {
            return this.ioe;
        }

        void killProcess() {
            ShellClient.this.proc.destroy();
        }

        boolean stillRunning() {
            try {
                int n = ShellClient.this.proc.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return true;
            }
        }
    }

    private class ErrDrainer
    extends Thread {
        private BufferedReader in;
        private String lastLine;

        ErrDrainer(InputStream inputStream) {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    if (ShellClient.this.verbose) {
                        ShellClient.this.stdout.println("DEBUG: ShellClient: STDERR: " + string);
                    }
                    this.lastLine = string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getLastLine() {
            return this.lastLine;
        }
    }
}

