/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.client;

import com.oracle.vmm.client.AdapterInfo;
import com.oracle.vmm.client.ConnectionSpec;
import com.oracle.vmm.client.ResourcePool;
import com.oracle.vmm.client.VMMConnector;
import com.oracle.vmm.client.VMState;
import com.oracle.vmm.client.VirtualMachine;
import com.oracle.vmm.client.VirtualMachineManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import weblogic.kernel.KernelStatus;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.client.NMClient;
import weblogic.security.utils.ClientKeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.MBeanKeyStoreConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMMClient
extends NMClient
implements CallbackHandler {
    private static String defaultBasePort = "8888";
    private static String defaultBaseSport = "4443";
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();
    private boolean connected = false;
    private ConnectionSpec connSpec;
    private static boolean debug = System.getProperty("DebugVMM", "false").equalsIgnoreCase("true");
    private boolean isSecure = false;
    private String virtualMachineName;
    private VirtualMachineManager vmm;
    private String vmmAPIVersion = System.getProperty("vmm.api.version", "2.2");
    private String vmmType = System.getProperty("vmm.type", "OracleVM");
    private SSLSocketFactory sslSocketFactory = null;

    public VMMClient(String string) {
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "_-", true);
        int n = stringTokenizer.countTokens();
        if (n >= 1 && (stringTokenizer.nextToken() + "-").equalsIgnoreCase("vmms-")) {
            this.isSecure = true;
        }
        if (n == 3) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("-")) {
                this.vmmType = stringTokenizer.nextToken();
            } else if (string2.equals("_")) {
                this.vmmAPIVersion = stringTokenizer.nextToken();
            }
        }
        if (n == 5) {
            string2 = stringTokenizer.nextToken();
            this.vmmType = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            this.vmmAPIVersion = stringTokenizer.nextToken();
        }
        if (this.isSecure) {
            this.setPort(new Integer(defaultBaseSport));
            try {
                this.sslSocketFactory = this.getSSLSocketFactory();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getLocalizedMessage());
            }
        } else {
            this.setPort(new Integer(defaultBasePort));
        }
    }

    private void checkConnected(boolean bl) throws IOException {
        if (!this.connected) {
            if (this.domainName == null) {
                throw new IllegalStateException(nmText.getDomainNotSet());
            }
            if (bl && this.serverName == null) {
                throw new IllegalStateException(nmText.getServerNotSet());
            }
            this.connect();
            this.connected = true;
        }
    }

    @Override
    protected void checkNotConnected() throws IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException(nmText.getAlreadyConnected());
        }
    }

    public void connect() throws IOException {
        this.connSpec = new ConnectionSpec();
        this.connSpec.setHost(this.host);
        this.connSpec.setPort(this.port);
        this.connSpec.setUseSecure(this.isSecure);
        if (this.isSecure) {
            this.connSpec.setSecurePort(this.port);
            this.connSpec.setSSLSocketFactory(this.sslSocketFactory);
        }
        this.connSpec.setCallbackHandler((CallbackHandler)this);
        try {
            if (this.host == null) {
                throw new IllegalStateException(nmText.getHostNotSet());
            }
            if (this.port <= 0) {
                throw new IllegalStateException(nmText.getInvalidPort(Integer.toString(this.port)));
            }
            if (!VMMConnector.hasAdapter((String)this.vmmType, (String)this.vmmAPIVersion, (ConnectionSpec)this.connSpec)) {
                throw new IllegalStateException(nmText.getInvalidVMMPlugin(this.vmmType, this.vmmAPIVersion));
            }
            this.vmm = VMMConnector.connect((String)this.vmmType, (String)this.vmmAPIVersion, (ConnectionSpec)this.connSpec);
            this.vmm.getAllPools();
            this.connected = true;
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("DEBUG: In VMMClient - exception during connect():");
                exception.printStackTrace();
            }
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    public static SSLSocketFactory getSSLSocketFactory(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray) {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException.getLocalizedMessage());
        }
    }

    private static TrustManager[] getTrustManagers(String string, char[] cArray, String string2, String string3, String string4) throws IOException {
        TrustManagerFactory trustManagerFactory = null;
        if (string == null) {
            return null;
        }
        if (debug) {
            System.out.println("DEBUG: trustKeystore=" + string);
        }
        if (string3 == null) {
            string3 = "SunX509";
        }
        if (string2 == null) {
            string2 = "JKS";
        }
        if (string4 == null) {
            string4 = "SunJSSE";
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(string3, string4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(nmText.msgErrorLoadKeyStoreNoSuchAlgorithmException(string, string3, (Exception)noSuchAlgorithmException));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug) {
                System.out.println("DEBUG: provider = " + string4);
                noSuchProviderException.printStackTrace();
            }
            throw new IllegalStateException(noSuchProviderException.getLocalizedMessage());
        }
        KeyStore keyStore = VMMClient.getKeystore(string, cArray, string2);
        try {
            trustManagerFactory.init(keyStore);
        }
        catch (KeyStoreException keyStoreException) {
            if (debug) {
                System.out.println("DEBUG: failed to init keystore");
                keyStoreException.printStackTrace();
            }
            throw new IllegalStateException(keyStoreException.getLocalizedMessage());
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (debug) {
            System.out.println("DEBUG: Loaded trust managers");
        }
        return trustManagerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeystore(String string, char[] cArray, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        if (string == null) {
            return null;
        }
        if (debug) {
            System.out.println("DEBUG: loading keystore from: " + string);
        }
        try {
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debug) {
                    System.out.println("DEBUG: can't find keystore: " + string);
                    fileNotFoundException.printStackTrace();
                }
                throw fileNotFoundException;
            }
            try {
                keyStore = KeyStore.getInstance(string2 == null ? "JKS" : string2);
            }
            catch (KeyStoreException keyStoreException) {
                if (debug) {
                    System.out.println("DEBUG: can't get keystore");
                    keyStoreException.printStackTrace();
                }
                throw new IOException(keyStoreException.getLocalizedMessage());
            }
            try {
                keyStore.load(fileInputStream, cArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug) {
                    System.out.println("DEBUG: bad algorithm");
                    noSuchAlgorithmException.printStackTrace();
                }
                throw new IllegalStateException(noSuchAlgorithmException.getLocalizedMessage());
            }
            catch (CertificateException certificateException) {
                if (debug) {
                    System.out.println("DEBUG: problem with certificate");
                    certificateException.printStackTrace();
                }
                throw new IllegalStateException(certificateException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                if (debug) {
                    System.out.println("DEBUG: I/O error loading keystore");
                    iOException.printStackTrace();
                }
                throw new IllegalStateException(iOException.getLocalizedMessage());
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustManager[] trustManagerArray = new TrustManager[1];
        keyStoreConfiguration = KernelStatus.isServer() ? MBeanKeyStoreConfiguration.getInstance() : ClientKeyStoreConfiguration.getInstance();
        KeyStoreInfo[] keyStoreInfoArray = new KeyStoreConfigurationHelper(keyStoreConfiguration).getTrustKeyStores();
        if (keyStoreInfoArray.length > 0) {
            Vector<TrustManager> vector = new Vector<TrustManager>();
            for (KeyStoreInfo keyStoreInfo : keyStoreInfoArray) {
                TrustManager[] trustManagerArray2 = VMMClient.getTrustManagers(keyStoreInfo.getFileName(), keyStoreInfo.getPassPhrase(), null, null, null);
                vector.addAll(Arrays.asList(trustManagerArray2));
            }
            trustManagerArray = vector.toArray(trustManagerArray);
        }
        return VMMClient.getSSLSocketFactory(null, trustManagerArray);
    }

    @Override
    public void done() throws IOException {
        this.quit();
    }

    @Override
    public void executeScript(String string, long l) {
        throw new IllegalStateException(nmText.msgErrorVmmNoScripting());
    }

    private VirtualMachine findVM(String string) throws IOException {
        String string2;
        if (debug) {
            System.out.println("DEBUG: VMMClient.findVM( " + string + " )");
        }
        VirtualMachine virtualMachine = null;
        List<String> list = this.getServerPools();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && (virtualMachine = this.getVM(string, string2 = iterator.next())) == null) {
        }
        return virtualMachine;
    }

    public List<VirtualMachine> getAllVMs(ResourcePool resourcePool) throws IOException {
        if (resourcePool == null) {
            return null;
        }
        String[] stringArray = null;
        ArrayList<VirtualMachine> arrayList = new ArrayList<VirtualMachine>();
        VirtualMachine virtualMachine = null;
        this.checkConnected(false);
        try {
            for (String string : stringArray = resourcePool.getAllVMNames()) {
                virtualMachine = resourcePool.lookupVM(string);
                if (virtualMachine == null) continue;
                arrayList.add(virtualMachine);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
        return arrayList;
    }

    @Override
    public void getLog(Writer writer) throws IOException {
        throw new NMException(nmText.msgErrorVmCommandNotSupported());
    }

    @Override
    public void getNMLog(Writer writer) throws IOException {
        throw new NMException(nmText.msgErrorVmCommandNotSupported());
    }

    private List<String> getServerPools() throws IOException {
        this.checkConnected(false);
        String[] stringArray = null;
        try {
            stringArray = this.vmm.getAllPools();
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
        return Arrays.asList(stringArray);
    }

    @Override
    public String getState(int n) throws IOException {
        this.checkConnected(true);
        try {
            return this.getStatus(this.getVmName()).toUpperCase();
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    @Override
    public String getStates(int n) throws NMException, IOException {
        this.checkConnected(true);
        throw new NMException(nmText.msgErrorVmCommandNotSupported());
    }

    private String getStatus(String string) throws IOException {
        VirtualMachine virtualMachine = this.findVM(string);
        if (virtualMachine != null) {
            return virtualMachine.getState().toString();
        }
        return VMState.Unknown.toString();
    }

    @Override
    public String getVersion() throws IOException {
        this.checkConnected(false);
        AdapterInfo adapterInfo = this.vmm.getAdapterInfo();
        return adapterInfo.getVmmType() + "_" + adapterInfo.getVmmApiVersion() + "_" + adapterInfo.getImplVersion();
    }

    public VirtualMachine getVM(String string, ResourcePool resourcePool) throws IOException {
        if (string != null && resourcePool != null) {
            return null;
        }
        this.checkConnected(false);
        try {
            return resourcePool.lookupVM(string);
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    public VirtualMachine getVM(String string, String string2) throws IOException {
        ResourcePool resourcePool = null;
        if (string == null || string2 == null) {
            return null;
        }
        this.checkConnected(false);
        try {
            resourcePool = this.vmm.lookupPool(string2);
            if (resourcePool != null) {
                return resourcePool.lookupVM(string);
            }
            return null;
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    private String getVmName() {
        if (this.virtualMachineName != null) {
            return this.virtualMachineName;
        }
        return this.serverName;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback;
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                if (this.nmUser == null) {
                    throw new IOException("user name is not specified.");
                }
                ((NameCallback)callback).setName(new String(this.nmUser, "UTF-8"));
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                if (this.nmPass == null) {
                    throw new IOException("password is not specified.");
                }
                callback = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)callback).setPassword(new String(this.nmPass, "UTF-8").toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
        }
    }

    public boolean isNmPassSet() {
        return this.nmPass != null;
    }

    public boolean isNmUserSet() {
        return this.nmUser != null;
    }

    @Override
    public void kill() throws IOException {
        this.checkConnected(true);
        try {
            this.stop(this.getVmName());
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    @Override
    public void quit() throws IOException {
        if (this.vmm != null) {
            this.vmm.disconnect();
        }
        this.connected = false;
        this.connSpec = null;
        this.host = null;
        this.nmUser = null;
        this.port = 0;
        this.nmPass = null;
        this.vmm = null;
    }

    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    @Override
    public void start() throws IOException {
        this.checkConnected(true);
        this.startWlsveVM(this.getVmName(), this.serverName);
    }

    @Override
    public void start(Properties properties) throws IOException {
        if (!KernelStatus.isServer()) {
            throw new NMException(nmText.msgErrorVmCommandNotSupported());
        }
        this.start();
    }

    private void startVM(VirtualMachine virtualMachine, String string) throws IOException {
        this.checkConnected(false);
        String string2 = virtualMachine.getName();
        if (virtualMachine.getState().equals((Object)VMState.Running)) {
            throw new NMException(nmText.getVmAlreadyRunning(string));
        }
        if (debug) {
            System.out.println("DEBUG: Powering on VM " + string2 + " for server " + string);
        }
        try {
            virtualMachine.start(0);
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("DEBUG: Exception while attempting to power on " + string2 + ":" + exception);
                exception.printStackTrace();
            }
            throw new NMException(exception.getLocalizedMessage());
        }
    }

    private void startWlsveVM(String string, String string2) throws IOException {
        VirtualMachine virtualMachine = this.findVM(string);
        if (virtualMachine == null) {
            throw new IOException(nmText.msgErrorVmForServerNotFound(string, string2));
        }
        this.startVM(virtualMachine, string2);
    }

    private void stop(String string) throws IOException {
        VirtualMachine virtualMachine = this.findVM(string);
        if (virtualMachine == null) {
            throw new NMException(nmText.msgErrorVmForServerNotFound(string, this.serverName));
        }
        this.stopVM(virtualMachine, this.serverName);
    }

    private void stopVM(VirtualMachine virtualMachine, String string) throws IOException {
        if (virtualMachine == null) {
            return;
        }
        this.checkConnected(false);
        String string2 = virtualMachine.getName();
        if (!virtualMachine.getState().equals((Object)VMState.Running)) {
            throw new NMException(nmText.getVmStopped(string));
        }
        if (debug) {
            System.out.println("DEBUG: Powering off " + string2);
        }
        try {
            virtualMachine.shutdown(0);
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("Couldn't shutdown VM: " + exception);
                exception.printStackTrace();
            }
            throw new NMException(exception.getLocalizedMessage());
        }
        if (debug) {
            System.out.println("DEBUG: " + VMState.PoweredOff);
        }
    }

    @Override
    public void updateServerProps(Properties properties) throws NMException {
        throw new NMException(nmText.msgErrorVmCommandNotSupported());
    }

    public synchronized void setVmmAdapterName(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidVmmAdapter());
        this.checkNotConnected();
        this.vmmType = string;
    }

    public synchronized void setVmmAdapterVersion(String string) {
        this.checkNullOrEmpty(string, nmText.getInvalidVmmAdapterVersion());
        this.checkNotConnected();
        this.vmmAPIVersion = string;
    }
}

