/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.common;

import java.util.ArrayList;
import java.util.Properties;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.StartupConfig;

public class CoherenceStartupConfig
extends StartupConfig {
    public static String UNICAST_PORT_PROP = "UnicastListenPort";
    public static String UNICAST_ADDR_PROP = "UnicastListenAddress";
    public static String UNICAST_PORT_AUTO_ADJUST_PROP = "UnicastPortAutoAdjust";
    public static String MULTICAST_PORT_PROP = "MulticastListenPort";
    public static String MULTICAST_ADDR_PROP = "MulticastListenAddress";
    public static String TTL_PROP = "TTL";
    public static String WKA_PROP = "WellKnownAddresses";
    public static String CLUSTER_CONFIG_FILE_PROP = "ClusterConfigurationFileName";
    public static String CLUSTER_NAME = "ClusterName";
    public static final int DEFAULT_TTL = 4;
    public static final boolean DEFAULT_UNICAST_PORT_AUTO_ADJUST = true;
    private String unicastListenAddress;
    private int unicastListenPort;
    private boolean unicastPortAutoAdjust = true;
    private String multicastListenAddress;
    private int multicastListenPort;
    private int timeToLive = 4;
    private final ArrayList<WellKnownAddress> wellKnownAddresses = new ArrayList();
    private String customClusterConfigurationFileName;
    private String clusterName;

    public CoherenceStartupConfig(Properties properties) throws ConfigException {
        super(properties);
        this.loadProperties();
    }

    public CoherenceStartupConfig() {
    }

    private void loadProperties() throws ConfigException {
        this.unicastListenAddress = this.getProperty(UNICAST_ADDR_PROP);
        this.unicastListenPort = this.getIntProperty(UNICAST_PORT_PROP, 0);
        this.unicastPortAutoAdjust = this.getBooleanProperty(UNICAST_PORT_AUTO_ADJUST_PROP, true);
        this.multicastListenAddress = this.getProperty(MULTICAST_ADDR_PROP);
        this.multicastListenPort = this.getIntProperty(MULTICAST_PORT_PROP, 0);
        this.timeToLive = this.getIntProperty(TTL_PROP, 4);
        this.customClusterConfigurationFileName = this.getProperty(CLUSTER_CONFIG_FILE_PROP);
        this.clusterName = this.getProperty(CLUSTER_NAME);
        this.loadWka(this.props);
    }

    public Properties getStartupProperties() {
        Properties properties = super.getStartupProperties();
        if (this.unicastListenAddress != null) {
            properties.setProperty(UNICAST_ADDR_PROP, this.unicastListenAddress);
        }
        if (this.unicastListenPort != 0) {
            properties.setProperty(UNICAST_PORT_PROP, "" + this.unicastListenPort);
        }
        if (!this.unicastPortAutoAdjust) {
            properties.setProperty(UNICAST_PORT_AUTO_ADJUST_PROP, Boolean.toString(this.unicastPortAutoAdjust));
        }
        if (this.multicastListenAddress != null) {
            properties.setProperty(MULTICAST_ADDR_PROP, this.multicastListenAddress);
        }
        if (this.multicastListenPort != 0) {
            properties.setProperty(MULTICAST_PORT_PROP, "" + this.multicastListenPort);
        }
        if (this.timeToLive != 4) {
            properties.setProperty(TTL_PROP, "" + this.timeToLive);
        }
        if (this.customClusterConfigurationFileName != null) {
            properties.setProperty(CLUSTER_CONFIG_FILE_PROP, this.customClusterConfigurationFileName);
        }
        if (this.clusterName != null) {
            properties.setProperty(CLUSTER_NAME, this.clusterName);
        }
        this.getStartupWka(properties);
        return properties;
    }

    public String getUnicastListenAddress() {
        return this.unicastListenAddress;
    }

    public void setUnicastListenAddress(String string) {
        this.unicastListenAddress = string;
    }

    public int getUnicastListenPort() {
        return this.unicastListenPort;
    }

    public void setUnicastListenPort(int n) {
        this.unicastListenPort = n;
    }

    public boolean isUnicastPortAutoAdjust() {
        return this.unicastPortAutoAdjust;
    }

    public void setUnicastPortAutoAdjust(boolean bl) {
        this.unicastPortAutoAdjust = bl;
    }

    public String getMulticastListenAddress() {
        return this.multicastListenAddress;
    }

    public void setMulticastListenAddress(String string) {
        this.multicastListenAddress = string;
    }

    public int getMulticastListenPort() {
        return this.multicastListenPort;
    }

    public void setMulticastListenPort(int n) {
        this.multicastListenPort = n;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    public void addWellKnownAddress(String string, String string2, int n) {
        this.wellKnownAddresses.add(new WellKnownAddress(string, string2, n));
    }

    public WellKnownAddress[] getWellKnownAddresses() {
        return this.wellKnownAddresses.toArray(new WellKnownAddress[this.wellKnownAddresses.size()]);
    }

    public String getCustomClusterConfigurationFileName() {
        return this.customClusterConfigurationFileName;
    }

    public void setCustomClusterConfigurationFileName(String string) {
        this.customClusterConfigurationFileName = string;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    private void getStartupWka(Properties properties) {
        if (this.wellKnownAddresses.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (WellKnownAddress wellKnownAddress : this.wellKnownAddresses) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(wellKnownAddress.getName()).append(",");
            stringBuilder.append(wellKnownAddress.getListenAddress()).append(",");
            stringBuilder.append(wellKnownAddress.getListenPort());
        }
        properties.setProperty(WKA_PROP, stringBuilder.toString());
    }

    private void loadWka(Properties properties) throws ConfigException {
        String string = this.trim(properties.getProperty(WKA_PROP));
        if (string == null) {
            return;
        }
        for (String string2 : string.split(";")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                throw new ConfigException(NodeManagerTextTextFormatter.getInstance().getInvalidPropValue(WKA_PROP, string));
            }
            try {
                this.addWellKnownAddress(this.trim(stringArray[0]), this.trim(stringArray[1]), Integer.parseInt(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigException(NodeManagerTextTextFormatter.getInstance().getInvalidPropValue(WKA_PROP, string));
            }
        }
    }

    private String trim(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static class WellKnownAddress {
        private final String name;
        private final String address;
        private final int port;

        private WellKnownAddress(String string, String string2, int n) {
            this.name = string;
            this.address = string2;
            this.port = n;
        }

        public String getName() {
            return this.name;
        }

        public String getListenAddress() {
            return this.address;
        }

        public int getListenPort() {
            return this.port;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName()).append(",");
            stringBuilder.append(this.getListenAddress()).append(",");
            stringBuilder.append(this.getListenPort());
            return stringBuilder.toString();
        }
    }
}

