/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.common;

import java.util.HashMap;
import java.util.Locale;
import weblogic.nodemanager.NodeManagerTextTextFormatter;

public class Command {
    private String name;
    private static final HashMap commands = new HashMap();
    public static final Command VERSION = Command.put("VERSION");
    public static final Command DOMAIN = Command.put("DOMAIN");
    public static final Command SERVER = Command.put("SERVER");
    public static final Command COHERENCESERVER = Command.put("COHERENCESERVER");
    public static final Command USER = Command.put("USER");
    public static final Command PASS = Command.put("PASS");
    public static final Command STAT = Command.put("STAT");
    public static final Command QUIT = Command.put("QUIT");
    public static final Command START = Command.put("START");
    public static final Command STARTP = Command.put("STARTP");
    public static final Command KILL = Command.put("KILL");
    public static final Command GETLOG = Command.put("GETLOG");
    public static final Command GETNMLOG = Command.put("GETNMLOG");
    public static final Command HELLO = Command.put("HELLO");
    public static final Command CHGCRED = Command.put("CHGCRED");
    public static final Command GETSTATES = Command.put("GETSTATES");
    public static final Command EXECSCRIPT = Command.put("EXECSCRIPT");
    public static final Command UPDATEPROPS = Command.put("UPDATEPROPS");

    private Command(String string) {
        this.name = string;
    }

    private static Command put(String string) {
        Command command = new Command(string);
        commands.put(string.toUpperCase(Locale.ENGLISH), command);
        return command;
    }

    public static Command parse(String string) {
        Command command = (Command)commands.get(string.toUpperCase(Locale.ENGLISH));
        if (command != null) {
            return command;
        }
        throw new IllegalArgumentException(NodeManagerTextTextFormatter.getInstance().getInvalidCommand(string));
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof Command) {
            return this.name.equals(((Command)object).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

