/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import weblogic.nodemanager.common.Command;
import weblogic.utils.StringUtils;

public class DataFormat {
    public static final char EOS_CHAR = '.';
    public static final String EOL = "\r\n";
    public static final String OK = "+OK ";
    public static final String ERR = "-ERR ";

    public static void readProperties(BufferedReader bufferedReader, Properties properties) throws IOException {
        String string;
        while ((string = DataFormat.readLine(bufferedReader)) != null) {
            int n = string.indexOf(61);
            if (n == -1) {
                throw new IOException("Bad properties data format");
            }
            properties.setProperty(string.substring(0, n), string.substring(n + 1));
        }
    }

    public static void writeProperties(Writer writer, Properties properties) throws IOException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getValue();
            if (string.indexOf("\n") > -1) {
                string = string.replace('\n', ' ');
            }
            DataFormat.writeLine(writer, (String)entry.getKey() + '=' + string);
        }
        DataFormat.writeEOS(writer);
        writer.flush();
    }

    public static void copy(BufferedReader bufferedReader, Writer writer, boolean bl) throws IOException {
        String string;
        while ((string = DataFormat.readLine(bufferedReader)) != null) {
            writer.write(string);
            writer.write(EOL);
            if (!bl) continue;
            writer.flush();
        }
    }

    public static void copy(BufferedReader bufferedReader, Writer writer) throws IOException {
        DataFormat.copy(bufferedReader, writer, false);
    }

    public static String readLine(BufferedReader bufferedReader) throws IOException {
        int n;
        String string = bufferedReader.readLine();
        if (string != null && (n = string.length()) > 0 && string.charAt(0) == '.') {
            string = n == 1 ? null : string.substring(1);
        }
        return string;
    }

    public static void writeLine(Writer writer, String string) throws IOException {
        if (string.length() > 0 && string.charAt(0) == '.') {
            string = '.' + string;
        }
        writer.write(string + EOL);
    }

    public static void writeEOS(Writer writer) throws IOException {
        writer.write(".\r\n");
    }

    public static void writeOK(Writer writer, String string) throws IOException {
        writer.write(OK + string + EOL);
        writer.flush();
    }

    public static void writeERR(Writer writer, String string) throws IOException {
        writer.write(ERR + string + EOL);
        writer.flush();
    }

    public static void writeScriptERR(Writer writer, int n) throws IOException {
        writer.write(ERR + n + EOL);
        writer.flush();
    }

    public static String parseOK(String string) {
        if (string.startsWith(OK)) {
            return string.substring(OK.length());
        }
        return null;
    }

    public static String parseERR(String string) {
        if (string.startsWith(ERR)) {
            return string.substring(ERR.length());
        }
        return null;
    }

    public static int parseScriptERR(String string) {
        if (string.startsWith(ERR)) {
            try {
                return Integer.parseInt(string.substring(ERR.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void writeCommand(Writer writer, Command command, String[] stringArray) throws IOException {
        String string = command.toString() + " ";
        if (stringArray != null) {
            string = string + StringUtils.join((String[])stringArray, (String)" ");
        }
        writer.write(string + EOL);
        writer.flush();
    }
}

