/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import weblogic.nodemanager.common.Config;
import weblogic.nodemanager.common.ConfigException;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupConfig
extends Config {
    private String javaVendor;
    private String javaHome;
    private String beaHome;
    private String classPath;
    private String securityPolicyFile;
    private String arguments;
    private String sslArguments;
    private String adminURL;
    private String username;
    private String password;
    private boolean autoRestart = true;
    private boolean autoKillIfFailed = false;
    private int restartMax = 2;
    private int restartDelaySeconds = 0;
    private int restartInterval = 0;
    private String serverIPs;
    private transient List<String> serverIPList;
    private String serverUid;
    private String serverGid;
    private String trustKeyStore;
    private String customTrustKeyStoreFileName;
    private String customTrustKeyStoreType;
    private String customTrustKeyStorePassPhrase;
    private String javaStandardTrustKeyStorePassPhrase;
    private String serverOutFile = null;
    private String serverErrFile = null;
    private String transientScriptEnv;
    private String nmHostName;
    public static final String JAVA_VENDOR_PROP = "JavaVendor";
    public static final String JAVA_HOME_PROP = "JavaHome";
    public static final String ARGUMENTS_PROP = "Arguments";
    public static final String SSL_ARGUMENTS_PROP = "SSLArguments";
    public static final String SECURITY_POLICY_FILE_PROP = "SecurityPolicyFile";
    public static final String CLASS_PATH_PROP = "ClassPath";
    public static final String BEA_HOME_PROP = "BeaHome";
    public static final String ADMIN_URL_PROP = "AdminURL";
    public static final String AUTO_RESTART_PROP = "AutoRestart";
    public static final String AUTO_KILL_IF_FAILED_PROP = "AutoKillIfFailed";
    public static final String RESTART_MAX_PROP = "RestartMax";
    public static final String RESTART_INTERVAL_PROP = "RestartInterval";
    public static final String RESTART_DELAY_SECONDS_PROP = "RestartDelaySeconds";
    public static final String USERNAME_PROP = "username";
    public static final String PASSWORD_PROP = "password";
    public static final String SERVER_IP_PROP = "ServerIP";
    public static final String SERVER_UID_PROP = "ServerUID";
    public static final String SERVER_GID_PROP = "ServerGID";
    public static final String TRANSIENT_SCRIPT_ENV = "TransientScriptEnv";
    public static final String NM_HOSTNAME_PROP = "NMHostName";
    public static final String SERVER_CMDLINE_STDOUT_PROPERTY = "-Dweblogic.Stdout=";
    public static final String SERVER_CMDLINE_STDERR_PROPERTY = "-Dweblogic.Stderr=";

    public StartupConfig(Properties properties) throws ConfigException {
        super(properties);
        this.loadProperties();
        this.processArguments();
    }

    public StartupConfig() {
    }

    private void loadProperties() throws ConfigException {
        this.javaVendor = this.getProperty(JAVA_VENDOR_PROP, this.javaVendor);
        this.javaHome = this.getProperty(JAVA_HOME_PROP, this.javaHome);
        this.arguments = this.getProperty(ARGUMENTS_PROP);
        this.sslArguments = this.getProperty(SSL_ARGUMENTS_PROP);
        this.securityPolicyFile = this.getProperty(SECURITY_POLICY_FILE_PROP, this.securityPolicyFile);
        this.classPath = this.getProperty(CLASS_PATH_PROP, this.classPath);
        this.beaHome = this.getProperty(BEA_HOME_PROP, this.beaHome);
        this.adminURL = this.getProperty(ADMIN_URL_PROP);
        this.username = this.getProperty(USERNAME_PROP);
        if (this.username == null) {
            this.username = this.getProperty("Username");
        }
        this.password = this.getProperty(PASSWORD_PROP);
        if (this.password == null) {
            this.password = this.getProperty("Password");
        }
        this.autoRestart = this.getBooleanProperty(AUTO_RESTART_PROP, this.autoRestart);
        this.autoKillIfFailed = this.getBooleanProperty(AUTO_KILL_IF_FAILED_PROP, this.autoKillIfFailed);
        this.setServerIPs(this.getProperty(SERVER_IP_PROP));
        this.restartMax = this.getIntProperty(RESTART_MAX_PROP, this.restartMax);
        this.restartInterval = this.getIntProperty(RESTART_INTERVAL_PROP, this.restartInterval);
        this.restartDelaySeconds = this.getIntProperty(RESTART_DELAY_SECONDS_PROP, this.restartDelaySeconds);
        this.serverUid = this.getProperty(SERVER_UID_PROP);
        this.serverGid = this.getProperty(SERVER_GID_PROP);
        this.nmHostName = this.getProperty(NM_HOSTNAME_PROP);
        this.trustKeyStore = this.getProperty("TrustKeyStore");
        this.customTrustKeyStoreFileName = this.getProperty("CustomTrustKeyStoreFileName");
        this.customTrustKeyStoreType = this.getProperty("CustomTrustKeyStoreType");
        this.customTrustKeyStorePassPhrase = this.getProperty("CustomTrustKeyStorePassPhrase");
        this.javaStandardTrustKeyStorePassPhrase = this.getProperty("JavaStandardTrustKeyStorePassPhrase");
        this.transientScriptEnv = this.getProperty(TRANSIENT_SCRIPT_ENV);
        if (this.transientScriptEnv != null) {
            this.props.remove(TRANSIENT_SCRIPT_ENV);
        }
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public void setJavaVendor(String string) {
        this.javaVendor = string;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String string) {
        this.javaHome = string;
    }

    public String getBeaHome() {
        return this.beaHome;
    }

    public void setBeaHome(String string) {
        this.beaHome = string;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public String getSecurityPolicyFile() {
        return this.securityPolicyFile;
    }

    public void setSecurityPolicyFile(String string) {
        this.securityPolicyFile = string;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getSSLArguments() {
        return this.sslArguments;
    }

    public void setSSLArguments(String string) {
        this.sslArguments = string;
    }

    public String getAdminURL() {
        return this.adminURL;
    }

    public void setAdminURL(String string) {
        this.adminURL = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean bl) {
        this.autoRestart = bl;
    }

    public boolean isAutoKillIfFailed() {
        return this.autoKillIfFailed;
    }

    public void setAutoKillIfFailed(boolean bl) {
        this.autoKillIfFailed = bl;
    }

    public int getRestartMax() {
        return this.restartMax;
    }

    public void setRestartMax(int n) {
        this.restartMax = n;
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public void setRestartInterval(int n) {
        this.restartInterval = n;
    }

    public int getRestartDelaySeconds() {
        return this.restartDelaySeconds;
    }

    public void setRestartDelaySeconds(int n) {
        this.restartDelaySeconds = n;
    }

    public List<String> getServerIPList() {
        if ((this.serverIPList == null || this.serverIPList.isEmpty()) && this.serverIPs != null) {
            this.serverIPList = this.getIPListFromString(this.serverIPs);
        }
        return this.serverIPList;
    }

    public void setServerIPList(List<String> list) {
        this.serverIPList = list;
        this.setServerIPs(this.getServerIPsFromList(this.serverIPList));
    }

    private void setServerIPs(String string) {
        this.serverIPs = string;
    }

    private List<String> getIPListFromString(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split(",")) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String getServerIPsFromList(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getUid() {
        return this.serverUid;
    }

    public void setUid(String string) {
        this.serverUid = string;
    }

    public String getGid() {
        return this.serverGid;
    }

    public void setGid(String string) {
        this.serverGid = string;
    }

    public String getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public void setTrustKeyStore(String string) {
        this.trustKeyStore = string;
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.customTrustKeyStoreFileName;
    }

    public void setCustomTrustKeyStoreFileName(String string) {
        this.customTrustKeyStoreFileName = string;
    }

    public String getCustomTrustKeyStoreType() {
        return this.customTrustKeyStoreType;
    }

    public void setCustomTrustKeyStoreType(String string) {
        this.customTrustKeyStoreType = string;
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.customTrustKeyStorePassPhrase;
    }

    public void setCustomTrustKeyStorePassPhrase(String string) {
        this.customTrustKeyStorePassPhrase = string;
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        return this.javaStandardTrustKeyStorePassPhrase;
    }

    public void setJavaStandardTrustKeyStorePassPhrase(String string) {
        this.javaStandardTrustKeyStorePassPhrase = string;
    }

    public Properties getBootProperties() {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty(USERNAME_PROP, this.username);
        }
        if (this.password != null) {
            properties.setProperty(PASSWORD_PROP, this.password);
        }
        if (this.trustKeyStore != null) {
            properties.setProperty("TrustKeyStore", this.trustKeyStore);
        }
        if (this.customTrustKeyStoreFileName != null) {
            properties.setProperty("CustomTrustKeyStoreFileName", this.customTrustKeyStoreFileName);
        }
        if (this.customTrustKeyStoreType != null) {
            properties.setProperty("CustomTrustKeyStoreType", this.customTrustKeyStoreType);
        }
        if (this.customTrustKeyStorePassPhrase != null) {
            properties.setProperty("CustomTrustKeyStorePassPhrase", this.customTrustKeyStorePassPhrase);
        }
        if (this.javaStandardTrustKeyStorePassPhrase != null) {
            properties.setProperty("JavaStandardTrustKeyStorePassPhrase", this.javaStandardTrustKeyStorePassPhrase);
        }
        return properties;
    }

    public Properties getStartupProperties() {
        Properties properties = new Properties();
        if (this.javaVendor != null) {
            properties.setProperty(JAVA_VENDOR_PROP, this.javaVendor);
        }
        if (this.javaHome != null) {
            properties.setProperty(JAVA_HOME_PROP, this.javaHome);
        }
        if (this.beaHome != null) {
            properties.setProperty(BEA_HOME_PROP, this.beaHome);
        }
        if (this.classPath != null) {
            properties.setProperty(CLASS_PATH_PROP, this.classPath);
        }
        if (this.securityPolicyFile != null) {
            properties.setProperty(SECURITY_POLICY_FILE_PROP, this.securityPolicyFile);
        }
        if (this.arguments != null) {
            properties.setProperty(ARGUMENTS_PROP, this.arguments);
        }
        if (this.sslArguments != null) {
            properties.setProperty(SSL_ARGUMENTS_PROP, this.sslArguments);
        }
        if (this.adminURL != null) {
            properties.setProperty(ADMIN_URL_PROP, this.adminURL);
        }
        if (this.serverIPs != null) {
            properties.setProperty(SERVER_IP_PROP, this.serverIPs);
        }
        if (this.nmHostName != null) {
            properties.setProperty(NM_HOSTNAME_PROP, this.nmHostName);
        }
        properties.setProperty(AUTO_RESTART_PROP, Boolean.toString(this.autoRestart));
        properties.setProperty(AUTO_KILL_IF_FAILED_PROP, Boolean.toString(this.autoKillIfFailed));
        properties.setProperty(RESTART_MAX_PROP, Integer.toString(this.restartMax));
        properties.setProperty(RESTART_INTERVAL_PROP, Integer.toString(this.restartInterval));
        properties.setProperty(RESTART_DELAY_SECONDS_PROP, Integer.toString(this.restartDelaySeconds));
        if (this.serverUid != null) {
            properties.setProperty(SERVER_UID_PROP, this.serverUid);
        }
        if (this.serverGid != null) {
            properties.setProperty(SERVER_GID_PROP, this.serverGid);
        }
        return properties;
    }

    public Properties getProperties() {
        Properties properties = this.getBootProperties();
        properties.putAll((Map<?, ?>)this.getStartupProperties());
        return properties;
    }

    public void setKeyStoreProperties(Properties properties) {
        this.trustKeyStore = properties.getProperty("TrustKeyStore");
        this.customTrustKeyStoreFileName = properties.getProperty("CustomTrustKeyStoreFileName");
        this.customTrustKeyStoreType = properties.getProperty("CustomTrustKeyStoreType");
        ClearOrEncryptedService clearOrEncryptedService = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
        String string = properties.getProperty("CustomTrustKeyStorePassPhrase");
        if (string != null) {
            this.customTrustKeyStorePassPhrase = clearOrEncryptedService.encrypt(string);
        }
        if ((string = properties.getProperty("JavaStandardTrustKeyStorePassPhrase")) != null) {
            this.javaStandardTrustKeyStorePassPhrase = clearOrEncryptedService.encrypt(string);
        }
    }

    private void processArguments() {
        if (this.arguments != null) {
            List<Object> list = Arrays.asList((Object[])this.arguments.trim().split("\\s"));
            for (int i = 0; i < list.size(); ++i) {
                String string;
                String string2 = ((String)list.get(i)).trim();
                if (string2.length() <= 0) continue;
                if (string2.startsWith(SERVER_CMDLINE_STDOUT_PROPERTY) && this.serverOutFile == null) {
                    string = string2.substring(string2.indexOf("=") + 1);
                    if (string.startsWith("\"") && string.endsWith("\"")) {
                        this.serverOutFile = string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
                        continue;
                    }
                    this.serverOutFile = string;
                    continue;
                }
                if (!string2.startsWith(SERVER_CMDLINE_STDERR_PROPERTY) || this.serverErrFile != null) continue;
                string = string2.substring(string2.indexOf("=") + 1);
                this.serverErrFile = string.startsWith("\"") && string.endsWith("\"") ? string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")) : string;
            }
        }
    }

    public String getNMHostName() {
        return this.nmHostName;
    }

    public void setNMHostName(String string) {
        this.nmHostName = string;
    }

    public String getServerOutFile() {
        return this.serverOutFile;
    }

    public String getServerErrFile() {
        return this.serverErrFile;
    }

    public String getTransientScriptEnv() {
        return this.transientScriptEnv;
    }
}

