/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import weblogic.management.runtime.ServerStates;
import weblogic.nodemanager.common.StateInfoWriter;
import weblogic.nodemanager.util.ConcurrentFile;

public class StateInfo
implements ServerStates {
    private String state;
    private boolean started;
    private boolean failed;
    private boolean startupAborted;
    private byte[] buf = new byte[256];
    private static final String EOL = StateInfoWriter.EOL;
    private static final String SEPARATOR = ":";
    public static final String ABORTED_STARTUP_SUFFIX = "_ON_ABORTED_STARTUP";

    public synchronized void setState(String string) {
        this.state = string;
        if (string != null && string.endsWith(ABORTED_STARTUP_SUFFIX)) {
            this.startupAborted = true;
        }
    }

    public synchronized void set(String string, boolean bl, boolean bl2) {
        this.state = string;
        this.started = bl;
        this.failed = bl2;
        if (string != null && string.endsWith(ABORTED_STARTUP_SUFFIX)) {
            this.startupAborted = true;
        }
    }

    public synchronized String getState() {
        if (this.state != null && this.state.endsWith(ABORTED_STARTUP_SUFFIX)) {
            return this.state.substring(0, this.state.indexOf(ABORTED_STARTUP_SUFFIX));
        }
        return this.state;
    }

    public synchronized void setStarted(boolean bl) {
        this.started = bl;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isStartupAborted() {
        return this.startupAborted;
    }

    public synchronized void setFailed(boolean bl) {
        this.failed = bl;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized void load(ConcurrentFile concurrentFile) throws IOException {
        int n = concurrentFile.read(ByteBuffer.wrap(this.buf));
        String string = new String(this.buf, 0, n).trim();
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length != 3) {
            throw new IOException("Invalid state file format. State file contents: " + string);
        }
        this.state = stringArray[0].toUpperCase(Locale.ENGLISH);
        this.started = stringArray[1].toUpperCase(Locale.ENGLISH).equals("Y");
        this.failed = stringArray[2].toUpperCase(Locale.ENGLISH).equals("Y");
        if (this.state.endsWith(ABORTED_STARTUP_SUFFIX)) {
            this.startupAborted = true;
        }
    }

    public synchronized void save(ConcurrentFile concurrentFile) throws IOException {
        StateInfoWriter.writeStateInfo((ConcurrentFile)concurrentFile, (String)this.state, (boolean)this.started, (boolean)this.failed);
    }

    public synchronized void reset() {
        this.state = null;
        this.started = false;
        this.failed = false;
    }

    public String toString() {
        return "[state=" + this.state + ",started=" + Boolean.toString(this.started) + ",failed=" + Boolean.toString(this.failed) + "]";
    }
}

