/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.mbean;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import weblogic.coherence.descriptor.wl.CoherenceClusterParamsBean;
import weblogic.coherence.descriptor.wl.CoherenceClusterWellKnownAddressBean;
import weblogic.coherence.descriptor.wl.CoherenceClusterWellKnownAddressesBean;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.management.configuration.CoherenceServerMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ManagedExternalServerMBean;
import weblogic.management.configuration.ManagedExternalServerStartMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.configuration.UnixMachineMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.NodeManagerLogger;
import weblogic.nodemanager.ScriptExecutionFailureException;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.client.ShellClient;
import weblogic.nodemanager.client.VMMClient;
import weblogic.nodemanager.common.CoherenceStartupConfig;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.ServerType;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.nodemanager.mbean.StartRequest;
import weblogic.nodemanager.mbean.TempFileReader;
import weblogic.security.SecurityLogger;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.ServerResource;
import weblogic.security.spi.Resource;
import weblogic.security.utils.SSLSetup;

public class NodeManagerRuntime {
    private String type = "ssl";
    private String host = "localhost";
    private int port = 5556;
    private String cmd = "VERSION";
    private String nmHome = ".";
    private boolean debug = false;
    private static final String TEMP_FILE_NAME = "nodemanager";
    private static final String TEMP_FILE_EXT = ".tmp";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private MachineMBean myMachine;

    private NodeManagerRuntime() {
    }

    private NodeManagerRuntime(String string) {
        this.host = string;
    }

    private NodeManagerRuntime(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.type = string2;
    }

    private NodeManagerRuntime(MachineMBean machineMBean) {
        NodeManagerMBean nodeManagerMBean;
        this.myMachine = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupMachine(machineMBean.getName());
        if (this.myMachine != null && (nodeManagerMBean = this.myMachine.getNodeManager()) != null) {
            int n;
            this.type = nodeManagerMBean.getNMType();
            assert (this.type != null);
            String string = nodeManagerMBean.getListenAddress();
            if (string != null && string.trim().length() > 0) {
                this.host = string;
            }
            if ((n = nodeManagerMBean.getListenPort()) > 0) {
                this.port = n;
            }
            this.cmd = nodeManagerMBean.getShellCommand();
            this.nmHome = nodeManagerMBean.getNodeManagerHome();
            this.debug = nodeManagerMBean.isDebugEnabled();
            this.debug("NodeManagerRuntime created");
        }
    }

    public static NodeManagerRuntime getInstance(String string, int n, String string2) {
        return new NodeManagerRuntime(string, n, string2);
    }

    public static NodeManagerRuntime getInstance(MachineMBean machineMBean) {
        assert (Kernel.isServer());
        if (machineMBean != null) {
            return new NodeManagerRuntime(machineMBean);
        }
        return new NodeManagerRuntime();
    }

    public static NodeManagerRuntime getInstance(ServerMBean serverMBean) {
        assert (Kernel.isServer());
        MachineMBean machineMBean = serverMBean.getMachine();
        if (machineMBean != null) {
            return new NodeManagerRuntime(machineMBean);
        }
        String string = serverMBean.getListenAddress();
        if (string != null && string.trim().length() > 0) {
            return new NodeManagerRuntime(string.trim());
        }
        return new NodeManagerRuntime();
    }

    public static NodeManagerRuntime getInstance(ManagedExternalServerMBean managedExternalServerMBean) {
        assert (Kernel.isServer());
        MachineMBean machineMBean = managedExternalServerMBean.getMachine();
        if (machineMBean != null) {
            return new NodeManagerRuntime(machineMBean);
        }
        return new NodeManagerRuntime();
    }

    public static void checkStartPrivileges(String string, AuthenticatedSubject authenticatedSubject) throws SecurityException {
        ServerResource serverResource;
        AuthorizationManager authorizationManager = SecurityServiceManager.getAuthorizationManager((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT");
        if (!authorizationManager.isAccessAllowed(authenticatedSubject, (Resource)(serverResource = new ServerResource(null, string, "boot")), null)) {
            Loggable loggable = SecurityLogger.logUserNotPermittedToBootLoggable((String)SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject));
            throw new SecurityException(loggable.getMessageText());
        }
    }

    public NodeManagerTask start(ServerMBean serverMBean) throws IOException {
        this.debug(serverMBean.getName(), "Preparing for server startup");
        NMClient nMClient = this.getNMClient(serverMBean);
        StartupProperties startupProperties = StartupPropertiesFactory.getStartupProperties(this, serverMBean);
        Properties properties = startupProperties.getStartupProperties();
        properties.putAll((Map<?, ?>)startupProperties.getBootProperties());
        if (nMClient instanceof VMMClient) {
            ((VMMClient)nMClient).setVirtualMachineName(serverMBean.getVirtualMachineName());
        }
        String string = serverMBean.getName();
        StartRequest startRequest = new StartRequest(string, nMClient, properties);
        Kernel.execute(startRequest);
        this.debug(string, "Server start request task created");
        return startRequest;
    }

    public NodeManagerTask start(ManagedExternalServerMBean managedExternalServerMBean) throws IOException {
        this.debug(managedExternalServerMBean.getName(), "Preparing for server startup");
        NMClient nMClient = this.getNMClient(managedExternalServerMBean);
        StartupProperties startupProperties = StartupPropertiesFactory.getStartupProperties(this, managedExternalServerMBean);
        Properties properties = startupProperties.getStartupProperties();
        properties.putAll((Map<?, ?>)startupProperties.getBootProperties());
        StartRequest startRequest = new StartRequest(managedExternalServerMBean.getName(), nMClient, properties);
        Kernel.execute(startRequest);
        this.debug(managedExternalServerMBean.getName(), "Server start request task created");
        return startRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(ServerMBean serverMBean) throws IOException {
        try {
            NMClient nMClient = this.getNMClient(serverMBean);
            try {
                nMClient.kill();
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logSvrCmdFailedReason((String)"kill", (String)serverMBean.getName(), (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug(serverMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug(serverMBean.getName(), "Command 'kill' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(ManagedExternalServerMBean managedExternalServerMBean) throws IOException {
        try {
            NMClient nMClient = this.getNMClient(managedExternalServerMBean);
            try {
                nMClient.kill();
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logSvrCmdFailedReason((String)"kill", (String)managedExternalServerMBean.getName(), (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug(managedExternalServerMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug(managedExternalServerMBean.getName(), "Command 'kill' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStates(boolean bl, int n) throws IOException {
        String string;
        try {
            ServerMBean[] serverMBeanArray;
            NMClient nMClient = this.getNMClient();
            try {
                string = nMClient.getStates(n);
                serverMBeanArray = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer(string);
                if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
                    stringBuffer.append(' ');
                }
                serverMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getServers();
                String string2 = " " + string;
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    ServerMBean serverMBean = serverMBeanArray[i];
                    ServerStartMBean serverStartMBean = serverMBean.getServerStart();
                    String string3 = " " + serverMBean.getName() + "=";
                    if (string2.indexOf(string3) >= 0 || serverStartMBean == null || serverMBean.getMachine() == null || this.myMachine == null || serverStartMBean.getRootDirectory() == null || !serverMBean.getMachine().getName().equals(this.myMachine.getName())) continue;
                    String string4 = this.getState(serverMBean, n);
                    stringBuffer.append(serverMBean.getName());
                    stringBuffer.append('=');
                    stringBuffer.append(string4);
                    stringBuffer.append(' ');
                }
                string = stringBuffer.toString();
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logDebugMsgWithException((String)"getStates", (Throwable)nMException);
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug("", "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("", "Command 'getStates' returned '" + string + "'");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState(ServerMBean serverMBean, int n) throws IOException {
        String string;
        try {
            NMClient nMClient = this.getNMClient(serverMBean);
            try {
                string = nMClient.getState(n);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            this.debug(serverMBean.getName(), "Error executing STAT on NM " + (Object)((Object)nMException), nMException);
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug(serverMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug(serverMBean.getName(), "Command 'getState' returned '" + string + "'");
        return string;
    }

    public String getState(ServerMBean serverMBean) throws IOException {
        return this.getState(serverMBean, serverMBean.getNMSocketCreateTimeoutInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState(ManagedExternalServerMBean managedExternalServerMBean, int n) throws IOException {
        String string;
        try {
            NMClient nMClient = this.getNMClient(managedExternalServerMBean);
            try {
                string = nMClient.getState(n);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            this.debug(managedExternalServerMBean.getName(), "Error executing STAT on NM " + (Object)((Object)nMException), nMException);
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug(managedExternalServerMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug(managedExternalServerMBean.getName(), "Command 'getState' returned '" + string + "'");
        return string;
    }

    public String getState(ManagedExternalServerMBean managedExternalServerMBean) throws IOException {
        return this.getState(managedExternalServerMBean, managedExternalServerMBean.getNMSocketCreateTimeoutInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLog(ServerMBean serverMBean, Writer writer) throws IOException {
        try {
            NMClient nMClient = this.getNMClient(serverMBean);
            try {
                nMClient.getLog(writer);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logSvrCmdFailedReason((String)"getLog", (String)serverMBean.getName(), (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug(serverMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'getLog' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getLog(ServerMBean serverMBean) throws IOException {
        TempFileReader tempFileReader;
        File file = null;
        try {
            file = this.createTempFile();
        }
        catch (IOException iOException) {
            NodeManagerLogger.logErrorFileCreate((String)"getLog", (String)serverMBean.getName(), (String)"nodemanager.tmp", (String)TEMP_DIR);
            throw iOException;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                this.getLog(serverMBean, fileWriter);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            tempFileReader = new TempFileReader(file);
        }
        catch (IOException iOException) {
            this.debug(serverMBean.getName(), "Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug(serverMBean.getName(), "Command 'getLog' succeeded (tmp file is '" + file + "'");
        return tempFileReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNMLog(Writer writer) throws IOException {
        NMClient nMClient = this.getNMClient();
        try {
            try {
                nMClient.getNMLog(writer);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logNMCmdFailedReason((String)"getNMLog", (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug("Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'getNMLog' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getNMLog() throws IOException {
        TempFileReader tempFileReader;
        File file = null;
        try {
            file = this.createTempFile();
        }
        catch (IOException iOException) {
            NodeManagerLogger.logErrorNMCmdFailedFileCreate((String)"getNMLog", (String)"nodemanager.tmp", (String)TEMP_DIR);
            throw iOException;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                this.getNMLog(fileWriter);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            tempFileReader = new TempFileReader(file);
        }
        catch (IOException iOException) {
            this.debug("Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'getNMLog' succeeded (tmp file is '" + file + "'");
        return tempFileReader;
    }

    private File createTempFile() throws IOException {
        File file = TEMP_DIR != null ? new File(TEMP_DIR) : null;
        return File.createTempFile(TEMP_FILE_NAME, TEMP_FILE_EXT, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(File file, long l) throws IOException, ScriptExecutionFailureException {
        try {
            NMClient nMClient = this.getNMClient();
            try {
                nMClient.execScript(file.getPath(), l);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logNMCmdFailedReason((String)"runScript", (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug("Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'runScript' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerProps(ServerMBean serverMBean) throws IOException {
        StartupProperties startupProperties = StartupPropertiesFactory.getStartupProperties(this, serverMBean);
        Properties properties = startupProperties.getStartupProperties();
        properties.putAll((Map<?, ?>)startupProperties.getBootProperties());
        try {
            NMClient nMClient = this.getNMClient(serverMBean);
            try {
                nMClient.updateServerProps(properties);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logNMCmdFailedReason((String)"updateServerProps", (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug("Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'updateServerProps' succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() throws IOException {
        String string;
        try {
            NMClient nMClient = this.getNMClient();
            try {
                string = nMClient.getVersion();
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                nMClient.done();
                throw throwable;
            }
            nMClient.done();
            {
            }
        }
        catch (NMException nMException) {
            NodeManagerLogger.logNMCmdFailedReason((String)"getVersion", (String)nMException.getMessage());
            throw nMException;
        }
        catch (IOException iOException) {
            this.debug("Error connecting to NodeManager: " + iOException, iOException);
            throw iOException;
        }
        this.debug("Command 'getVersion' returned '" + string + "'");
        return string;
    }

    private NMClient getNMClient() throws IOException {
        this.debug("NM type is " + this.type);
        NMClient nMClient = NMClient.getInstance(this.type);
        nMClient.setVerbose(this.debug);
        nMClient.setHost(this.host);
        nMClient.setPort(this.port);
        if (this.type.equalsIgnoreCase("ssh") || this.type.equalsIgnoreCase("rsh")) {
            if (this.nmHome != null) {
                nMClient.setNMDir(this.nmHome);
            }
            if (this.cmd != null) {
                ((ShellClient)nMClient).setShellCommand(this.cmd);
                this.debug("Client shell command is '" + this.cmd + '\"');
            }
        }
        nMClient.setDomainName(ManagementService.getRuntimeAccess(kernelId).getDomainName());
        try {
            if (nMClient instanceof VMMClient) {
                NodeManagerMBean nodeManagerMBean;
                if (this.myMachine != null && (nodeManagerMBean = this.myMachine.getNodeManager()) != null) {
                    nMClient.setNMUser(nodeManagerMBean.getUserName());
                    nMClient.setNMPass(nodeManagerMBean.getPassword());
                    ((VMMClient)nMClient).setVmmAdapterName(nodeManagerMBean.getAdapterName());
                    ((VMMClient)nMClient).setVmmAdapterVersion(nodeManagerMBean.getAdapterVersion());
                }
            } else {
                DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
                assert (securityConfigurationMBean != null);
                String string = securityConfigurationMBean.getNodeManagerUsername();
                String string2 = securityConfigurationMBean.getNodeManagerPassword();
                if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                    nMClient.setNMUser(string);
                    nMClient.setNMPass(string2);
                    this.debug("Node manager username and password specified");
                }
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getLocalizedMessage());
        }
        return nMClient;
    }

    private NMClient getNMClient(ServerMBean serverMBean) throws IOException {
        NMClient nMClient = this.getNMClient();
        ServerStartMBean serverStartMBean = serverMBean.getServerStart();
        String string = serverStartMBean.getRootDirectory();
        if (string != null) {
            nMClient.setDomainDir(string);
            this.debug(serverMBean.getName(), "Root directory for server is '" + string + "'");
        }
        String string2 = serverMBean.getName();
        nMClient.setServerName(string2);
        nMClient.setServerType(ServerType.WebLogic);
        try {
            if (nMClient instanceof VMMClient) {
                NodeManagerMBean nodeManagerMBean;
                ((VMMClient)nMClient).setVirtualMachineName(serverMBean.getVirtualMachineName());
                MachineMBean machineMBean = serverMBean.getMachine();
                if (machineMBean != null && (nodeManagerMBean = machineMBean.getNodeManager()) != null) {
                    nMClient.setNMUser(nodeManagerMBean.getUserName());
                    nMClient.setNMPass(nodeManagerMBean.getPassword());
                    ((VMMClient)nMClient).setVmmAdapterName(nodeManagerMBean.getAdapterName());
                    ((VMMClient)nMClient).setVmmAdapterVersion(nodeManagerMBean.getAdapterVersion());
                }
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getLocalizedMessage());
        }
        return nMClient;
    }

    private NMClient getNMClient(ManagedExternalServerMBean managedExternalServerMBean) throws IOException {
        NMClient nMClient = this.getNMClient();
        ManagedExternalServerStartMBean managedExternalServerStartMBean = managedExternalServerMBean.getManagedExternalServerStart();
        String string = managedExternalServerStartMBean.getRootDirectory();
        if (string != null) {
            nMClient.setDomainDir(string);
            this.debug(managedExternalServerMBean.getName(), "Root directory for server is '" + string + "'");
        }
        nMClient.setServerName(managedExternalServerMBean.getName());
        nMClient.setServerType(ServerType.Coherence);
        return nMClient;
    }

    public Properties getBootProperties(ServerMBean serverMBean) {
        return StartupPropertiesFactory.getStartupProperties(this, serverMBean).getBootProperties();
    }

    public Properties getBootProperties(ManagedExternalServerMBean managedExternalServerMBean) {
        return StartupPropertiesFactory.getStartupProperties(this, managedExternalServerMBean).getBootProperties();
    }

    public Properties getStartupProperties(ServerMBean serverMBean) {
        return StartupPropertiesFactory.getStartupProperties(this, serverMBean).getStartupProperties();
    }

    public Properties getStartupProperties(ManagedExternalServerMBean managedExternalServerMBean) {
        return StartupPropertiesFactory.getStartupProperties(this, managedExternalServerMBean).getStartupProperties();
    }

    private void debug(String string) {
        if (this.debug) {
            NodeManagerLogger.logDebugMsg((String)(this.host + ":" + this.port + "> <" + string));
        }
    }

    private void debug(String string, Throwable throwable) {
        if (this.debug) {
            NodeManagerLogger.logDebugMsgWithException((String)(this.host + ":" + this.port + "> <" + string), (Throwable)throwable);
        }
    }

    private void debug(String string, String string2) {
        if (this.debug) {
            NodeManagerLogger.logDebugMsg((String)(this.host + ":" + this.port + "> <" + string + "> <" + string2));
        }
    }

    private void debug(String string, String string2, Throwable throwable) {
        if (this.debug) {
            NodeManagerLogger.logDebugMsgWithException((String)(this.host + ":" + this.port + "> <" + string + "> <" + string2), (Throwable)throwable);
        }
    }

    private static abstract class ManagedExternalServerStartupProperties
    extends AbstractStartupProperties {
        private final ManagedExternalServerMBean smb;

        public ManagedExternalServerStartupProperties(NodeManagerRuntime nodeManagerRuntime, ManagedExternalServerMBean managedExternalServerMBean) {
            super(nodeManagerRuntime);
            this.smb = managedExternalServerMBean;
        }

        public Properties getStartupProperties() {
            ConfigurationMBean configurationMBean;
            MachineMBean machineMBean;
            ManagedExternalServerStartMBean managedExternalServerStartMBean = this.smb.getManagedExternalServerStart();
            assert (managedExternalServerStartMBean != null);
            StartupConfig startupConfig = this.createStartupConfig();
            String string = this.trim(managedExternalServerStartMBean.getBeaHome());
            if (string != null) {
                startupConfig.setBeaHome(string);
            }
            if ((string = this.trim(managedExternalServerStartMBean.getJavaVendor())) != null) {
                startupConfig.setJavaVendor(string);
            }
            if ((string = this.trim(managedExternalServerStartMBean.getJavaHome())) != null) {
                startupConfig.setJavaHome(string);
            }
            if ((string = this.trim(managedExternalServerStartMBean.getClassPath())) != null) {
                startupConfig.setClassPath(string);
            }
            if ((string = this.trim(managedExternalServerStartMBean.getArguments())) != null) {
                startupConfig.setArguments(string);
            }
            if ((machineMBean = this.smb.getMachine()) != null && machineMBean instanceof UnixMachineMBean) {
                configurationMBean = (UnixMachineMBean)machineMBean;
                if (configurationMBean.isPostBindUIDEnabled() && (string = this.trim(configurationMBean.getPostBindUID())) != null) {
                    startupConfig.setUid(string);
                }
                if (configurationMBean.isPostBindGIDEnabled() && (string = this.trim(configurationMBean.getPostBindGID())) != null) {
                    startupConfig.setGid(string);
                }
            }
            configurationMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            if (!this.smb.getName().equals(configurationMBean.getAdminServerName())) {
                startupConfig.setAdminURL(PropertyService.getAdminHttpUrl());
                this.debug("StartupProperties: AdminURL = " + startupConfig.getAdminURL());
            } else {
                this.debug("StartupProperties: AdminURL is not set for Admin server");
            }
            startupConfig.setAutoRestart(this.smb.getAutoRestart());
            startupConfig.setRestartMax(this.smb.getRestartMax());
            startupConfig.setRestartInterval(this.smb.getRestartIntervalSeconds());
            int n = this.smb.getRestartDelaySeconds();
            this.debug("StartupProperties: Configured restart delay = " + n);
            startupConfig.setRestartDelaySeconds(n);
            return this.getStartupProperties(startupConfig, this.smb.getName());
        }

        public Properties getBootProperties() {
            StartupConfig startupConfig = this.createStartupConfig();
            ManagedExternalServerStartMBean managedExternalServerStartMBean = this.smb.getManagedExternalServerStart();
            assert (managedExternalServerStartMBean != null);
            Properties properties = startupConfig.getBootProperties();
            if (this.isDebug()) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.debug(this.smb.getName(), "Server boot property '" + entry.getKey() + "' is '" + entry.getValue() + "'");
                }
            }
            return properties;
        }
    }

    private static class CoherenceServerStartupProperties
    extends ManagedExternalServerStartupProperties {
        private final CoherenceServerMBean smb;

        public CoherenceServerStartupProperties(NodeManagerRuntime nodeManagerRuntime, CoherenceServerMBean coherenceServerMBean) {
            super(nodeManagerRuntime, coherenceServerMBean);
            this.smb = coherenceServerMBean;
        }

        protected StartupConfig createStartupConfig(Properties properties) throws ConfigException {
            return new CoherenceStartupConfig(properties);
        }

        protected StartupConfig createStartupConfig() {
            return new CoherenceStartupConfig();
        }

        protected Properties getStartupProperties(StartupConfig startupConfig, String string) {
            Object object;
            assert (startupConfig instanceof CoherenceStartupConfig);
            CoherenceStartupConfig coherenceStartupConfig = (CoherenceStartupConfig)startupConfig;
            CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean = this.smb.getCoherenceClusterSystemResource();
            boolean bl = false;
            if (coherenceClusterSystemResourceMBean != null) {
                if (coherenceClusterSystemResourceMBean.isUsingCustomClusterConfigurationFile()) {
                    object = new File(coherenceClusterSystemResourceMBean.getCustomClusterConfigurationFileName()).getName();
                    coherenceStartupConfig.setCustomClusterConfigurationFileName((String)object);
                    coherenceStartupConfig.setClusterName(coherenceClusterSystemResourceMBean.getName());
                    bl = true;
                } else {
                    object = coherenceClusterSystemResourceMBean.getCoherenceClusterResource();
                    if (object != null) {
                        this.getStartupProperties(coherenceStartupConfig, object.getCoherenceClusterParams());
                    }
                }
            }
            if (!bl) {
                int n;
                if (this.smb.isSet("UnicastListenAddress") && (object = this.smb.getUnicastListenAddress()) != null) {
                    coherenceStartupConfig.setUnicastListenAddress((String)object);
                }
                if (this.smb.isSet("UnicastListenPort") && (n = this.smb.getUnicastListenPort()) != 0) {
                    coherenceStartupConfig.setUnicastListenPort(n);
                }
                if (this.smb.isSet("UnicastPortAutoAdjust")) {
                    coherenceStartupConfig.setUnicastPortAutoAdjust(this.smb.isUnicastPortAutoAdjust());
                }
            }
            return super.getStartupProperties(startupConfig, string);
        }

        private void getStartupProperties(CoherenceStartupConfig coherenceStartupConfig, CoherenceClusterParamsBean coherenceClusterParamsBean) {
            if (coherenceClusterParamsBean != null) {
                CoherenceClusterWellKnownAddressBean[] coherenceClusterWellKnownAddressBeanArray;
                CoherenceClusterWellKnownAddressesBean coherenceClusterWellKnownAddressesBean = coherenceClusterParamsBean.getCoherenceClusterWellKnownAddresses();
                if (coherenceClusterWellKnownAddressesBean != null && (coherenceClusterWellKnownAddressBeanArray = coherenceClusterWellKnownAddressesBean.getCoherenceClusterWellKnownAddresses()) != null) {
                    for (CoherenceClusterWellKnownAddressBean coherenceClusterWellKnownAddressBean : coherenceClusterWellKnownAddressBeanArray) {
                        coherenceStartupConfig.addWellKnownAddress(coherenceClusterWellKnownAddressBean.getName(), coherenceClusterWellKnownAddressBean.getListenAddress(), coherenceClusterWellKnownAddressBean.getListenPort());
                        coherenceClusterWellKnownAddressBean.getName();
                    }
                }
                coherenceStartupConfig.setMulticastListenAddress(coherenceClusterParamsBean.getMulticastListenAddress());
                coherenceStartupConfig.setMulticastListenPort(coherenceClusterParamsBean.getMulticastListenPort());
                coherenceStartupConfig.setTimeToLive(coherenceClusterParamsBean.getTimeToLive());
                coherenceStartupConfig.setUnicastListenAddress(coherenceClusterParamsBean.getUnicastListenAddress());
                coherenceStartupConfig.setUnicastListenPort(coherenceClusterParamsBean.getUnicastListenPort());
                coherenceStartupConfig.setUnicastPortAutoAdjust(coherenceClusterParamsBean.isUnicastPortAutoAdjust());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerStartupProperties
    extends AbstractStartupProperties {
        private final ServerMBean smb;

        public ServerStartupProperties(NodeManagerRuntime nodeManagerRuntime, ServerMBean serverMBean) {
            super(nodeManagerRuntime);
            this.smb = serverMBean;
        }

        @Override
        public Properties getStartupProperties() {
            ClusterMBean clusterMBean;
            Object object;
            MachineMBean machineMBean;
            ServerStartMBean serverStartMBean = this.smb.getServerStart();
            assert (serverStartMBean != null);
            StartupConfig startupConfig = this.createStartupConfig();
            String string = this.trim(serverStartMBean.getBeaHome());
            if (string != null) {
                startupConfig.setBeaHome(string);
            }
            if ((string = this.trim(serverStartMBean.getJavaVendor())) != null) {
                startupConfig.setJavaVendor(string);
            }
            if ((string = this.trim(serverStartMBean.getJavaHome())) != null) {
                startupConfig.setJavaHome(string);
            }
            if ((string = this.trim(serverStartMBean.getClassPath())) != null) {
                startupConfig.setClassPath(string);
            }
            if ((string = this.trim(serverStartMBean.getSecurityPolicyFile())) != null) {
                startupConfig.setSecurityPolicyFile(string);
            }
            if ((string = this.trim(serverStartMBean.getArguments())) != null) {
                startupConfig.setArguments(string);
            }
            if ((string = this.trim(this.getSSLArguments(this.smb))) != null) {
                startupConfig.setSSLArguments(string);
            }
            if ((machineMBean = this.smb.getMachine()) != null && machineMBean instanceof UnixMachineMBean) {
                object = (UnixMachineMBean)machineMBean;
                if (object.isPostBindUIDEnabled() && (string = this.trim(object.getPostBindUID())) != null) {
                    startupConfig.setUid(string);
                }
                if (object.isPostBindGIDEnabled() && (string = this.trim(object.getPostBindGID())) != null) {
                    startupConfig.setGid(string);
                }
            }
            object = ManagementService.getRuntimeAccess(kernelId).getDomain().getAdminServerName();
            if (!this.smb.getName().equals(object)) {
                startupConfig.setAdminURL(PropertyService.getAdminHttpUrl());
                this.debug("StartupProperties: AdminURL = " + startupConfig.getAdminURL());
            } else {
                this.debug("StartupProperties: AdminURL is not set for Admin server");
            }
            startupConfig.setAutoRestart(this.smb.getAutoRestart());
            startupConfig.setAutoKillIfFailed(this.smb.getAutoKillIfFailed());
            startupConfig.setRestartMax(this.smb.getRestartMax());
            startupConfig.setRestartInterval(this.smb.getRestartIntervalSeconds());
            int n = this.smb.getRestartDelaySeconds();
            this.debug("StartupProperties: Configured restart delay = " + n);
            if (this.smb.isAutoMigrationEnabled() && (clusterMBean = this.smb.getCluster()) != null) {
                int n2 = clusterMBean.getHealthCheckIntervalMillis() / 1000;
                int n3 = clusterMBean.getHealthCheckPeriodsUntilFencing();
                int n4 = n2 * n3;
                this.debug("StartupProperties: Health Check Interval seconds = " + n2);
                this.debug("StartupProperties: Health Check Period Before Fencing = " + n3);
                if (n4 > 0 && n == 0) {
                    this.debug("StartupProperties:  Resetting restart delay to " + n4);
                    n = n4;
                }
            }
            this.debug("StartupProperties:  Restart delay seconds " + n);
            startupConfig.setRestartDelaySeconds(n);
            if (this.smb.isAutoMigrationEnabled()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.prepareIPForList(this.smb.getListenAddress(), arrayList);
                for (NetworkAccessPointMBean networkAccessPointMBean : this.smb.getNetworkAccessPoints()) {
                    this.prepareIPForList(networkAccessPointMBean.getListenAddress(), arrayList);
                }
                if (arrayList.isEmpty()) {
                    NodeManagerLogger.logNoIPFoundForMigratableServer();
                }
                startupConfig.setServerIPList(arrayList);
            }
            return this.getStartupProperties(startupConfig, this.smb.getName());
        }

        private void prepareIPForList(String string, List<String> list) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
                string = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                NodeManagerLogger.logUnknownMigratableListenAddress((String)string, (String)unknownHostException.getMessage());
            }
            if (!list.contains(string)) {
                list.add(string);
            }
        }

        @Override
        public Properties getBootProperties() {
            Object object;
            StartupConfig startupConfig = this.createStartupConfig();
            ServerStartMBean serverStartMBean = this.smb.getServerStart();
            assert (serverStartMBean != null);
            String string = serverStartMBean.getUsername();
            String string2 = serverStartMBean.getPassword();
            if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
                ManagementService.getPropertyService(kernelId).establishServerBootIdentity(startupConfig);
            } else {
                object = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
                String string3 = this.trim(serverStartMBean.getUsername());
                if (string3 != null) {
                    startupConfig.setUsername(((ClearOrEncryptedService)object).encrypt(string3));
                }
                if ((string3 = serverStartMBean.getPassword()) != null) {
                    startupConfig.setPassword(((ClearOrEncryptedService)object).encrypt(string3));
                }
            }
            object = this.smb.getSSL();
            if ("KeyStores".equals(object.getIdentityAndTrustLocations())) {
                startupConfig.setKeyStoreProperties(SSLSetup.getSSLTrustProperties(this.smb));
            }
            Properties properties = startupConfig.getBootProperties();
            if (this.isDebug()) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.debug(this.smb.getName(), "Server boot property '" + entry.getKey() + "' is '" + entry.getValue() + "'");
                }
            }
            return properties;
        }

        private String getSSLArguments(ServerMBean serverMBean) {
            SSLMBean sSLMBean = serverMBean.getSSL();
            if (sSLMBean == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-Dweblogic.security.SSL.ignoreHostnameVerification=");
            stringBuffer.append(sSLMBean.isHostnameVerificationIgnored());
            String string = sSLMBean.getHostnameVerifier();
            if (string != null) {
                stringBuffer.append(" -Dweblogic.security.SSL.hostnameVerifier=");
                stringBuffer.append(string);
            }
            stringBuffer.append(" -Dweblogic.ReverseDNSAllowed=");
            stringBuffer.append(serverMBean.isReverseDNSAllowed());
            return stringBuffer.toString();
        }

        @Override
        protected StartupConfig createStartupConfig(Properties properties) throws ConfigException {
            return new StartupConfig(properties);
        }

        @Override
        protected StartupConfig createStartupConfig() {
            return new StartupConfig();
        }
    }

    private static abstract class AbstractStartupProperties
    implements StartupProperties {
        protected final NodeManagerRuntime nmr;

        AbstractStartupProperties(NodeManagerRuntime nodeManagerRuntime) {
            this.nmr = nodeManagerRuntime;
        }

        protected abstract StartupConfig createStartupConfig(Properties var1) throws ConfigException;

        protected abstract StartupConfig createStartupConfig();

        protected Properties getStartupProperties(StartupConfig startupConfig, String string) {
            Properties properties = startupConfig.getStartupProperties();
            if (this.isDebug()) {
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry;
                    Map.Entry<Object, Object> entry2 = entry = iterator.next();
                    this.debug(string, "Server start property '" + entry2.getKey() + "' is '" + entry2.getValue() + "'");
                }
            }
            return properties;
        }

        protected void debug(String string) {
            this.nmr.debug(string);
        }

        protected void debug(String string, String string2) {
            this.nmr.debug(string, string2);
        }

        protected String trim(String string) {
            if (string != null && (string = string.trim()).length() > 0) {
                return string;
            }
            return null;
        }

        protected boolean isDebug() {
            return this.nmr.debug;
        }
    }

    private static class StartupPropertiesFactory {
        private StartupPropertiesFactory() {
        }

        static StartupProperties getStartupProperties(NodeManagerRuntime nodeManagerRuntime, ServerMBean serverMBean) {
            return new ServerStartupProperties(nodeManagerRuntime, serverMBean);
        }

        static StartupProperties getStartupProperties(NodeManagerRuntime nodeManagerRuntime, ManagedExternalServerMBean managedExternalServerMBean) {
            if (managedExternalServerMBean instanceof CoherenceServerMBean) {
                return new CoherenceServerStartupProperties(nodeManagerRuntime, (CoherenceServerMBean)managedExternalServerMBean);
            }
            throw new IllegalStateException("Only Coherence ManagedExternalServerMBean supported");
        }
    }

    static interface StartupProperties {
        public Properties getStartupProperties();

        public Properties getBootProperties();
    }
}

