/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.mbean;

import java.io.IOException;
import java.util.Properties;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.nodemanager.NMConnectException;
import weblogic.nodemanager.NodeManagerLogger;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.mbean.NodeManagerTask;

class StartRequest
implements ExecuteRequest,
NodeManagerTask {
    private NMClient nmc;
    private Properties props;
    private Exception error;
    private long beginTime;
    private long endTime;
    private String status;
    private boolean finished;
    private String serverName;

    StartRequest(String string, NMClient nMClient, Properties properties) {
        this.nmc = nMClient;
        this.props = properties;
        this.serverName = string;
        this.status = "TASK IN PROGRESS";
        this.beginTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecuteThread executeThread) throws Exception {
        String string;
        IOException iOException = null;
        try {
            this.start();
            string = "TASK COMPLETED";
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            string = "FAILED";
        }
        StartRequest startRequest = this;
        synchronized (startRequest) {
            if (iOException != null) {
                if (iOException instanceof NMConnectException) {
                    NMConnectException nMConnectException = (NMConnectException)((Object)iOException);
                    NodeManagerLogger.logNMNotRunning((String)nMConnectException.getHost(), (String)Integer.toString(nMConnectException.getPort()));
                } else {
                    NodeManagerLogger.logServerStartFailure((String)this.serverName, (String)iOException.getMessage());
                }
            }
            this.status = string;
            this.error = iOException;
            this.endTime = System.currentTimeMillis();
            this.finished = true;
            this.nmc = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws IOException {
        try {
            this.nmc.start(this.props);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.nmc.done();
            throw throwable;
        }
        this.nmc.done();
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitForFinish(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 < l && !this.finished) {
            this.wait(l - l3);
            l3 = System.currentTimeMillis() - l2;
        }
    }

    public synchronized void waitForFinish() throws InterruptedException {
        while (!this.finished) {
            this.wait();
        }
    }

    public void cancel() {
        throw new UnsupportedOperationException();
    }

    public synchronized long getBeginTime() {
        return this.beginTime;
    }

    public synchronized long getEndTime() {
        return this.endTime;
    }

    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized Exception getError() {
        return this.error;
    }

    public synchronized void cleanup() {
        if (!this.finished) {
            throw new IllegalStateException("Task is still executing");
        }
    }
}

