/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.mbean;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class TempFileReader
extends FileReader {
    private File file;
    private boolean eof;
    private boolean closed;
    private static HashMap files = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileReader(File file) throws IOException {
        super(file);
        this.file = file;
        HashMap hashMap = files;
        synchronized (hashMap) {
            if (files.containsKey(file)) {
                throw new IllegalArgumentException("A reader is already active for the file");
            }
            files.put(file, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            int n = super.read();
            if (n == -1) {
                this.eof = true;
                this.deleteFile();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            if ((n2 = super.read(cArray, n, n2)) == -1) {
                this.eof = true;
                this.deleteFile();
            }
        }
        return n2;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1L;
            }
            if ((l = super.skip(l)) == -1L) {
                this.eof = true;
                this.deleteFile();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.deleteFile();
        }
    }

    private void deleteFile() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file.delete();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            for (Map.Entry entry : files.entrySet()) {
                File file = (File)entry.getKey();
                FileReader fileReader = (FileReader)entry.getValue();
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                file.delete();
            }
        }
    }
}

