/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.ServerType;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.LogFileRotationUtil;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerManager;
import weblogic.nodemanager.server.ServerManagerI;
import weblogic.nodemanager.server.ServerMonitorI;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.util.ConcurrentFile;
import weblogic.nodemanager.util.ProcessControl;
import weblogic.security.internal.encryption.ClearOrEncryptedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractServerManager
implements ServerManagerI {
    protected final DomainManager domainMgr;
    protected final String serverName;
    private final ServerDir serverDir;
    private final String[] logParams;
    protected ServerMonitorI monitor;
    private boolean recoveryNeeded;
    private StartupConfig conf = null;
    protected boolean domainDirShared;
    private static final Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    protected static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public AbstractServerManager(DomainManager domainManager, String string, ServerType serverType) throws ConfigException, IOException {
        if (domainManager == null) {
            throw new IllegalArgumentException("DomainManager null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Server name null");
        }
        if (serverType == null) {
            throw new IllegalArgumentException("ServerType null");
        }
        this.domainMgr = domainManager;
        this.serverName = string;
        this.serverDir = domainManager.getDomainDir().getServerDir(this.serverName, serverType);
        this.logParams = new String[]{domainManager.getDomainName(), this.serverName};
        this.loadStartupConfig();
        this.initialize();
    }

    protected abstract ServerMonitorI createServerMonitor(StartupConfig var1);

    protected abstract boolean canPingServer(ServerDir var1);

    protected abstract boolean isCrashRecoveryNeeded(StartupConfig var1) throws IOException;

    protected abstract List<WLSProcess.ExecuteCallbackHook> getStopCallbacks(StartupConfig var1) throws IOException;

    protected abstract List<WLSProcess.ExecuteCallbackHook> getStartCallbacks(StartupConfig var1) throws IOException;

    protected abstract StartupConfig createStartupConfig(Properties var1) throws ConfigException;

    private void initialize() throws ConfigException, IOException {
        NMServerConfig nMServerConfig = this.domainMgr.getNMServer().getConfig();
        ProcessControl processControl = nMServerConfig.getProcessControl();
        ConcurrentFile concurrentFile = this.serverDir.getLockFile();
        boolean bl = concurrentFile.exists();
        this.log(Level.FINEST, " Lock file " + concurrentFile + " exists:" + bl);
        if (processControl != null && bl) {
            String string = concurrentFile.readLine();
            this.log(Level.FINEST, " Checking if process from lock file is running :" + string);
            if (processControl.isProcessAlive(string) && this.canPingServer(this.serverDir)) {
                this.log(Level.INFO, nmText.msgMonitoringServer(string));
                this.log(Level.INFO, " Initializing ServerMonitor for " + this + " : with config : " + this.conf);
                this.setServerOutAndErrFiles();
                this.monitor = this.createServerMonitor(this.conf);
                this.monitor.setPreStartHooks(this.getStartCallbacks(this.conf));
                this.monitor.setPostStopHooks(this.getStopCallbacks(this.conf));
                this.monitor.start(string);
            } else if (nMServerConfig.isCrashRecoveryEnabled()) {
                this.setServerOutAndErrFiles();
                this.recoveryNeeded = this.isCrashRecoveryNeeded(this.conf);
            } else {
                concurrentFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Thread createAndStartMonitor(WLSProcess wLSProcess) throws IOException {
        AbstractServerManager abstractServerManager = this;
        synchronized (abstractServerManager) {
            if (this.monitor != null && !this.monitor.isFinished()) {
                throw new IOException(nmText.getServerAlreadyRunning());
            }
            this.monitor = this.createServerMonitor(this.conf);
            return this.monitor.startMonitor(wLSProcess);
        }
    }

    public void recoverServer() throws ConfigException, IOException {
        if (this.recoveryNeeded) {
            this.log(Level.INFO, nmText.getRecoveringServerProcess());
            this.loadStartupConfig();
            this.startServer();
            this.recoveryNeeded = false;
        } else {
            if (this.domainDirShared) {
                return;
            }
            if (this.monitor != null) {
                return;
            }
            ServerMonitorI serverMonitorI = this.createServerMonitor(this.conf);
            if (serverMonitorI.isCleanupAfterCrashNeeded()) {
                serverMonitorI.cleanup(this.getStopCallbacks(this.conf));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Properties properties) throws IllegalStateException, InterruptedException, ConfigException, IOException {
        Object object = this;
        synchronized (object) {
            if (this.monitor != null && !this.monitor.isFinished()) {
                throw new IllegalStateException(nmText.getServerAlreadyRunning());
            }
            this.makeDir(this.serverDir.getLogsDir());
            this.makeDir(this.serverDir.getSecurityDir());
            this.makeDir(this.serverDir.getNMDataDir());
            this.makeDir(this.serverDir.getTmpDir());
            DomainManager domainManager = this.domainMgr;
            synchronized (domainManager) {
                this.makeDir(this.serverDir.getDomainBakDir());
                this.makeDir(this.serverDir.getConfigPrevDir());
            }
            if (properties != null) {
                this.conf = this.saveStartupConfig(properties);
            }
            if (this.conf == null) {
                this.loadStartupConfig();
            }
            this.setServerOutAndErrFiles();
            this.startServer();
        }
        object = this.monitor;
        synchronized (object) {
            while (!this.monitor.isStarted() && !this.monitor.isFinished()) {
                this.monitor.wait();
            }
            if (!this.monitor.isStarted() || this.monitor.isStartupAborted()) {
                throw new IOException(nmText.getServerFailedToStart());
            }
        }
    }

    protected void startServer() throws IOException {
        LogFileRotationUtil.rotateServerFiles(this, this.conf);
        this.monitor = this.createServerMonitor(this.conf);
        this.monitor.setPreStartHooks(this.getStartCallbacks(this.conf));
        this.monitor.setPostStopHooks(this.getStopCallbacks(this.conf));
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDir(File file) throws IOException {
        Class<ServerManager> clazz = ServerManager.class;
        synchronized (ServerManager.class) {
            if (!file.isDirectory()) {
                this.log(Level.INFO, nmText.getCreatingDirectory(file.getPath()));
                if (!file.mkdirs()) {
                    throw new IOException(nmText.getErrorCreatingDirectory(file.getPath()));
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StartupConfig loadStartupConfig() throws ConfigException, IOException {
        Properties properties = new Properties();
        File file = this.serverDir.getStartupConfigFile();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            this.log(Level.INFO, nmText.getStartupPropertiesLoaded(file.getPath()));
        }
        this.conf = this.createStartupConfig(properties);
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartupConfig saveStartupConfig(Properties properties) throws ConfigException, IOException {
        this.saveBootIdentity(properties);
        if (this.domainMgr.getNMServer().getConfig().isDomainsDirRemoteSharingEnabled()) {
            properties.put("NMHostName", this.getNMHostName());
        }
        this.conf = this.createStartupConfig(properties);
        File file = this.serverDir.getStartupConfigFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            properties.store(fileOutputStream, "Server startup properties");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        this.log(Level.INFO, nmText.getStartupPropertiesSaved(file.getPath()));
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBootIdentity(Properties properties) throws IOException {
        String string;
        String string2 = (String)properties.remove("username");
        if (string2 == null) {
            string2 = (String)properties.remove("Username");
        }
        if ((string = (String)properties.remove("password")) == null) {
            string = (String)properties.remove("Password");
        }
        ClearOrEncryptedService clearOrEncryptedService = this.domainMgr.getEncryptor();
        Properties properties2 = new Properties();
        if (string2 != null && string != null) {
            properties2.setProperty("username", clearOrEncryptedService.encrypt(string2));
            properties2.setProperty("password", clearOrEncryptedService.encrypt(string));
            String string3 = (String)properties.remove("TrustKeyStore");
            if (string3 != null) {
                properties2.setProperty("TrustKeyStore", string3);
            }
            if ((string3 = (String)properties.remove("CustomTrustKeyStoreFileName")) != null) {
                properties2.setProperty("CustomTrustKeyStoreFileName", string3);
            }
            if ((string3 = (String)properties.remove("CustomTrustKeyStoreType")) != null) {
                properties2.setProperty("CustomTrustKeyStoreType", string3);
            }
            if ((string3 = (String)properties.remove("CustomTrustKeyStorePassPhrase")) != null) {
                properties2.setProperty("CustomTrustKeyStorePassPhrase", string3);
            }
            if ((string3 = (String)properties.remove("JavaStandardTrustKeyStorePassPhrase")) != null) {
                properties2.setProperty("JavaStandardTrustKeyStorePassPhrase", string3);
            }
            File file = this.serverDir.getNMBootIdentityFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                properties2.store(fileOutputStream, null);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            this.log(Level.INFO, nmText.getBootIdentitySaved(file.getPath()));
        }
    }

    @Override
    public synchronized String getState() throws IOException {
        if (this.monitor != null) {
            return this.monitor.getStateInfo().getState();
        }
        return null;
    }

    @Override
    public synchronized void kill() throws IOException, InterruptedException {
        if (this.monitor == null || this.monitor.isFinished()) {
            throw new IllegalStateException(nmText.getServerNotRunning());
        }
        this.monitor.kill();
    }

    void resetCredentials(String string, String string2) throws IOException, ConfigException {
        if (this.conf == null) {
            this.loadStartupConfig();
        }
        Properties properties = this.conf.getBootProperties();
        properties.setProperty("username", string);
        properties.setProperty("password", string2);
        this.saveBootIdentity(properties);
    }

    @Override
    public DomainManager getDomainManager() {
        return this.domainMgr;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public ServerDir getServerDir() {
        return this.serverDir;
    }

    @Override
    public void log(Level level, String string, Throwable throwable) {
        if (!nmLog.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(this.logParams);
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        nmLog.log(logRecord);
    }

    protected void log(Level level, String string) {
        this.log(level, string, null);
    }

    protected String getNMHostName() {
        String string = this.domainMgr.getNMServer().getConfig().getListenAddress();
        try {
            string = string == null || string.equals("localhost") || string.equals("127.0.0.1") ? InetAddress.getLocalHost().getCanonicalHostName() : InetAddress.getByName(string).getCanonicalHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void setServerOutAndErrFiles() {
        String string;
        String string2 = this.conf.getServerOutFile();
        if (string2 != null) {
            this.serverDir.setOutFile(string2);
        }
        if ((string = this.conf.getServerErrFile()) != null) {
            this.serverDir.setErrFile(string);
        }
    }
}

