/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.common.StateInfo;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.LogFileRotationUtil;
import weblogic.nodemanager.server.LogFormatter;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerManagerI;
import weblogic.nodemanager.server.ServerMonitorI;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.server.WLSProcessBuilder;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.nodemanager.util.ConcurrentFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractServerMonitor
implements ServerMonitorI,
Runnable {
    private final ServerManagerI serverMgr;
    private final DomainManager domainMgr;
    private final ServerDir serverDir;
    private final ConcurrentFile lockFile;
    private final ConcurrentFile stateFile;
    private final StateInfo stateInfo;
    private final WLSProcessBuilder builder;
    private final StartupConfig conf;
    private final LogFormatter formatter;
    private WLSProcess proc;
    private boolean started;
    private boolean killing;
    private boolean finished;
    private int stateCheckCount;
    private boolean killed;
    private boolean startupAborted;
    private long lastBaseStartTime;
    private List<WLSProcess.ExecuteCallbackHook> preStartHooks = new ArrayList<WLSProcess.ExecuteCallbackHook>();
    private List<WLSProcess.ExecuteCallbackHook> postStopHooks = new ArrayList<WLSProcess.ExecuteCallbackHook>();
    private int stateCheckInterval = 500;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();
    private static final String EOL = System.getProperty("line.separator");

    public AbstractServerMonitor(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        this.serverMgr = serverManagerI;
        this.domainMgr = serverManagerI.getDomainManager();
        this.serverDir = serverManagerI.getServerDir();
        this.lockFile = this.serverDir.getLockFile();
        this.stateFile = this.serverDir.getStateFile();
        this.stateInfo = new StateInfo();
        this.stateCheckInterval = this.domainMgr.getNMServer().getConfig().getStateCheckInterval();
        this.conf = startupConfig;
        this.formatter = new LogFormatter();
        this.builder = this.createWLSProcessBuilder(serverManagerI, startupConfig);
    }

    protected abstract WLSProcessBuilder createWLSProcessBuilder(ServerManagerI var1, StartupConfig var2);

    @Override
    public void setPreStartHooks(List<WLSProcess.ExecuteCallbackHook> list) {
        this.preStartHooks = list;
    }

    @Override
    public void setPostStopHooks(List<WLSProcess.ExecuteCallbackHook> list) {
        this.postStopHooks = list;
    }

    @Override
    public synchronized Thread startMonitor(WLSProcess wLSProcess) throws IOException {
        this.setProcess(wLSProcess);
        Thread thread2 = new Thread((Runnable)this, "server monitor");
        thread2.start();
        return thread2;
    }

    @Override
    public synchronized Thread start() throws IOException {
        WLSProcess wLSProcess = this.startWLSProcess();
        return this.startMonitor(wLSProcess);
    }

    @Override
    public synchronized Thread start(String string) throws IOException {
        Object object;
        WLSProcess wLSProcess = this.builder.createProcess(string);
        if (this.lastBaseStartTime == 0L) {
            this.lastBaseStartTime = System.currentTimeMillis() / 1000L;
        }
        if (this.postStopHooks != null) {
            object = this.postStopHooks.iterator();
            while (object.hasNext()) {
                WLSProcess.ExecuteCallbackHook executeCallbackHook = (WLSProcess.ExecuteCallbackHook)object.next();
                wLSProcess.addPostStopHook(executeCallbackHook);
            }
        }
        if ((object = this.createStopScriptAsPostHook()) != null) {
            wLSProcess.addPostStopHook((WLSProcess.ExecuteCallbackHook)object);
        }
        return this.startMonitor(wLSProcess);
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isKilled() {
        return this.killed;
    }

    @Override
    public boolean isCleanupAfterCrashNeeded() throws IOException {
        if (this.stateInfo == null || this.stateInfo.getState() == null) {
            this.loadStateInfo();
        }
        return this.stateInfo != null && this.stateInfo.getState() != null && this.stateInfo.getState().equals("RUNNING") && this.proc == null;
    }

    @Override
    public void cleanup(List<WLSProcess.ExecuteCallbackHook> list) {
        if (list != null) {
            for (WLSProcess.ExecuteCallbackHook executeCallbackHook : list) {
                try {
                    executeCallbackHook.execute();
                }
                catch (IOException iOException) {
                    this.log(Level.FINEST, "The server cleanup failed.", iOException);
                }
            }
        }
        this.serverDir.getLockFile().delete();
        this.serverDir.getStateFile().delete();
        this.serverDir.getPidFile().delete();
        this.serverDir.getURLFile().delete();
    }

    @Override
    public synchronized boolean isStartupAborted() {
        return this.startupAborted;
    }

    @Override
    public StateInfo getStateInfo() {
        return this.stateInfo;
    }

    @Override
    public synchronized boolean kill() throws InterruptedException {
        if (this.proc == null) {
            return false;
        }
        if (!this.builder.isNative()) {
            this.fine("Killing non native process");
            this.proc.destroy();
            this.killing = true;
        } else if (this.proc.isAlive()) {
            String string;
            ConcurrentFile concurrentFile = this.serverDir.getPidFile();
            try {
                string = concurrentFile.readLine();
                this.fine("Read process id of " + string);
            }
            catch (IOException iOException) {
                return false;
            }
            this.fine("Calling kill on the process control for " + string);
            if (!this.builder.getProcessControl().killProcess(string)) {
                this.killing = true;
                this.fine("Process control killProcess return false");
                return false;
            }
        }
        this.killed = true;
        this.fine("Waiting for server to be killed");
        while (!this.finished) {
            this.wait();
        }
        this.killing = false;
        this.fine("Finished killing process");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.runMonitor();
        }
        catch (Throwable throwable) {
            this.severe(nmText.msgErrorUnexpected(), throwable);
        }
        AbstractServerMonitor abstractServerMonitor = this;
        synchronized (abstractServerMonitor) {
            this.fine("runMonitor returned, setting finished=true and notifying waiters");
            this.finished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMonitor() throws IOException, InterruptedException {
        WLSProcess wLSProcess;
        AbstractServerMonitor abstractServerMonitor = this;
        synchronized (abstractServerMonitor) {
            wLSProcess = this.proc;
        }
        int n = 0;
        do {
            boolean bl;
            String string;
            if ((string = wLSProcess.getProcessId()) != null) {
                this.lockFile.writeLine(string);
            }
            this.fine("Wrote process id " + string);
            while (wLSProcess.isAlive()) {
                Thread.sleep(this.stateCheckInterval);
                this.loadStateInfo();
            }
            this.fine("Waiting for the process to die: " + string);
            wLSProcess.waitForProcessDeath();
            this.loadStateInfo();
            this.lockFile.delete();
            if (this.isKilled()) {
                this.fine("Process is killed " + string + " with " + nmText.msgKilled());
                this.info(nmText.msgKilled());
                this.stateInfo.setState("SHUTDOWN");
                break;
            }
            if (!this.stateInfo.isStarted()) {
                this.stateInfo.setState("FAILED_NOT_RESTARTABLE");
                this.info(nmText.getStartupFailedNotRestartable());
                break;
            }
            boolean bl2 = bl = "SHUTTING_DOWN".equals(this.stateInfo.getState()) || "FORCE_SHUTTING_DOWN".equals(this.stateInfo.getState());
            if (bl && !this.stateInfo.isFailed()) {
                this.stateInfo.setState("SHUTDOWN");
                this.info(nmText.msgShutDown());
                break;
            }
            this.stateInfo.setState("FAILED");
            if (!this.conf.isAutoRestart()) {
                this.info(nmText.msgWarnIgnoreFailed());
                this.stateInfo.setState("FAILED_NOT_RESTARTABLE");
                break;
            }
            long l = System.currentTimeMillis() / 1000L;
            if (l - this.lastBaseStartTime > (long)this.conf.getRestartInterval()) {
                n = 0;
                this.lastBaseStartTime = 0L;
            }
            if (++n > this.conf.getRestartMax()) {
                this.info(nmText.msgWarnRestartMax());
                this.stateInfo.setState("FAILED_NOT_RESTARTABLE");
                break;
            }
            this.info(nmText.msgInfoRestarting(n));
            if (this.conf.getRestartDelaySeconds() <= 0) continue;
            this.info(nmText.getSleepForRestartDelay(this.conf.getRestartDelaySeconds()));
            this.stateInfo.setState("FAILED");
            Thread.sleep(this.conf.getRestartDelaySeconds() * 1000);
            if (this.isKilled()) break;
        } while ((wLSProcess = this.startWLSProcess()) != null);
        this.stateInfo.save(this.stateFile);
        this.setProcess(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcess(WLSProcess wLSProcess) {
        AbstractServerMonitor abstractServerMonitor = this;
        synchronized (abstractServerMonitor) {
            this.proc = wLSProcess;
        }
    }

    private synchronized WLSProcess startWLSProcess() throws IOException {
        try {
            return this.startWLSProcess_inner();
        }
        catch (IOException iOException) {
            this.finished = true;
            this.stateInfo.set("FAILED_NOT_RESTARTABLE", false, true);
            this.stateInfo.save(this.stateFile);
            throw iOException;
        }
    }

    private synchronized WLSProcess startWLSProcess_inner() throws IOException {
        WLSProcess.ExecuteCallbackHook executeCallbackHook;
        if (this.killed) {
            return null;
        }
        String[] stringArray = this.builder.getCommandLine();
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (String object : stringArray) {
            if (object.matches("[ \t\n]")) {
                stringBuilder.append("\"").append(object).append("\" ");
                continue;
            }
            stringBuilder.append(object).append(' ');
        }
        this.info(this.getStartString(nmText, stringBuilder));
        Map<String, String> map = this.builder.getEnvironment();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                this.fine("Environment: " + entry2.getKey() + "=" + entry2.getValue());
            }
        }
        this.info(nmText.getWorkingDirectory(this.builder.getDirectory().toString()));
        LogFileRotationUtil.rotateServerFiles(this.serverMgr, this.conf);
        this.info(nmText.getOutFile(this.serverDir.getOutFile().getCanonicalPath()));
        this.stateInfo.set("STARTING", false, false);
        this.stateInfo.save(this.stateFile);
        WLSProcess wLSProcess = this.builder.createProcess();
        if (this.preStartHooks != null) {
            for (WLSProcess.ExecuteCallbackHook executeCallbackHook2 : this.preStartHooks) {
                wLSProcess.addPreStartHook(executeCallbackHook2);
            }
        }
        if (this.postStopHooks != null) {
            for (WLSProcess.ExecuteCallbackHook executeCallbackHook3 : this.postStopHooks) {
                wLSProcess.addPostStopHook(executeCallbackHook3);
            }
        }
        if ((executeCallbackHook = this.createStopScriptAsPostHook()) != null) {
            wLSProcess.addPostStopHook(executeCallbackHook);
        }
        wLSProcess.startProcess();
        if (this.lastBaseStartTime == 0L) {
            this.lastBaseStartTime = System.currentTimeMillis() / 1000L;
        }
        this.setProcess(wLSProcess);
        this.notifyAll();
        return wLSProcess;
    }

    protected String getStartString(NodeManagerTextTextFormatter nodeManagerTextTextFormatter, StringBuilder stringBuilder) {
        return nodeManagerTextTextFormatter.msgStarting(stringBuilder.toString());
    }

    private Properties toProps(Map<String, String> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private WLSProcess.ExecuteCallbackHook createStopScriptAsPostHook() {
        NMServerConfig nMServerConfig = this.domainMgr.getNMServer().getConfig();
        final String string = nMServerConfig.getStopScriptName();
        final long l = nMServerConfig.getExecScriptTimeout();
        WLSProcess.ExecuteCallbackHook executeCallbackHook = null;
        if (nMServerConfig.isStopScriptEnabled() && string != null) {
            executeCallbackHook = new WLSProcess.ExecuteCallbackHook(){

                public void execute() {
                    try {
                        WLSProcessBuilder wLSProcessBuilder = new WLSProcessBuilder(AbstractServerMonitor.this.serverMgr, AbstractServerMonitor.this.conf, true);
                        String[] stringArray = wLSProcessBuilder.getCommandLine();
                        Map<String, String> map = wLSProcessBuilder.getEnvironment();
                        Properties properties = map != null ? AbstractServerMonitor.this.toProps(map) : null;
                        File file = wLSProcessBuilder.getDirectory();
                        int n = NodeManagerSystem.getInstance().executeScript(stringArray, properties, file, l);
                        if (n != 0) {
                            if (n == -101) {
                                NMServer.nmLog.warning(nmText.cmdTimedOut(string, AbstractServerMonitor.this.serverMgr.getServerName(), l));
                            } else {
                                NMServer.nmLog.warning(nmText.cmdFailedSvr(string, AbstractServerMonitor.this.serverMgr.getServerName()));
                            }
                        }
                    }
                    catch (Exception exception) {
                        NMServer.nmLog.warning(nmText.cmdFailedSvrReason(string, AbstractServerMonitor.this.serverMgr.getServerName(), exception.toString()));
                    }
                }
            };
        }
        return executeCallbackHook;
    }

    private synchronized void loadStateInfo() throws IOException {
        try {
            this.stateInfo.load(this.stateFile);
            ++this.stateCheckCount;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        if (this.killing && this.stateCheckCount * this.stateCheckInterval % 30000 == 0) {
            this.fine("Server being killed, last state is " + this.stateInfo);
        }
        if (this.stateInfo.isStartupAborted()) {
            this.startupAborted = true;
        }
        if (!this.started && this.stateInfo.isStarted()) {
            this.started = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Level level, String string, Throwable throwable) {
        String string2;
        this.serverMgr.log(level, string, throwable);
        Object object = this;
        synchronized (object) {
            if (this.proc != null && this.proc.isAlive()) {
                return;
            }
        }
        object = new LogRecord(level, string);
        ((LogRecord)object).setParameters(new String[]{"NodeManager"});
        if (throwable != null) {
            ((LogRecord)object).setThrown(throwable);
        }
        Object object2 = this.formatter;
        synchronized (object2) {
            string2 = this.formatter.format((LogRecord)object);
        }
        if (string2.endsWith(EOL)) {
            string2 = string2.substring(0, string2.length() - EOL.length());
        }
        object2 = this.serverDir.getOutFile();
        try {
            FileWriter fileWriter = new FileWriter((File)object2, true);
            fileWriter.write(string2);
            fileWriter.write(EOL);
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.serverMgr.log(Level.WARNING, nmText.msgErrorFileWrite(((File)object2).toString()), iOException);
        }
    }

    private void log(Level level, String string) {
        this.log(level, string, null);
    }

    private void info(String string) {
        this.log(Level.INFO, string);
    }

    private void fine(String string) {
        this.log(Level.FINEST, string);
    }

    private void severe(String string, Throwable throwable) {
        this.log(Level.SEVERE, string, throwable);
    }
}

