/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.CoherenceStartupConfig;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.server.ServerManagerI;
import weblogic.nodemanager.server.WLSProcessBuilder;
import weblogic.nodemanager.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoherenceProcessBuilder
extends WLSProcessBuilder {
    private static final String STARTUP_CLASS = "weblogic.nodemanager.server.provider.WeblogicCacheServer";
    private static final String COHERENCE_ROOT_DIR = "coherence_3.8";
    private static final String COHERENCE_JAR = "coherence.jar";
    private static final String COHERENCE_SERVER_JAR_VERSION = "10.3.6.0";
    private static final String COHERENCE_SERVER_JAR = "weblogic.server.modules.coherence.server_10.3.6.0.jar";
    private static final Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    protected static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    CoherenceProcessBuilder(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        super(serverManagerI, startupConfig);
        assert (startupConfig instanceof CoherenceStartupConfig);
    }

    @Override
    String[] getJavaCommandLine(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        CharSequence charSequence;
        if (serverManagerI == null) {
            throw new NullPointerException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = startupConfig.getJavaHome();
        if (string == null) {
            string = System.getProperty("java.home");
        }
        arrayList.add(string + File.separator + "bin" + File.separator + "java");
        arrayList.add("-Dtangosol.coherence.member=" + serverManagerI.getServerName());
        CoherenceStartupConfig coherenceStartupConfig = (CoherenceStartupConfig)startupConfig;
        String string2 = this.getOperationalConfigFile(serverManagerI, coherenceStartupConfig);
        if (string2 != null) {
            arrayList.add("-Dtangosol.coherence.override=" + string2);
        } else {
            boolean bl;
            String string3;
            int n;
            int n2;
            CoherenceStartupConfig.WellKnownAddress[] wellKnownAddressArray = coherenceStartupConfig.getWellKnownAddresses();
            int n3 = wellKnownAddressArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                CoherenceStartupConfig.WellKnownAddress wellKnownAddress = wellKnownAddressArray[n2];
                arrayList.add("-Dtangosol.coherence.wka=" + wellKnownAddress.getListenAddress());
                arrayList.add("-Dtangosol.coherence.wka.port=" + wellKnownAddress.getListenPort());
            }
            int n4 = coherenceStartupConfig.getMulticastListenPort();
            if (n4 > 0) {
                arrayList.add("-Dtangosol.coherence.clusterport=" + n4);
            }
            if ((charSequence = coherenceStartupConfig.getMulticastListenAddress()) != null) {
                arrayList.add("-Dtangosol.coherence.clusteraddress=" + (String)charSequence);
            }
            if ((n2 = coherenceStartupConfig.getTimeToLive()) != 4) {
                arrayList.add("-Dtangosol.coherence.ttl=" + n2);
            }
            if ((n = coherenceStartupConfig.getUnicastListenPort()) > 0) {
                arrayList.add("-Dtangosol.coherence.localport=" + n);
            }
            if ((string3 = coherenceStartupConfig.getUnicastListenAddress()) != null) {
                arrayList.add("-Dtangosol.coherence.localhost=" + string3);
            }
            if (!(bl = coherenceStartupConfig.isUnicastPortAutoAdjust())) {
                arrayList.add("-Dtangosol.coherence.localport.adjust=false");
            }
        }
        String string4 = System.getProperty("java.class.path");
        string = startupConfig.getClassPath();
        if (string == null) {
            string = this.getCoherenceClassPath(startupConfig);
        } else {
            string = Platform.parseClassPath((String)string, (String)string4);
            charSequence = new StringBuilder(string);
            ((StringBuilder)charSequence).append(File.pathSeparatorChar).append(string);
        }
        arrayList.add("-Djava.class.path=" + Platform.preparePathForCommand((String)string));
        string = startupConfig.getArguments();
        if (string != null) {
            arrayList.addAll(this.toOptionsList(string));
        }
        arrayList.add("-Dweblogic.RootDirectory=" + serverManagerI.getDomainManager().getDomainDir().getAbsolutePath());
        arrayList.add(STARTUP_CLASS);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getOperationalConfigFile(ServerManagerI serverManagerI, CoherenceStartupConfig coherenceStartupConfig) {
        String string = coherenceStartupConfig.getCustomClusterConfigurationFileName();
        String string2 = coherenceStartupConfig.getClusterName();
        if (string != null && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder(serverManagerI.getDomainManager().getDomainDir().getAbsolutePath());
            stringBuilder.append(File.separator).append("config");
            stringBuilder.append(File.separator).append("coherence");
            stringBuilder.append(File.separator).append(string2);
            stringBuilder.append(File.separator).append(string);
            String string3 = stringBuilder.toString();
            File file = new File(string3);
            if (file.canRead()) {
                return string3;
            }
            nmLog.log(Level.INFO, nmText.msgInvalidCoherenceOperationalConfigFile(string3));
            return null;
        }
        return null;
    }

    private String getCoherenceClassPath(StartupConfig startupConfig) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = startupConfig.getBeaHome();
        if (string == null) {
            string = System.getProperty("bea.home");
        }
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(File.separatorChar).append("modules");
            stringBuilder.append(File.separatorChar).append("features");
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.append(COHERENCE_SERVER_JAR);
        stringBuilder.append(File.pathSeparator);
        String string2 = System.getProperty("coherence.home");
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(File.separatorChar).append("lib");
            stringBuilder.append(File.separatorChar);
        } else if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(File.separatorChar).append(COHERENCE_ROOT_DIR);
            stringBuilder.append(File.separatorChar).append("lib");
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.append(COHERENCE_JAR);
        return stringBuilder.toString();
    }

    @Override
    String[] getScriptCommandLine() {
        return this.getJavaCommandLine();
    }

    @Override
    public Map<String, String> getScriptEnvironment() {
        return this.getEnvironment();
    }
}

