/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.ServerType;
import weblogic.nodemanager.server.AbstractServerManager;
import weblogic.nodemanager.server.CoherenceServerManager;
import weblogic.nodemanager.server.DomainDir;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerManager;
import weblogic.nodemanager.server.UserInfo;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainManager {
    private NMServer nmServer;
    private String domainName;
    private File scriptDir;
    private DomainDir domainDir;
    private UserInfo userInfo;
    private final Map<String, ServerManager> serverMgrs;
    private final Map<String, CoherenceServerManager> coherenceServerMgrs;
    private ClearOrEncryptedService encryptor;
    private Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    private long saltFileTimeStamp;
    private long secretFileTimeStamp;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public DomainManager(NMServer nMServer, String string, String string2) throws ConfigException, IOException {
        this.nmServer = nMServer;
        this.domainName = string;
        this.domainDir = new DomainDir(string2);
        this.serverMgrs = new ConcurrentHashMap<String, ServerManager>();
        this.coherenceServerMgrs = new ConcurrentHashMap<String, CoherenceServerManager>();
        this.scriptDir = this.domainDir.getMigrationScriptDir();
        this.initialize();
    }

    void resetCredentials(String string, String string2) throws IOException {
        File file = this.domainDir.getSecretFile();
        if (!file.exists()) {
            throw new FileNotFoundException(nmText.getPropertiesFileNotFound(file.toString()));
        }
        if (!file.canWrite()) {
            throw new FileNotFoundException(nmText.getPropertiesFileNotWritable(file.toString()));
        }
        this.userInfo.set(string, string2);
        this.userInfo.save(file);
    }

    private void initialize() throws ConfigException, IOException {
        ServerDir[] serverDirArray;
        if (!this.domainDir.isDirectory()) {
            throw new FileNotFoundException(nmText.getDomainDirNotFound(this.domainDir.toString()));
        }
        if (!this.domainDir.getSaltFile().exists() && !this.domainDir.getOldSaltFile().exists()) {
            throw new FileNotFoundException(nmText.getInvalidDomainSalt(this.domainDir.toString()));
        }
        this.loadSaltFile();
        if (this.nmServer.getConfig().isAuthenticationEnabled()) {
            this.loadUserInfo();
        }
        if ((serverDirArray = this.domainDir.getServerDirs()) != null) {
            for (ServerDir serverDir : serverDirArray) {
                this.serverMgrs.put(serverDir.getName(), new ServerManager(this, serverDir.getName()));
            }
            for (ServerManager serverManager : this.serverMgrs.values()) {
                serverManager.recoverServer();
            }
        }
        this.recoverCoherenceServers();
    }

    private void recoverCoherenceServers() throws ConfigException, IOException {
        ServerDir[] serverDirArray = this.domainDir.getServerDirs(ServerType.Coherence);
        if (serverDirArray != null) {
            for (ServerDir serverDir : serverDirArray) {
                this.coherenceServerMgrs.put(serverDir.getName(), new CoherenceServerManager(this, serverDir.getName()));
            }
            for (CoherenceServerManager coherenceServerManager : this.coherenceServerMgrs.values()) {
                ((AbstractServerManager)coherenceServerManager).recoverServer();
            }
        }
    }

    private void loadUserInfo() throws IOException {
        if (this.encryptor == null) {
            throw new FileNotFoundException(nmText.getSaltFileNotFound());
        }
        File file = this.domainDir.getSecretFile();
        if (!file.exists()) {
            throw new FileNotFoundException(nmText.getPropertiesFileNotFound(file.toString()));
        }
        this.userInfo = new UserInfo(this.domainDir);
        this.userInfo.load(file);
        if (this.userInfo.saveNeeded() && file.canWrite()) {
            this.userInfo.save(file);
        }
        this.secretFileTimeStamp = file.lastModified();
    }

    public Map<String, String> getAllStates() throws IOException {
        Map<String, String> map = this.getAllStates(this.serverMgrs);
        if (this.nmLog.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "States = " + map);
            this.log(Level.FINE, "Coherence States = " + (this.coherenceServerMgrs != null ? this.getAllStates(this.coherenceServerMgrs) : Collections.EMPTY_MAP));
        }
        return map;
    }

    private Map<String, String> getAllStates(Map<String, ? extends AbstractServerManager> map) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null) {
            Set<String> set = map.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                AbstractServerManager abstractServerManager = map.get(string = iterator.next());
                String string2 = abstractServerManager.getState();
                hashMap.put(string, string2 == null ? "UNKNOWN" : string2);
            }
        }
        return hashMap;
    }

    private synchronized void loadSaltFile() throws IOException {
        EncryptionService encryptionService;
        try {
            encryptionService = SerializedSystemIni.getEncryptionService(this.domainDir.getPath());
            this.saltFileTimeStamp = this.getSaltFileTimeStamp();
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new IOException(nmText.getErrorLoadingSalt()).initCause(runtimeException);
        }
        this.encryptor = new ClearOrEncryptedService(encryptionService);
    }

    public synchronized ClearOrEncryptedService getEncryptor() {
        return this.encryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerManager getServerManager(String string) throws ConfigException, IOException {
        Map<String, ServerManager> map = this.serverMgrs;
        synchronized (map) {
            ServerManager serverManager = this.serverMgrs.get(string);
            if (serverManager == null) {
                serverManager = new ServerManager(this, string);
                this.serverMgrs.put(string, serverManager);
            }
            return serverManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoherenceServerManager getCoherenceServerManager(String string) throws ConfigException, IOException {
        Map<String, CoherenceServerManager> map = this.coherenceServerMgrs;
        synchronized (map) {
            CoherenceServerManager coherenceServerManager = this.coherenceServerMgrs.get(string);
            if (coherenceServerManager == null) {
                coherenceServerManager = new CoherenceServerManager(this, string);
                this.coherenceServerMgrs.put(string, coherenceServerManager);
            }
            return coherenceServerManager;
        }
    }

    public NMServer getNMServer() {
        return this.nmServer;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DomainDir getDomainDir() {
        return this.domainDir;
    }

    public boolean isAuthorized(String string, String string2) {
        return this.userInfo != null ? this.userInfo.verify(string, string2) : true;
    }

    public void checkFileStamps() throws IOException {
        long l;
        Map<String, String> map = this.getAllStates();
        for (String string : map.values()) {
            if (string.equals("SHUTDOWN") || string.equals("UNKNOWN")) continue;
            return;
        }
        long l2 = this.getSaltFileTimeStamp();
        if (l2 > this.saltFileTimeStamp) {
            this.loadSaltFile();
        }
        if (this.nmServer.getConfig().isAuthenticationEnabled() && this.domainDir.getSecretFile().exists() && (l = this.domainDir.getSecretFile().lastModified()) > this.secretFileTimeStamp) {
            this.loadUserInfo();
        }
    }

    private long getSaltFileTimeStamp() {
        long l = -1L;
        if (this.domainDir.getSaltFile().exists()) {
            l = this.domainDir.getSaltFile().lastModified();
        } else if (this.domainDir.getOldSaltFile().exists()) {
            l = this.domainDir.getOldSaltFile().lastModified();
        }
        return l;
    }

    public void log(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(new String[]{this.domainName});
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        this.nmLog.log(logRecord);
    }

    public void log(Level level, String string) {
        this.log(level, string, null);
    }

    public int execScript(String string, long l) throws IOException {
        File file = new File(this.scriptDir, string);
        if (!file.exists()) {
            throw new FileNotFoundException(nmText.scriptNotFound(this.scriptDir.getPath(), string));
        }
        return NodeManagerSystem.getInstance().executeScript(new String[]{file.getPath()}, null, this.scriptDir, l);
    }
}

