/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.IOException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.server.NMProperties;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.security.Salt;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.internal.encryption.EncryptionServiceFactory;
import weblogic.security.internal.encryption.JSafeEncryptionServiceFactory;
import weblogic.utils.Hex;

class Encryptor {
    private byte[] salt;
    private byte[] key;
    private ClearOrEncryptedService ces;
    static final String ESP = "0x1f48730ab4957122fccb2856671df094bcc294af";
    static final String OESP = "0x194ce8ab97302f33a77c82de564091f1ac4873be";
    NMServerConfig conf;
    private boolean useOESP = false;
    static final String NAME_HASH_KEY_PROP = "nameHashKey";
    static final String ID_HASH_KEY_PROP = "idHashKey";
    static final String OLD_NAME_HASH_KEY_PROP = "nameHashkey";
    static final String OLD_ID_HASH_KEY_PROP = "idHashkey";
    public static final String NM_DATA_PROPERTIES = "nm_data.properties";
    public static final String NM_DATA_PROPERTIES_1 = "SerializedNodeManagerIni.dat";
    public static final String NM_DATA_PROPERTIES_2 = "NodeManagerProperties";
    public static final String KEY_PASSWORD_PROP = "keyPassword";
    public static final String DEFAULT_KEY_PASSWORD = "password";

    private File getEDataFile(String string) {
        File file = new File(string, NM_DATA_PROPERTIES);
        if (!file.exists() && !(file = new File(string, NM_DATA_PROPERTIES_1)).exists()) {
            file = new File(string, NM_DATA_PROPERTIES_2);
            if (!file.exists()) {
                file = null;
            } else {
                this.useOESP = true;
            }
        }
        return file;
    }

    Encryptor(String string) throws ConfigException, IOException {
        this.ces = null;
        File file = this.getEDataFile(string);
        if (file == null) {
            throw new IOException(NodeManagerTextTextFormatter.getInstance().getDataFileNotFound(string));
        }
        this.loadProperties(file);
        JSafeEncryptionServiceFactory jSafeEncryptionServiceFactory = new JSafeEncryptionServiceFactory();
        this.ces = new ClearOrEncryptedService(jSafeEncryptionServiceFactory.getEncryptionService(this.salt, ESP, this.key));
    }

    Encryptor(NMServerConfig nMServerConfig) throws ConfigException, IOException {
        JSafeEncryptionServiceFactory jSafeEncryptionServiceFactory = new JSafeEncryptionServiceFactory();
        this.conf = nMServerConfig;
        String string = nMServerConfig.getNMHome();
        File file = this.getEDataFile(string);
        if (file != null) {
            this.loadProperties(file);
        } else {
            this.createProperties(jSafeEncryptionServiceFactory, new File(string, NM_DATA_PROPERTIES));
        }
        this.initService(jSafeEncryptionServiceFactory);
    }

    private void loadProperties(File file) throws ConfigException, IOException {
        String string;
        NMProperties nMProperties = new NMProperties();
        nMProperties.load(file);
        String string2 = nMProperties.getProperty(NAME_HASH_KEY_PROP);
        if (string2 == null) {
            string2 = nMProperties.getProperty(OLD_NAME_HASH_KEY_PROP);
        }
        if ((string = nMProperties.getProperty(ID_HASH_KEY_PROP)) == null) {
            string = nMProperties.getProperty(OLD_ID_HASH_KEY_PROP);
        }
        if (string2 == null || string == null) {
            throw new ConfigException(NodeManagerTextTextFormatter.getInstance().getInvalidDataFile(file.toString()));
        }
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = string.getBytes();
        this.salt = Hex.fromHexString((byte[])byArray, (int)byArray.length);
        this.key = Hex.fromHexString((byte[])byArray2, (int)byArray2.length);
    }

    private void createProperties(EncryptionServiceFactory encryptionServiceFactory, File file) throws IOException {
        NMProperties nMProperties = new NMProperties();
        this.salt = Salt.getRandomBytes(4);
        this.key = encryptionServiceFactory.createEncryptedSecretKey(this.salt, ESP);
        nMProperties.setProperty(NAME_HASH_KEY_PROP, Hex.asHex((byte[])this.salt, (int)this.salt.length));
        nMProperties.setProperty(ID_HASH_KEY_PROP, Hex.asHex((byte[])this.key, (int)this.key.length));
        nMProperties.save(file, null);
    }

    private void initService(EncryptionServiceFactory encryptionServiceFactory) {
        String string = null;
        try {
            this.ces = new ClearOrEncryptedService(encryptionServiceFactory.getEncryptionService(this.salt, this.useOESP ? OESP : ESP, this.key));
        }
        catch (EncryptionServiceException encryptionServiceException) {
            if (this.useOESP && this.conf != null) {
                string = this.conf.getConfigProperties().getProperty(KEY_PASSWORD_PROP);
                if (string == null || string.equals("")) {
                    string = DEFAULT_KEY_PASSWORD;
                }
                try {
                    this.ces = new ClearOrEncryptedService(encryptionServiceFactory.getEncryptionService(this.salt, string, this.key));
                }
                catch (EncryptionServiceException encryptionServiceException2) {
                    throw (InternalError)new InternalError(NodeManagerTextTextFormatter.getInstance().getEncryptionServiceFailure()).initCause((Throwable)((Object)encryptionServiceException2));
                }
            }
            throw (InternalError)new InternalError(NodeManagerTextTextFormatter.getInstance().getEncryptionServiceFailure()).initCause((Throwable)((Object)encryptionServiceException));
        }
    }

    String encrypt(String string) {
        if (string != null && !this.ces.isEncrypted(string)) {
            string = this.ces.encrypt(string);
        }
        return string;
    }

    String decrypt(String string) {
        if (string != null && this.ces.isEncrypted(string)) {
            string = this.ces.decrypt(string);
        }
        return string;
    }

    ClearOrEncryptedService getCES() {
        return this.ces;
    }
}

