/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.Command;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.DataFormat;
import weblogic.nodemanager.server.AbstractServerManager;
import weblogic.nodemanager.server.CoherenceServerManager;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.ServerManager;
import weblogic.nodemanager.server.ServerManagerI;

class Handler
implements Runnable {
    private NMServer nmServer;
    private Socket sock;
    private BufferedReader in;
    private BufferedWriter out;
    private DomainManager domainMgr;
    private ServerManager serverMgr;
    private CoherenceServerManager coherenceServerMgr;
    private byte[] nmUser;
    private boolean authorized;
    static final String ENCODING = "UTF-8";
    private static final Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    Handler(NMServer nMServer, Socket socket) throws IOException {
        this.nmServer = nMServer;
        this.sock = socket;
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.authorized = !nMServer.getConfig().isAuthenticationEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block13: {
            String string;
            if (this.isDebugEnabled()) {
                this.debugSay("Handling new connection from " + this.sock.getInetAddress());
            }
            while ((string = this.in.readLine()) != null && this.handleCommand(string)) {
            }
            Object var3_3 = null;
            try {
                this.sock.close();
                if (this.isDebugEnabled()) {
                    this.debugSay("Closed connection from " + this.sock.getInetAddress());
                }
                break block13;
            }
            catch (IOException iOException) {
                nmLog.log(Level.WARNING, nmText.getErrorClosingSocket(), iOException);
            }
            break block13;
            {
                catch (Throwable throwable) {
                    nmLog.log(Level.WARNING, nmText.getUncaughtHandlerException() + throwable, throwable);
                    Object var3_4 = null;
                    try {
                        this.sock.close();
                        if (this.isDebugEnabled()) {
                            this.debugSay("Closed connection from " + this.sock.getInetAddress());
                        }
                        break block13;
                    }
                    catch (IOException iOException) {
                        nmLog.log(Level.WARNING, nmText.getErrorClosingSocket(), iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    this.sock.close();
                    if (this.isDebugEnabled()) {
                        this.debugSay("Closed connection from " + this.sock.getInetAddress());
                    }
                }
                catch (IOException iOException) {
                    nmLog.log(Level.WARNING, nmText.getErrorClosingSocket(), iOException);
                }
                throw throwable;
            }
        }
    }

    private boolean handleCommand(String string) throws IOException {
        Command command;
        int n = string.indexOf(32);
        String string2 = n != -1 ? string.substring(0, n) : string;
        try {
            command = Command.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            command = null;
        }
        if (command == null) {
            this.sendERR(nmText.getInvalidCommand(string2));
            return true;
        }
        if (command == Command.VERSION) {
            this.handleVersion();
        } else if (command == Command.DOMAIN) {
            this.handleDomain(string);
        } else if (command == Command.SERVER) {
            this.handleServer(string);
        } else if (command == Command.COHERENCESERVER) {
            this.handleCoherenceServer(string);
        } else if (command == Command.USER) {
            this.handleUser(string);
        } else if (command == Command.PASS) {
            this.handlePass(string);
        } else if (command == Command.START) {
            this.handleStart(false);
        } else if (command == Command.STARTP) {
            this.handleStart(true);
        } else if (command == Command.KILL) {
            this.handleKill();
        } else if (command == Command.STAT) {
            this.handleStat();
        } else if (command == Command.GETLOG) {
            this.handleGetLog();
        } else if (command == Command.GETNMLOG) {
            this.handleGetNMLog();
        } else if (command == Command.GETSTATES) {
            this.handleGetStates();
        } else if (command == Command.EXECSCRIPT) {
            this.handleExecScript(string);
        } else if (command == Command.HELLO) {
            this.sendGreeting();
        } else if (command == Command.QUIT) {
            this.handleQuit(command.toString());
        } else if (command == Command.CHGCRED) {
            this.handleChgCred(string);
        } else if (command == Command.UPDATEPROPS) {
            this.handleUpdateProps();
        } else {
            this.sendERR(nmText.getInvalidCommand(command.toString()));
        }
        return true;
    }

    private void handleGetStates() throws IOException {
        String string2;
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        Map<String, String> map = this.domainMgr.getAllStates();
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = map.keySet();
        for (String string2 : set) {
            String string3 = map.get(string2);
            string3 = string3 != null ? string3 : "UNKNOWN";
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(string3);
            stringBuffer.append(' ');
        }
        string2 = stringBuffer.toString();
        this.sendOK(string2);
        if (this.isDebugEnabled()) {
            this.debugSay("Sent statuses: [" + string2 + "]");
        }
    }

    private void handleVersion() throws IOException {
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        this.sendOK("10.3");
    }

    private void handleDomain(String string) throws IOException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            int n2 = string.indexOf(32, n);
            if (n2 == -1) {
                string2 = string.substring(n);
            } else if (n2 < string.length() - 1) {
                string2 = string.substring(n, n2);
                string3 = string.substring(n2 + 1);
            }
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.DOMAIN.toString()));
            return;
        }
        String string4 = null;
        try {
            this.domainMgr = this.nmServer.getDomainManager(string2, string3);
        }
        catch (ConfigException configException) {
            string4 = nmText.getDomainError();
            nmLog.log(Level.WARNING, string4, configException);
        }
        catch (IOException iOException) {
            string4 = nmText.getDomainIOError();
            nmLog.log(Level.WARNING, string4, iOException);
        }
        if (string4 != null) {
            this.sendERR(string4);
            return;
        }
        this.sendOK(nmText.getSetDomainMsg(string2));
    }

    private void handleQuit(String string) throws IOException {
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        if (this.nmServer.getConfig().getQuitEnabled()) {
            this.sendOK(nmText.getQuitMsg());
            System.exit(0);
        } else {
            this.sendERR(nmText.getDisabledCommand(string));
        }
    }

    private void handleChgCred(String string) throws IOException {
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(32);
        int n2 = -1;
        if (n++ != -1 && n < string.length() && (n2 = string.indexOf(32, n)) != -1 && n2 < string.length() - 1) {
            string2 = string.substring(n, n2);
            string3 = string.substring(n2 + 1);
        }
        if (n++ != -1 && n < string.length()) {
            string2 = string.substring(n);
        }
        if (string2 == null || string3 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.CHGCRED.toString()));
            return;
        }
        String string4 = null;
        try {
            this.domainMgr.resetCredentials(string2, string3);
        }
        catch (IOException iOException) {
            nmLog.log(Level.WARNING, nmText.getServerDirIOError(), iOException);
        }
        if (string4 != null) {
            this.sendERR(string4);
            return;
        }
        this.sendOK(nmText.getDomainCredChg(this.domainMgr.getDomainName()));
    }

    private void handleUpdateProps() throws IOException {
        if (this.isDebugEnabled()) {
            this.debugSay("Updating server '" + this.serverMgr.getServerName() + "' startup properties");
        }
        if (!this.checkServer()) {
            return;
        }
        Properties properties = null;
        properties = new Properties();
        DataFormat.readProperties(this.in, properties);
        String string = null;
        try {
            this.serverMgr.saveStartupConfig(properties);
        }
        catch (Throwable throwable) {
            nmLog.log(Level.WARNING, nmText.getErrorWritingConfig(this.serverMgr.getServerName()), throwable);
        }
        if (string != null) {
            this.sendERR(string);
        } else {
            this.sendOK(nmText.getSrvrPropsUpdate(this.serverMgr.getServerName()));
        }
    }

    private void handleServer(String string) throws IOException {
        this.coherenceServerMgr = null;
        this.serverMgr = null;
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        String string2 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            string2 = string.substring(n);
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.SERVER.toString()));
            return;
        }
        String string3 = null;
        try {
            this.serverMgr = this.domainMgr.getServerManager(string2);
        }
        catch (ConfigException configException) {
            nmLog.log(Level.WARNING, nmText.getServerDirError(), configException);
        }
        catch (IOException iOException) {
            nmLog.log(Level.WARNING, nmText.getServerDirIOError(), iOException);
        }
        if (string3 != null) {
            this.sendERR(string3);
            return;
        }
        this.sendOK(nmText.getSrvrMsg(string2));
    }

    private void handleCoherenceServer(String string) throws IOException {
        this.coherenceServerMgr = null;
        this.serverMgr = null;
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        String string2 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            string2 = string.substring(n);
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.COHERENCESERVER.toString()));
            return;
        }
        try {
            this.coherenceServerMgr = this.domainMgr.getCoherenceServerManager(string2);
        }
        catch (ConfigException configException) {
            nmLog.log(Level.WARNING, nmText.getServerDirError(), configException);
        }
        catch (IOException iOException) {
            nmLog.log(Level.WARNING, nmText.getServerDirIOError(), iOException);
        }
        this.sendOK(nmText.getSrvrMsg(string2));
    }

    private void handleUser(String string) throws IOException {
        if (!this.checkDomain()) {
            return;
        }
        String string2 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            string2 = string.substring(n);
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.USER.toString()));
            return;
        }
        this.nmUser = string2.getBytes(ENCODING);
        this.sendOK(nmText.getNMUserMsg(string2));
    }

    private void handlePass(String string) throws IOException {
        if (!this.checkDomain()) {
            return;
        }
        if (this.nmUser == null) {
            this.sendERR(nmText.getPassError());
            return;
        }
        String string2 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            string2 = string.substring(n);
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.PASS.toString()));
            return;
        }
        if (!this.domainMgr.isAuthorized(new String(this.nmUser, ENCODING), string2)) {
            this.sendERR(nmText.getAuthError(this.domainMgr.getDomainName(), new String(this.nmUser, ENCODING)));
            return;
        }
        this.authorized = true;
        this.sendOK(nmText.getPassMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetLog() throws IOException {
        BufferedReader bufferedReader;
        ServerManagerI serverManagerI = this.getServerManager();
        if (serverManagerI == null) {
            return;
        }
        File file = serverManagerI.getServerDir().getOutFile();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DataFormat.writeEOS(this.out);
            this.sendERR(nmText.getOutputLogNotFound(file.toString()));
            return;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                DataFormat.writeLine(this.out, string);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            bufferedReader.close();
            DataFormat.writeEOS(this.out);
            throw throwable;
        }
        bufferedReader.close();
        DataFormat.writeEOS(this.out);
        this.sendOK(nmText.getServerLogFile());
        if (this.isDebugEnabled()) {
            this.debugSay("Sent server '" + serverManagerI.getServerName() + "' output log file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetNMLog() throws IOException {
        BufferedReader bufferedReader;
        String string;
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        try {
            string = this.nmServer.getConfig().getLogFile();
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DataFormat.writeEOS(this.out);
            this.sendERR("Node manager log file not found");
            return;
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                DataFormat.writeLine(this.out, string);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            bufferedReader.close();
            DataFormat.writeEOS(this.out);
            throw throwable;
        }
        bufferedReader.close();
        DataFormat.writeEOS(this.out);
        this.sendOK(nmText.getNMLogFile());
        if (this.isDebugEnabled()) {
            this.debugSay("Sent NodeManager log file");
        }
    }

    private void handleStat() throws IOException {
        ServerManagerI serverManagerI = this.getServerManager();
        if (serverManagerI == null) {
            return;
        }
        String string = serverManagerI.getState();
        string = string != null ? string : "UNKNOWN";
        this.sendOK(string);
        if (this.isDebugEnabled()) {
            this.debugSay("Sent status on server '" + serverManagerI.getServerName() + "' : " + string);
        }
    }

    private void handleExecScript(String string) throws IOException {
        if (!this.checkDomain() || !this.checkAuthorized()) {
            return;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(32);
        if (n++ != -1 && n < string.length()) {
            int n2 = string.indexOf(32, n);
            if (n2 == -1) {
                string2 = string.substring(n);
            } else if (n2 < string.length() - 1) {
                string2 = string.substring(n, n2);
                string3 = string.substring(n2 + 1);
            }
        }
        if (string2 == null) {
            this.sendERR(nmText.getInvalidCommandSyntax(Command.EXECSCRIPT.toString()));
            return;
        }
        long l = 0L;
        if (string3 != null) {
            l = Long.valueOf(string3);
        }
        try {
            int n3 = this.domainMgr.execScript(string2, l);
            if (n3 != 0) {
                this.sendScriptERR(n3);
            } else {
                this.sendOK(nmText.getScriptMsg(string2));
            }
        }
        catch (IOException iOException) {
            String string4 = nmText.getScriptError();
            nmLog.log(Level.WARNING, string4, iOException);
            this.sendERR(string4);
        }
    }

    private void handleStart(boolean bl) throws IOException {
        ServerManagerI serverManagerI = this.getServerManager();
        if (serverManagerI == null) {
            return;
        }
        Properties properties = null;
        if (bl) {
            properties = new Properties();
            DataFormat.readProperties(this.in, properties);
        }
        String string = null;
        try {
            serverManagerI.start(properties);
        }
        catch (IllegalStateException illegalStateException) {
            string = nmText.getServerStarted(serverManagerI.getServerName());
        }
        catch (Throwable throwable) {
            string = nmText.getServerStartError(serverManagerI.getServerName());
            nmLog.log(Level.WARNING, string, throwable);
        }
        if (string != null) {
            this.sendERR(string);
        } else {
            this.sendOK(nmText.getServerStartedMsg(serverManagerI.getServerName()));
        }
    }

    private void handleKill() throws IOException {
        ServerManagerI serverManagerI = this.getServerManager();
        if (serverManagerI == null) {
            return;
        }
        String string = null;
        try {
            if (this.isDebugEnabled()) {
                this.debugSay("Killing server " + serverManagerI.getServerName());
            }
            serverManagerI.kill();
        }
        catch (IllegalStateException illegalStateException) {
            string = nmText.getServerStopped(serverManagerI.getServerName());
        }
        catch (Throwable throwable) {
            string = nmText.getServerStopError(serverManagerI.getServerName());
            nmLog.log(Level.WARNING, string, throwable);
        }
        if (string != null) {
            this.sendERR(string);
        } else {
            this.sendOK(nmText.getServerKilled(serverManagerI.getServerName()));
        }
    }

    private boolean checkDomain() throws IOException {
        if (this.domainMgr == null) {
            this.sendERR(nmText.getDomainNull());
            return false;
        }
        return true;
    }

    private ServerManagerI getServerManager() throws IOException {
        AbstractServerManager abstractServerManager = this.coherenceServerMgr != null ? this.coherenceServerMgr : this.serverMgr;
        return this.checkServer(abstractServerManager) ? abstractServerManager : null;
    }

    private boolean checkServer() throws IOException {
        return this.checkServer(this.serverMgr);
    }

    private boolean checkServer(ServerManagerI serverManagerI) throws IOException {
        if (serverManagerI == null) {
            this.sendERR(nmText.getServerNull());
            return false;
        }
        return true;
    }

    private boolean checkAuthorized() throws IOException {
        if (!this.authorized) {
            this.sendERR(nmText.getAuthNull());
            return false;
        }
        return true;
    }

    private void sendGreeting() throws IOException {
        String string = nmText.getGreeting("Node Manager");
        this.sendOK(string);
        if (this.isDebugEnabled()) {
            this.debugSay("Sent Greeting : " + string);
        }
    }

    private void sendOK(String string) throws IOException {
        if (this.isDebugEnabled()) {
            this.debugSay("Sending OK message : " + string);
        }
        DataFormat.writeOK(this.out, string);
        if (this.isDebugEnabled()) {
            this.debugSay("Sent OK message : " + string);
        }
    }

    private void sendERR(String string) throws IOException {
        if (this.isDebugEnabled()) {
            this.debugSay("Sending ERROR message : " + string);
        }
        DataFormat.writeERR(this.out, string);
        if (this.isDebugEnabled()) {
            this.debugSay("Sent ERROR message : " + string);
        }
    }

    private void sendScriptERR(int n) throws IOException {
        if (this.isDebugEnabled()) {
            this.debugSay("Sending ERROR for script exit code : " + n);
        }
        DataFormat.writeERR(this.out, String.valueOf(n));
        if (this.isDebugEnabled()) {
            this.debugSay("Sent ERROR for script exit code : " + n);
        }
    }

    private boolean isDebugEnabled() {
        return this.nmServer.isDebugEnabled();
    }

    private void debugSay(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(Thread.currentThread()).append("> ");
        stringBuffer.append(string);
        nmLog.log(Level.FINEST, stringBuffer.toString());
    }
}

