/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.server.Handler;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.NMServerConfig;

class Listener {
    protected NMServer server;
    protected InetAddress host;
    protected int port;
    protected int backlog;
    protected ServerSocket serverSocket;
    protected Channel inheritedChannel;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    Listener(NMServer nMServer, Channel channel) throws IOException {
        this.server = nMServer;
        NMServerConfig nMServerConfig = nMServer.getConfig();
        String string = nMServerConfig.getListenAddress();
        if (string != null) {
            this.host = InetAddress.getByName(string);
        }
        this.port = nMServerConfig.getListenPort();
        this.backlog = nMServerConfig.getListenBacklog();
        this.inheritedChannel = channel;
        if (channel != null) {
            this.inheritedChannel = channel;
            assert (this.inheritedChannel instanceof ServerSocketChannel);
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.inheritedChannel;
            this.serverSocket = serverSocketChannel.socket();
            NMServer.nmLog.info(nmText.getInheritedSocket(this.serverSocket.toString()));
        }
    }

    public void init() throws IOException {
        if (this.inheritedChannel == null) {
            this.serverSocket = this.host != null ? new ServerSocket(this.port, this.backlog, this.host) : new ServerSocket(this.port, this.backlog);
        }
    }

    public void run() throws IOException {
        NMServer.nmLog.info(this.host != null ? nmText.getPlainListenerStartedHost(Integer.toString(this.port), this.host.getHostName()) : nmText.getPlainListenerStarted(Integer.toString(this.port)));
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    if ((socket = this.serverSocket.accept()) == null) {
                        continue;
                    }
                    Handler handler = new Handler(this.server, socket);
                    Thread thread2 = new Thread(handler);
                    thread2.start();
                }
            }
            catch (IOException iOException) {
                NMServer.nmLog.warning(nmText.getFailedConnection(Integer.toString(this.port), this.host.getHostName()) + iOException);
                continue;
            }
            break;
        }
    }
}

