/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerManagerI;
import weblogic.nodemanager.util.ProcessControl;
import weblogic.nodemanager.util.UnixProcessControl;

public class LogFileRotationUtil {
    private static final Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    static void rotateServerFiles(ServerManagerI serverManagerI, StartupConfig startupConfig) throws IOException {
        boolean bl;
        File file;
        DomainManager domainManager = serverManagerI.getDomainManager();
        String string = domainManager.getDomainName();
        String string2 = serverManagerI.getServerName();
        ServerDir serverDir = serverManagerI.getServerDir();
        LogFileRotationUtil.changeDirOwnerships(serverManagerI, startupConfig);
        File file2 = serverDir.getOutFile();
        if (file2.exists()) {
            file = LogFileRotationUtil.rotateLogFile(file2);
            LogFileRotationUtil.info(string, string2, nmText.getRotatedOutputLog(file.getPath()));
        }
        serverDir.getOutFile().createNewFile();
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getOutFile());
        serverDir.getDomainDir().getConfigFile().createNewFile();
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getDomainDir().getConfigFile());
        file = serverDir.getErrFile();
        boolean bl2 = bl = !file.equals(file2);
        if (bl) {
            if (file.exists()) {
                File file3 = LogFileRotationUtil.rotateLogFile(file);
                LogFileRotationUtil.info(string, string2, nmText.getRotatedMsg(file3.getPath()));
            }
            serverDir.getErrFile().createNewFile();
            LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getErrFile());
        } else {
            LogFileRotationUtil.info(string, string2, nmText.getRotatedErrorLogMsg());
        }
    }

    private static File rotateLogFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        File file2 = LogFileRotationUtil.getRotatedFile(file);
        file2.delete();
        if (!file.renameTo(file2)) {
            throw new IOException(nmText.getRotationError(file.toString(), file2.toString()));
        }
        return file2;
    }

    private static File getRotatedFile(File file) {
        File file2 = file.getAbsoluteFile().getParentFile();
        String string = file.getName();
        int n = string.length();
        int n2 = 0;
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (!file3.isFile() || !file3.getName().startsWith(string)) continue;
            String string2 = file3.getName().substring(n);
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (++n2 > 99999) {
            n2 = 0;
        }
        string = string + n2 / 10000 % 10 + n2 / 1000 % 10 + n2 / 100 % 10 + n2 / 10 % 10 + n2 % 10;
        return new File(file2, string);
    }

    private static void changeDirOwnerships(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        ServerDir serverDir = serverManagerI.getServerDir();
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, (File)serverDir);
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getLogsDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getSecurityDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getDataDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getNMDataDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getTmpDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getDomainBakDir());
        LogFileRotationUtil.changeOwnership(serverManagerI, startupConfig, serverDir.getConfigPrevDir());
    }

    private static void changeOwnership(ServerManagerI serverManagerI, StartupConfig startupConfig, File file) {
        NMServer nMServer = serverManagerI.getDomainManager().getNMServer();
        String string = serverManagerI.getDomainManager().getDomainName();
        String string2 = serverManagerI.getServerName();
        ProcessControl processControl = nMServer.getConfig().getProcessControl();
        if (processControl instanceof UnixProcessControl) {
            UnixProcessControl unixProcessControl = (UnixProcessControl)processControl;
            String string3 = startupConfig.getUid();
            String string4 = startupConfig.getGid();
            if (string3 != null || string4 != null) {
                if (unixProcessControl.changeFileOwnership(file, string3, string4)) {
                    LogFileRotationUtil.info(string, string2, nmText.getChangeFileOwnershipSucceeded(file.getPath(), string3 == null ? "" : string3, string4 == null ? "" : string4));
                } else {
                    LogFileRotationUtil.warning(string, string2, nmText.getChangeFileOwnershipFailed(file.getPath(), string3 == null ? "" : string3, string4 == null ? "" : string4));
                }
            }
        }
    }

    private static void log(String string, String string2, Level level, String string3, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setParameters(new String[]{string, string2});
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        nmLog.log(logRecord);
    }

    public static void log(String string, String string2, Level level, String string3) {
        LogFileRotationUtil.log(string, string2, level, string3, null);
    }

    private static void info(String string, String string2, String string3) {
        LogFileRotationUtil.log(string, string2, Level.INFO, string3);
    }

    private static void finest(String string, String string2, String string3) {
        LogFileRotationUtil.log(string, string2, Level.FINEST, string3);
    }

    private static void warning(String string, String string2, String string3) {
        LogFileRotationUtil.log(string, string2, Level.WARNING, string3);
    }

    private static void severe(String string, String string2, String string3, Throwable throwable) {
        LogFileRotationUtil.log(string, string2, Level.SEVERE, string3, throwable);
    }

    private static void severe(String string, String string2, String string3) {
        LogFileRotationUtil.log(string, string2, Level.SEVERE, string3);
    }
}

