/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class LogFormatter
extends Formatter {
    private Date date = new Date();
    private MessageFormat mf;
    private Object[] args = new Object[2];
    private String lineSeparator;
    private boolean showSource;

    LogFormatter(String string) {
        this.lineSeparator = string;
    }

    LogFormatter() {
        this(System.getProperty("line.separator"));
    }

    public synchronized String format(LogRecord logRecord) {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        this.date.setTime(logRecord.getMillis());
        this.args[0] = this.date;
        this.args[1] = logRecord.getLevel().getName();
        if (this.mf == null) {
            this.mf = new MessageFormat("<{0,date} {0,time}> <{1}>");
        }
        this.mf.format(this.args, stringBuffer, (FieldPosition)null);
        if (this.showSource) {
            objectArray = logRecord.getSourceClassName();
            String string = logRecord.getSourceMethodName();
            if (objectArray != null) {
                stringBuffer.append(" <");
                stringBuffer.append((String)objectArray);
                if (string != null) {
                    stringBuffer.append("::");
                    stringBuffer.append(string);
                }
                stringBuffer.append(">");
            }
        }
        if ((objectArray = logRecord.getParameters()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(" <");
                stringBuffer.append(objectArray[i].toString());
                stringBuffer.append(">");
            }
        }
        stringBuffer.append(" <");
        stringBuffer.append(this.formatMessage(logRecord));
        stringBuffer.append(">");
        stringBuffer.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            LogFormatter.appendThrowable(stringBuffer, logRecord.getThrown());
            stringBuffer.append(this.lineSeparator);
        }
        return stringBuffer.toString();
    }

    public String format(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        return this.format(logRecord);
    }

    public String format(Level level, String string) {
        return this.format(level, string, null);
    }

    synchronized void setShowSource(boolean bl) {
        this.showSource = bl;
    }

    private static void appendThrowable(StringBuffer stringBuffer, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        stringBuffer.append(stringWriter.toString());
    }
}

