/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.nodemanager.util.Platform;

public final class NMHelper {
    public static final String WINDOWS_IFCONFIG_SCRIPT = "wlsifconfig.cmd";
    public static final String UNIX_IFCONFIG_SCRIPT = "wlsifconfig.sh";
    public static final String IFCONFIG_ADD = "-addif";
    public static final String IFCONFIG_REMOVE = "-removeif";
    public static final String SERVER_NAME_PROP = "ServerName";
    public static final String SERVER_DIR_PROP = "ServerDir";
    public static final String MAC_BROADCAST_PROP = "UseMACBroadcast";
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeScript(String[] stringArray, Properties properties, File file, long l) throws IOException {
        ProcessRunner processRunner = new ProcessRunner(stringArray, properties, file);
        processRunner.start();
        long l2 = System.currentTimeMillis();
        while (processRunner.isAlive() && NMHelper.waitingForTimeout(l2, l)) {
            try {
                processRunner.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (NMHelper.waitingForTimeout(l2, l) || !processRunner.isAlive()) continue;
            return -101;
        }
        try {
            int n = processRunner.getResponseCode();
            Object var10_8 = null;
            processRunner.cleanup();
            return n;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            processRunner.cleanup();
            throw throwable;
        }
    }

    private static boolean waitingForTimeout(long l, long l2) {
        if (l2 <= 0L) {
            return true;
        }
        return System.currentTimeMillis() < l + l2;
    }

    public static String getIFControlScriptName() {
        if (Platform.isWindows()) {
            return WINDOWS_IFCONFIG_SCRIPT;
        }
        return UNIX_IFCONFIG_SCRIPT;
    }

    public static String[] buildAddMigrationCommand(String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string4, NMHelper.getIFControlScriptName());
        arrayList.add(file.getPath());
        arrayList.add(NMHelper.getIFControlAddParam());
        arrayList.add(NMHelper.wrapSpacesForCmdLine(string2));
        arrayList.add(string);
        if (string3 != null) {
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] buildRemoveMigrationCommand(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string3, NMHelper.getIFControlScriptName());
        arrayList.add(file.getPath());
        arrayList.add(NMHelper.getIFControlRemoveParam());
        arrayList.add(NMHelper.wrapSpacesForCmdLine(string2));
        arrayList.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Properties buildMigrationEnv(String string, String string2) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.put(SERVER_NAME_PROP, string);
        properties.put(SERVER_DIR_PROP, string2);
        return properties;
    }

    public static Properties buildMigrationEnv(String string, String string2, boolean bl) {
        Properties properties = NMHelper.buildMigrationEnv(string, string2);
        properties.put(MAC_BROADCAST_PROP, (Object)bl);
        return properties;
    }

    private static String getIFControlAddParam() {
        return IFCONFIG_ADD;
    }

    private static String getIFControlRemoveParam() {
        return IFCONFIG_REMOVE;
    }

    private static String wrapSpacesForCmdLine(String string) {
        if (string.indexOf(" ") > -1) {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                return string;
            }
            string = "\"" + string + "\"";
        }
        return string;
    }

    private static boolean forceProcessCleanup() {
        return false;
    }

    private static class Drainer
    extends Thread {
        private BufferedReader in;
        private Level level;

        Drainer(InputStream inputStream, Level level) {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
            this.level = level;
        }

        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    NodeManagerSystem.getInstance().getLogger().log(this.level, string);
                }
            }
            catch (IOException iOException) {
                NodeManagerSystem.getInstance().getLogger().log(Level.FINEST, "problem logging script output due to exception", iOException);
            }
        }

        public void cleanup() {
        }
    }

    private static class ProcessRunner
    extends Thread {
        private Process proc;
        private IOException caughtException;
        private String[] cmd;
        private String[] env;
        private File workingDir;
        private Drainer outDrainer;
        private Drainer errDrainer;

        public ProcessRunner(String[] stringArray, Properties properties, File file) {
            this.cmd = stringArray;
            this.workingDir = file;
            if (properties == null) {
                this.env = null;
            } else {
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    arrayList.add(entry.getKey() + "=" + entry.getValue());
                }
                this.env = arrayList.toArray(new String[arrayList.size()]);
            }
        }

        public void run() {
            try {
                this.proc = Runtime.getRuntime().exec(this.cmd, this.env, this.workingDir);
                this.proc.getOutputStream().close();
                this.outDrainer = new Drainer(this.proc.getInputStream(), Level.INFO);
                this.errDrainer = new Drainer(this.proc.getErrorStream(), Level.WARNING);
                this.outDrainer.start();
                this.errDrainer.start();
                try {
                    this.proc.waitFor();
                    this.outDrainer.join();
                    this.errDrainer.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                this.caughtException = iOException;
            }
        }

        public int getResponseCode() throws IOException {
            if (this.caughtException != null) {
                throw this.caughtException;
            }
            if (this.proc == null) {
                throw new AssertionError((Object)"Process never got set!");
            }
            return this.proc.exitValue();
        }

        public void cleanup() {
            if (NMHelper.forceProcessCleanup()) {
                this.proc.destroy();
            }
            if (this.outDrainer != null) {
                this.outDrainer.cleanup();
            }
            if (this.errDrainer != null) {
                this.errDrainer.cleanup();
            }
        }
    }
}

