/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.nodemanager.NodeManagerTextTextFormatter;

public class NMProperties
extends Properties
implements Comparator {
    TreeMap lineInfoMap = new TreeMap(this);
    HashMap nameToLineMap = new HashMap();
    Matcher varMatcher;
    Pattern varPattern = Pattern.compile(this.varPatternString, 4);
    Matcher varOnlyMatcher;
    Pattern varOnlyPattern = Pattern.compile(this.varOnlyPatternString, 4);
    Matcher contMatcher;
    Pattern contPattern = Pattern.compile(this.contPatternString, 4);
    private static final long serialVersionUID = -9039140023562390804L;
    String varPatternString = "^                      # Match beginning of line\n\\s*                   # Match leading whitespaces (not captured)\n(\\w+)                 # The property name (made of word chars)\n\\s*                   # Followed by optional whitespaces\n(?:[=:]|\\s)           # =, : or whitespace as delimiter\n\\s*                 # More optional whitespace\n(.*?)                  # Match till end of line\n(\\\\?)                  # With an optional continuation\n$                      # End of line\n";
    String varOnlyPatternString = "^                      # Match beginning of line\n\\s*                   # Match leading whitespaces (not captured)\n(\\w+)                 # The property name (made of word chars)\n\\s*                   # Followed by optional whitespaces\n$                      # End of line\n";
    String contPatternString = "^                      # Match beginning of line\n\\s*                   # Match leading whitespaces (not captured)\n(.*?)                  # Match any character, relucatant\n(\\\\?)                  # Optional continuation\n$                      # End of line\n";
    private static final int FAB_LINE_BASE = 0x40000000;
    int nextFabLine = 0x40000000;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    private void resetMaps() {
        this.lineInfoMap.clear();
        this.nameToLineMap.clear();
        this.nextFabLine = 0x40000000;
    }

    public NMProperties() {
        this((Properties)null);
    }

    public NMProperties(Properties properties) {
        super(properties);
    }

    public int getIntProperty(String string, int n) throws NumberFormatException {
        String string2 = this.getProperty(string);
        try {
            return string2 != null ? Integer.parseInt(string2) : n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(nmText.getInvalidIntProperty(string));
        }
    }

    public boolean isTrue(String string, boolean bl) {
        String string2 = this.getProperty(string);
        return string2 != null ? "true".equalsIgnoreCase(string2) : bl;
    }

    public boolean isTrue(String string) {
        return "true".equalsIgnoreCase(this.getProperty(string));
    }

    public synchronized void setProperty(String string, String string2, Integer n) {
        this.setProperty(string, string2);
        if (n == null) {
            n = new Integer(this.nextFabLine);
            ++this.nextFabLine;
        }
        this.nameToLineMap.put(string, n);
        LineInfo lineInfo = new LineInfo();
        lineInfo.setName(string);
        this.lineInfoMap.put(n, lineInfo);
    }

    public synchronized void saveWithComments(OutputStream outputStream, String string) throws IOException {
        Object object;
        Object object2;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        Set<Object> set = this.keySet();
        for (Object object3 : set) {
            if (this.nameToLineMap.get(object3) != null) continue;
            object2 = new Integer(this.nextFabLine);
            ++this.nextFabLine;
            this.nameToLineMap.put(object3, object2);
            object = new LineInfo();
            ((LineInfo)object).setName((String)object3);
            this.lineInfoMap.put(object2, object);
        }
        if (string != null) {
            bufferedWriter.write("#" + string);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("#" + new Date().toString());
        bufferedWriter.newLine();
        set = this.lineInfoMap.keySet();
        for (Object object3 : set) {
            object2 = (LineInfo)this.lineInfoMap.get(object3);
            object = ((LineInfo)object2).getName();
            if (object == null) {
                bufferedWriter.write(((LineInfo)object2).getRawLine());
            } else {
                bufferedWriter.write((String)object + "=");
                String string2 = (String)this.get(object);
                if (string2 != null) {
                    bufferedWriter.write(string2);
                }
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    public synchronized void loadWithComments(InputStream inputStream) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        this.resetMaps();
        while ((string = lineNumberReader.readLine()) != null) {
            Object object;
            int n = lineNumberReader.getLineNumber();
            if (!bl) {
                this.varMatcher = this.varPattern.matcher(string);
                if (this.varMatcher.matches()) {
                    string2 = this.varMatcher.group(1);
                    string3 = this.varMatcher.group(2);
                    string4 = this.varMatcher.group(3);
                    if (string4 == null || string4.length() == 0) {
                        this.setProperty(string2, string3, new Integer(n));
                        string2 = null;
                        string3 = null;
                        bl = false;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                this.varOnlyMatcher = this.varOnlyPattern.matcher(string);
                if (this.varOnlyMatcher.matches()) {
                    string2 = this.varOnlyMatcher.group(1);
                    string3 = "";
                    this.setProperty(string2, string3, new Integer(n));
                    continue;
                }
                object = new LineInfo();
                ((LineInfo)object).setRawLine(string);
                this.lineInfoMap.put(new Integer(n), object);
                continue;
            }
            this.contMatcher = this.contPattern.matcher(string);
            if (this.contMatcher.matches()) {
                object = this.contMatcher.group(1);
                string4 = this.contMatcher.group(2);
                string3 = string3 + (String)object;
                if (string4 == null || string4.length() == 0) {
                    this.setProperty(string2, string3, new Integer(n));
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            assert (false) : "Pattern matching error.  Line should have been matched!!";
        }
    }

    public void loadWithComments(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.loadWithComments(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public void load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.load(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWithComments(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.saveWithComments(fileOutputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void saveWithComments(File file) throws IOException {
        this.saveWithComments(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.store(fileOutputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void save(File file) throws IOException {
        this.save(file, null);
    }

    public int compare(Object object, Object object2) {
        Integer n = (Integer)object;
        Integer n2 = (Integer)object2;
        return n.compareTo(n2);
    }

    private static class LineInfo {
        String name;
        String rawLine;

        public LineInfo(String string, String string2) {
            this.name = string;
            this.rawLine = string2;
        }

        public LineInfo() {
            this(null, null);
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setRawLine(String string) {
            this.rawLine = string;
        }

        public String getName() {
            return this.name;
        }

        public String getRawLine() {
            return this.rawLine;
        }
    }
}

