/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.plugin.NMServerI;
import weblogic.nodemanager.server.DomainDir;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.Encryptor;
import weblogic.nodemanager.server.Listener;
import weblogic.nodemanager.server.NMProperties;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.nodemanager.server.SSLConfig;
import weblogic.nodemanager.server.SSLListener;
import weblogic.nodemanager.server.ServerManager;
import weblogic.nodemanager.server.Upgrader;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.nodemanager.util.Platform;

public class NMServer
implements NMServerI {
    private NMServerConfig config;
    private SSLConfig sslConfig;
    private Encryptor encryptor;
    private Map<String, DomainManager> domains = new HashMap<String, DomainManager>();
    private boolean verbose;
    private boolean debug;
    private static Channel inheritedChannel;
    public static final String VERSION = "10.3";
    public static final String FULL_VERSION = "Node manager v10.3";
    public static final String CONFIG_FILE_NAME = "nodemanager.properties";
    public static final Logger nmLog;
    private static final NodeManagerTextTextFormatter nmText;
    private static final String NM_PROP = "weblogic.nodemanager.";
    private static final String[] usageMsg;

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public static void redirectStandardStreams(String string, String string2, String string3) {
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        FileInputStream fileInputStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string2, true));
            printStream2 = Platform.isWindows() && string2.equalsIgnoreCase(string3) ? printStream : (Platform.isUnix() && string2.equals(string3) ? printStream : new PrintStream(new FileOutputStream(string3, true)));
            System.setOut(printStream);
            System.setErr(printStream2);
        }
        catch (Exception exception) {
            nmLog.warning(nmText.getStdOutErrStreams(string2.toString(), string3.toString()));
        }
        try {
            fileInputStream = new FileInputStream(string);
            System.setIn(fileInputStream);
        }
        catch (Exception exception) {
            nmLog.warning(nmText.getInputStream(string.toString()));
        }
    }

    public NMServer(String[] stringArray) throws IOException, ConfigException {
        Object object;
        String string;
        Object object22;
        NMProperties nMProperties = new NMProperties(System.getProperties());
        if (inheritedChannel != null) {
            NMServer.redirectStandardStreams("/dev/null", "nodemanager.out", "nodemanager.out");
        }
        this.parseArguments(stringArray, nMProperties);
        Properties properties = System.getProperties();
        for (Object object22 : properties.keySet()) {
            string = properties.getProperty((String)object22);
            if (((String)object22).startsWith(NM_PROP)) {
                if (nMProperties.containsKey(object22 = ((String)object22).substring(NM_PROP.length()))) continue;
                nMProperties.setProperty((String)object22, string);
                continue;
            }
            if (((String)object22).length() <= 0 || !Character.isUpperCase(((String)object22).charAt(0)) || nMProperties.containsKey(object22)) continue;
            nMProperties.setProperty((String)object22, string);
        }
        File file = new File(nMProperties.getProperty("NodeManagerHome", System.getProperty("user.dir")));
        string = nMProperties.getProperty("PropertiesFile");
        object22 = string != null ? new File(string) : new File(file, CONFIG_FILE_NAME);
        NMProperties nMProperties2 = new NMProperties();
        if (((File)object22).exists()) {
            try {
                nMProperties2.load((File)object22);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(nmText.getInvalidNMPropFile(((File)object22).toString())).initCause(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw (IOException)new IOException(nmText.getErrorReadingNMPropFile(((File)object22).toString())).initCause(iOException);
            }
        }
        nMProperties2.putAll((Map<?, ?>)nMProperties);
        nMProperties = nMProperties2;
        if (this.verbose && nMProperties.getProperty("LogToStderr") == null) {
            nMProperties.setProperty("LogToStderr", "true");
        }
        this.init(nMProperties);
        if (((File)object22).exists()) {
            nmLog.info(nmText.getLoadedNMProps(((File)object22).toString()));
        } else {
            nmLog.warning(nmText.getNMPropsNotFound(((File)object22).toString()));
            nmLog.info(nmText.getSavingNMProps(((File)object22).toString()));
            object = this.config.getConfigProperties();
            ((Properties)object).putAll((Map<?, ?>)nMProperties);
            ((NMProperties)object).save((File)object22);
        }
        Upgrader.upgrade(this.config);
        if (this.verbose && ((object = nMProperties.getProperty("LogToStderr")) == null || "true".equals(object))) {
            System.err.println(FULL_VERSION);
            System.err.println();
            this.config.print(System.err);
        }
    }

    public NMServer(Properties properties) throws IOException, ConfigException {
        NMProperties nMProperties = new NMProperties();
        nMProperties.putAll((Map<?, ?>)properties);
        this.init(nMProperties);
    }

    private void init(NMProperties nMProperties) throws IOException, ConfigException {
        this.config = new NMServerConfig(nMProperties);
        if (this.config.isSecureListener()) {
            this.encryptor = new Encryptor(this.config);
            this.sslConfig = new SSLConfig(nMProperties, this.encryptor);
        }
    }

    public void start(Channel channel) throws ConfigException, IOException {
        this.initDomains();
        Listener listener = this.config.isSecureListener() ? new SSLListener(this, channel) : new Listener(this, channel);
        listener.init();
        listener.run();
    }

    private void initDomains() throws ConfigException, IOException {
        Map map = this.config.getDomainsMap();
        for (Map.Entry entry : map.entrySet()) {
            DomainManager domainManager;
            String string = (String)entry.getKey();
            DomainDir domainDir = new DomainDir((String)entry.getValue());
            if (!domainDir.isValid()) continue;
            String string2 = domainDir.getPath();
            try {
                string2 = domainDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new ConfigException(nmText.getConfigError(string2) + " " + iOException);
            }
            try {
                domainManager = new DomainManager(this, string, string2);
            }
            catch (IOException iOException) {
                nmLog.log(Level.WARNING, nmText.getConfigError(string2), iOException);
                return;
            }
            this.domains.put(string2, domainManager);
        }
    }

    public DomainManager getDomainManager(String string, String string2) throws ConfigException, IOException {
        Map map = this.config.getDomainsMap();
        String string3 = (String)map.get(string);
        if (string3 == null) {
            for (DomainManager domainManager : this.domains.values()) {
                if (!domainManager.getDomainName().equals(string)) continue;
                domainManager.checkFileStamps();
                return domainManager;
            }
            if (!this.config.isDomainRegistrationEnabled()) {
                throw new ConfigException(nmText.getDynamicDomainRegistrationNotAllowed(string, string2));
            }
            if (string2 == null) {
                nmLog.warning(nmText.getUnregisteredDomainName(string));
                string2 = this.config.getWeblogicHome();
            }
        } else if (string2 == null) {
            string2 = string3;
        }
        return this.findOrCreateDomainManager(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainManager findOrCreateDomainManager(String string, String string2) throws ConfigException, IOException {
        string2 = new File(string2).getCanonicalPath();
        Map<String, DomainManager> map = this.domains;
        synchronized (map) {
            DomainManager domainManager = this.domains.get(string2);
            if (domainManager == null) {
                try {
                    domainManager = new DomainManager(this, string, string2);
                }
                catch (ConfigException configException) {
                    nmLog.warning(nmText.getDomainInitError(string, string2));
                    throw configException;
                }
                catch (IOException iOException) {
                    nmLog.warning(nmText.getDomainInitError(string, string2));
                    throw iOException;
                }
                this.domains.put(string2, domainManager);
            } else {
                domainManager.checkFileStamps();
            }
            return domainManager;
        }
    }

    public void reportDomainError(String string, String string2) {
        nmLog.warning(nmText.getDomainInitError(string, string2));
    }

    public Thread initializeAndStartServerMonitor(WLSProcess wLSProcess) throws NMException {
        if (wLSProcess == null) {
            throw new NMException("Given process is null");
        }
        try {
            ServerManager serverManager = this.findOrCreateServerManager(wLSProcess.getServerName(), wLSProcess.getDomainName(), wLSProcess.getDomainDirectory());
            return serverManager.createAndStartMonitor(wLSProcess);
        }
        catch (IOException iOException) {
            if (iOException instanceof NMException) {
                throw (NMException)iOException;
            }
            NMException nMException = new NMException(nmText.getStartMonitorIOError(wLSProcess.getServerName()));
            nMException.initCause((Throwable)iOException);
            throw nMException;
        }
        catch (ConfigException configException) {
            NMException nMException = new NMException(nmText.getStartMonitorConfigError(wLSProcess.getServerName()));
            nMException.initCause((Throwable)configException);
            throw nMException;
        }
    }

    public NMServerConfig getConfig() {
        return this.config;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public static void main(String[] stringArray) {
        assert (inheritedChannel == null || inheritedChannel instanceof ServerSocketChannel) : "Unexpected inherited channel" + inheritedChannel;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-?") && !stringArray[i].equals("-h") && !stringArray[i].equals("-help")) continue;
            NMServer.printUsage();
            System.exit(0);
        }
        try {
            NodeManagerSystem nodeManagerSystem = NodeManagerSystem.getInstance();
            NMServer nMServer = new NMServer(stringArray);
            nodeManagerSystem.initialize(nMServer);
            nMServer.start(inheritedChannel);
        }
        catch (Throwable throwable) {
            nmLog.log(Level.SEVERE, nmText.getFatalError(), throwable);
        }
    }

    private void parseArguments(String[] stringArray, NMProperties nMProperties) {
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                if ((string = stringArray[n++]).equals("-f")) {
                    nMProperties.setProperty("PropertiesFile", stringArray[n++]);
                    continue;
                }
                if (string.equals("-n")) {
                    nMProperties.setProperty("NodeManagerHome", stringArray[n++]);
                    continue;
                }
                if (string.equals("-d")) {
                    nMProperties.setProperty("LogLevel", "ALL");
                    this.debug = true;
                    continue;
                }
                if (string.equals("-v")) {
                    this.verbose = true;
                    continue;
                }
                if (string.startsWith("-%")) {
                    String string2;
                    if (!(string2 = stringArray[n++]).contains("Q")) continue;
                    nMProperties.setProperty("QuitEnabled", String.valueOf(true));
                    continue;
                }
                throw new IllegalArgumentException(nmText.getUnrecognizedOption(string));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(nmText.getInvalidArgument());
        }
    }

    private static void printUsage() {
        for (int i = 0; i < usageMsg.length; ++i) {
            System.err.println(usageMsg[i]);
        }
    }

    private ServerManager findOrCreateServerManager(String string, String string2, String string3) throws IOException, ConfigException {
        if (string == null || string.length() == 0) {
            throw new NMException(nmText.getServerNameNull());
        }
        if (string2 == null || string2.length() == 0) {
            throw new NMException(nmText.getDomainNameNull());
        }
        DomainManager domainManager = this.getDomainManager(string2, string3);
        if (domainManager == null) {
            throw new NMException(nmText.getBadDomain(string2));
        }
        return domainManager.getServerManager(string);
    }

    static {
        try {
            inheritedChannel = System.inheritedChannel();
        }
        catch (Exception exception) {
            inheritedChannel = null;
        }
        nmLog = Logger.getLogger("weblogic.nodemanager");
        nmText = NodeManagerTextTextFormatter.getInstance();
        usageMsg = new String[]{"Usage: java weblogic.nodemanager.server.NMServer [OPTIONS]", "", "Where options include:", "  -n <home>  Specify node manager home directory (default is PWD)", "  -f <file>  Specify node manager properties file", "             (default is NM_HOME/nodemanager.properties)", "  -v         Run in verbose mode", "  -d         Enable debug output to log file", "  -?, -h     Print this usage message"};
    }
}

