/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.Config;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.server.LogFormatter;
import weblogic.nodemanager.server.NMProperties;
import weblogic.nodemanager.server.NetworkInfo;
import weblogic.nodemanager.server.Upgrader;
import weblogic.nodemanager.util.Platform;
import weblogic.nodemanager.util.ProcessControl;
import weblogic.nodemanager.util.ProcessControlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMServerConfig
extends Config {
    private String nmHome = System.getProperty("user.dir");
    private String weblogicHome = System.getProperty("user.dir");
    private String listenAddress;
    private int listenPort = 5556;
    private int listenBacklog = 50;
    private boolean secureListener = true;
    private boolean nativeVersionEnabled = true;
    private boolean crashRecoveryEnabled = false;
    private String javaHome = System.getProperty("java.home");
    private String logFile;
    private int logLimit = 0;
    private int logCount = 1;
    private boolean logAppend = true;
    private boolean logToStderr = false;
    private Level logLevel = Level.INFO;
    private Formatter logFormatter = new LogFormatter();
    private boolean authenticationEnabled = true;
    private boolean domainsFileEnabled = true;
    private File domainsFile;
    private long domainsFileModTime;
    private Map domainsMap;
    private ProcessControl processControl;
    private boolean startScriptEnabled = false;
    private boolean stopScriptEnabled = false;
    private String startScriptName = Platform.isWindows() ? "startWebLogic.cmd" : "startWebLogic.sh";
    private String stopScriptName = null;
    private boolean quitEnabled = false;
    private int stateCheckInterval = 500;
    private final List<NetworkInfo> networkInfoList = new ArrayList<NetworkInfo>();
    private String ifConfigDir;
    private long execScriptTimeout;
    private boolean domainRegistrationEnabled = false;
    private boolean domainsDirRemoteSharingEnabled = false;
    private boolean useMACBroadcast = false;
    public static final String PROPERTIES_VERSION_PROP = "PropertiesVersion";
    public static final String NM_HOME_PROP = "NodeManagerHome";
    public static final String WEBLOGIC_HOME_PROP = "WeblogicHome";
    public static final String JAVA_HOME_PROP = "JavaHome";
    public static final String LISTEN_ADDRESS_PROP = "ListenAddress";
    public static final String LISTEN_PORT_PROP = "ListenPort";
    public static final String LISTEN_BACKLOG_PROP = "ListenBacklog";
    public static final String LISTENER_TYPE_PROP = "ListenerType";
    public static final String SECURE_LISTENER_PROP = "SecureListener";
    public static final String NATIVE_VERSION_ENABLED_PROP = "NativeVersionEnabled";
    public static final String CRASH_RECOVERY_ENABLED_PROP = "CrashRecoveryEnabled";
    public static final String LOG_LIMIT_PROP = "LogLimit";
    public static final String LOG_COUNT_PROP = "LogCount";
    public static final String LOG_FILE_PROP = "LogFile";
    public static final String LOG_APPEND_PROP = "LogAppend";
    public static final String LOG_TO_STDERR_PROP = "LogToStderr";
    public static final String LOG_LEVEL_PROP = "LogLevel";
    public static final String LOG_FORMATTER_PROP = "LogFormatter";
    public static final String AUTHENTICATION_ENABLED_PROP = "AuthenticationEnabled";
    public static final String KEY_PASSWORD_PROP = "keyPassword";
    public static final String DOMAINS_FILE_PROP = "DomainsFile";
    public static final String DOMAINS_FILE_ENABLED_PROP = "DomainsFileEnabled";
    public static final String DOMAIN_DIR_PROP = "DomainDir.";
    public static final String START_SCRIPT_ENABLED_PROP = "StartScriptEnabled";
    public static final String STOP_SCRIPT_ENABLED_PROP = "StopScriptEnabled";
    public static final String START_SCRIPT_NAME_PROP = "StartScriptName";
    public static final String STOP_SCRIPT_NAME_PROP = "StopScriptName";
    public static final String QUIT_ENABLED_PROP = "QuitEnabled";
    public static final String PROPERTIES_FILE_PROP = "PropertiesFile";
    public static final String STATE_CHECK_INTERVAL_PROP = "StateCheckInterval";
    public static final String IF_INTERFACE_NAME = "Interface";
    public static final String IF_NET_MASK_NAME = "NetMask";
    public static final String IF_CONFIG_DIR_PROP = "IfConfigDir";
    public static final String SCRIPT_TIMEOUT_PROP = "ScriptTimeout";
    public static final String USE_MAC_BROADCST_PROP = "UseMACBroadcast";
    public static final String DOMAIN_REGISTRATION_ENABLED_PROP = "DomainRegistrationEnabled";
    public static final String DOMAINDIRS_DIR_REMOTE_SHARING_ENABLED_PROP = "DomainsDirRemoteSharingEnabled";
    private static final String[] KNOWNPROPS = new String[]{"PropertiesVersion", "AuthenticationEnabled", "LogFile", "LogLimit", "LogCount", "LogAppend", "LogToStderr", "LogLevel", "LogFormatter", "ListenBacklog", "CrashRecoveryEnabled", "SecureListener", "CipherSuite", "StartScriptEnabled", "StartScriptName", "StopScriptEnabled", "StopScriptName", "QuitEnabled", "RestartInterval", "RestartMax", "DomainsFile", "DomainsFileEnabled", "StateCheckInterval", "CustomIdentityAlias", "CustomIdentity", "JavaHome", "KeyStores", "ListenAddress", "ListenPort", "NativeVersionEnabled", "NodeManagerHome", "WeblogicHome", "keyFile", "keyPassword", "certificateFile", "NetMask", "Interface", "DomainsDirRemoteSharingEnabled", "CustomTrustKeyStorePassPhrase", "CustomIdentityKeyStoreType", "JavaStandardTrustKeyStorePassPhrase", "DomainRegistrationEnabled", "CustomIdentityKey", "StoreFileName", "KeyStorePassPhrase", "KeyStoreType", "PrivateKeyPassPhrase", "JavaStandardTrustKey", "StorePassPhrase", "CustomTrustKeyStoreFileName", "CustomTrustKeyPassPhrase"};
    public static final int LISTEN_PORT = 5556;
    public static final int PLAIN_LISTEN_PORT = 5556;
    public static final int LISTEN_BACKLOG = 50;
    public static final String LOG_FILE_NAME = "nodemanager.log";
    public static final String DOMAINS_FILE_NAME = "nodemanager.domains";
    private static final Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public NMServerConfig(Properties properties) throws IOException, ConfigException {
        super(properties);
        NMServerConfig.checkUpgrade(properties, false);
        this.nmHome = this.getProperty(NM_HOME_PROP, this.nmHome);
        this.javaHome = this.getProperty(JAVA_HOME_PROP, this.javaHome);
        this.listenBacklog = this.getIntProperty(LISTEN_BACKLOG_PROP, this.listenBacklog);
        this.listenAddress = this.getProperty(LISTEN_ADDRESS_PROP);
        this.secureListener = this.getBooleanProperty(SECURE_LISTENER_PROP, this.secureListener);
        this.listenPort = this.secureListener ? this.getIntProperty(LISTEN_PORT_PROP, 5556) : this.getIntProperty(LISTEN_PORT_PROP, 5556);
        this.nativeVersionEnabled = this.getBooleanProperty(NATIVE_VERSION_ENABLED_PROP, this.nativeVersionEnabled);
        this.crashRecoveryEnabled = this.getBooleanProperty(CRASH_RECOVERY_ENABLED_PROP, this.crashRecoveryEnabled);
        this.authenticationEnabled = this.getBooleanProperty(AUTHENTICATION_ENABLED_PROP, this.authenticationEnabled);
        this.logFile = properties.getProperty(LOG_FILE_PROP);
        if (this.logFile == null) {
            this.logFile = new File(this.nmHome, LOG_FILE_NAME).getPath();
        }
        this.logLevel = this.getLevelProperty(LOG_LEVEL_PROP, this.logLevel);
        String string = properties.getProperty(LOG_FORMATTER_PROP);
        if (string != null) {
            this.logFormatter = this.loadFormatter(string);
        }
        this.logLimit = this.getIntProperty(LOG_LIMIT_PROP, this.logLimit);
        this.logCount = this.getIntProperty(LOG_COUNT_PROP, this.logCount);
        this.logAppend = this.getBooleanProperty(LOG_APPEND_PROP, this.logAppend);
        this.logToStderr = this.getBooleanProperty(LOG_TO_STDERR_PROP, this.logToStderr);
        this.domainsFileEnabled = this.getBooleanProperty(DOMAINS_FILE_ENABLED_PROP, this.domainsFileEnabled);
        string = this.getProperty(DOMAINS_FILE_PROP);
        this.domainsFile = string != null ? new File(string) : new File(this.nmHome, DOMAINS_FILE_NAME);
        this.initLogger(nmLog);
        this.initDomainsMap();
        if (this.nativeVersionEnabled) {
            this.initProcessControl();
        }
        this.startScriptEnabled = this.getBooleanProperty(START_SCRIPT_ENABLED_PROP, this.startScriptEnabled);
        this.stopScriptEnabled = this.getBooleanProperty(STOP_SCRIPT_ENABLED_PROP, this.stopScriptEnabled);
        this.startScriptName = this.getProperty(START_SCRIPT_NAME_PROP, this.startScriptName);
        this.stopScriptName = this.getProperty(STOP_SCRIPT_NAME_PROP, this.stopScriptName);
        this.quitEnabled = this.getBooleanProperty(QUIT_ENABLED_PROP, this.quitEnabled);
        this.ifConfigDir = this.getProperty(IF_CONFIG_DIR_PROP);
        this.execScriptTimeout = this.getLongProperty(SCRIPT_TIMEOUT_PROP, 60000L);
        this.useMACBroadcast = this.getBooleanProperty(USE_MAC_BROADCST_PROP, this.useMACBroadcast);
        this.domainRegistrationEnabled = this.getBooleanProperty(DOMAIN_REGISTRATION_ENABLED_PROP, this.domainRegistrationEnabled);
        this.domainsDirRemoteSharingEnabled = this.getBooleanProperty(DOMAINDIRS_DIR_REMOTE_SHARING_ENABLED_PROP, this.domainsDirRemoteSharingEnabled);
    }

    private long getLongProperty(String string, long l) throws ConfigException {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigException(nmText.getInvalidScriptTimeout(string2, string));
            }
        }
        return l;
    }

    private Level getLevelProperty(String string, Level level) throws ConfigException {
        String string2 = this.getProperty(LOG_LEVEL_PROP);
        if (string2 != null) {
            try {
                return Level.parse(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigException(nmText.getInvalidLogLevel(string2, string));
            }
        }
        return level;
    }

    private Formatter loadFormatter(String string) throws ConfigException {
        try {
            Object obj = Class.forName(string).newInstance();
            return (Formatter)obj;
        }
        catch (Throwable throwable) {
            throw new ConfigException(nmText.getLogFormatterError(string), throwable);
        }
    }

    private void initProcessControl() throws ConfigException {
        try {
            this.processControl = ProcessControlFactory.getProcessControl();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new ConfigException(nmText.getNativeLibraryLoadError(), (Throwable)unsatisfiedLinkError);
        }
        if (this.processControl == null) {
            throw new ConfigException(nmText.getNativeLibraryNA());
        }
    }

    public static boolean checkUpgrade(Properties properties, boolean bl) throws ConfigException {
        boolean bl2 = false;
        String string = properties.getProperty(LISTENER_TYPE_PROP);
        if (string != null) {
            properties.remove(LISTENER_TYPE_PROP);
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getRemovingProp(LISTENER_TYPE_PROP));
            }
            bl2 = true;
            if (!properties.contains(SECURE_LISTENER_PROP)) {
                if (string.equalsIgnoreCase("plainSocket")) {
                    if (bl) {
                        Upgrader.log(Level.INFO, nmText.getAddingProp(SECURE_LISTENER_PROP, "false"));
                    }
                    properties.setProperty(SECURE_LISTENER_PROP, "false");
                } else if (string.equalsIgnoreCase("secureSocket")) {
                    if (bl) {
                        Upgrader.log(Level.INFO, nmText.getAddingProp(SECURE_LISTENER_PROP, "true"));
                    }
                    properties.setProperty(SECURE_LISTENER_PROP, "true");
                } else {
                    throw new ConfigException(nmText.getInvalidPropValue(LISTENER_TYPE_PROP, string));
                }
            }
        }
        if (!"10.3".equals(string = properties.getProperty(PROPERTIES_VERSION_PROP))) {
            properties.setProperty(PROPERTIES_VERSION_PROP, "10.3");
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getSettingVersion("10.3"));
            }
            bl2 = true;
        }
        return bl2;
    }

    public Map getDomainsMap() throws ConfigException {
        long l;
        if (this.domainsFileEnabled && (l = this.domainsFile.lastModified()) != this.domainsFileModTime) {
            NMProperties nMProperties = new NMProperties();
            nmLog.info(nmText.getReloadingDomainsFile(this.domainsFile.toString()));
            try {
                nMProperties.load(this.domainsFile);
                this.domainsFileModTime = l;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                nmLog.warning(nmText.getInvalidDomainsFile(this.domainsFile.toString()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                nmLog.warning(nmText.getDomainsFileNotFound(this.domainsFile.toString()));
            }
            catch (IOException iOException) {
                nmLog.log(Level.WARNING, nmText.getErrorReadingDomainsFile(this.domainsFile.toString()), iOException);
            }
            this.loadDomainsProps(this.props, nMProperties);
            this.domainsMap = nMProperties;
            this.printDomainsMap(new PrintWriter((Writer)new OutputStreamWriter(System.err), true));
        }
        return this.domainsMap;
    }

    private void initDomainsMap() throws ConfigException {
        NMProperties nMProperties = new NMProperties();
        nmLog.info(nmText.getLoadingDomainsFile(this.domainsFile.toString()));
        try {
            long l = this.domainsFile.lastModified();
            nMProperties.load(this.domainsFile);
            this.domainsFileModTime = l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = nmText.getInvalidDomainsFile(this.domainsFile.toString());
            nmLog.severe(string);
            throw new ConfigException(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            nmLog.warning(nmText.getDomainsFileNotFound(this.domainsFile.toString()));
        }
        catch (IOException iOException) {
            String string = nmText.getErrorReadingDomainsFile(this.domainsFile.toString());
            nmLog.log(Level.SEVERE, string, iOException);
            throw new ConfigException(string, (Throwable)iOException);
        }
        this.loadDomainsProps(this.props, nMProperties);
        this.domainsMap = nMProperties;
    }

    private void loadDomainsProps(Properties properties, Map map) {
        for (String string : properties.keySet()) {
            if (!string.startsWith(DOMAIN_DIR_PROP)) continue;
            String string2 = properties.getProperty(string);
            map.put(string.substring(DOMAIN_DIR_PROP.length()), string2);
        }
    }

    public String getNMHome() {
        return this.nmHome;
    }

    public String getWeblogicHome() {
        return this.weblogicHome;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getListenBacklog() {
        return this.listenBacklog;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public boolean isSecureListener() {
        return this.secureListener;
    }

    public boolean isNativeVersionEnabled() {
        return this.nativeVersionEnabled;
    }

    public boolean isCrashRecoveryEnabled() {
        return this.crashRecoveryEnabled;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public boolean isStartScriptEnabled() {
        return this.startScriptEnabled;
    }

    public boolean isStopScriptEnabled() {
        return this.stopScriptEnabled;
    }

    public String getStartScriptName() {
        return this.startScriptName;
    }

    public String getStopScriptName() {
        return this.stopScriptName;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public Formatter getLogFormatter() {
        return this.logFormatter;
    }

    public ProcessControl getProcessControl() {
        return this.processControl;
    }

    public boolean getQuitEnabled() {
        return this.quitEnabled;
    }

    public int getStateCheckInterval() {
        return this.stateCheckInterval;
    }

    public NetworkInfo getNetworkInfoFor(String string) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        for (NetworkInfo networkInfo : this.getNetworkInfoList()) {
            if (!networkInfo.isNetworkInfoFor(inetAddress)) continue;
            return networkInfo;
        }
        throw new InvalidPropertiesFormatException("Missing an appropriate entry for " + string);
    }

    private List<NetworkInfo> getNetworkInfoList() throws IOException {
        if (this.networkInfoList.isEmpty()) {
            this.initNetworkInfoList();
        }
        return this.networkInfoList;
    }

    private void initNetworkInfoList() throws IOException {
        List<String> list = Arrays.asList(KNOWNPROPS);
        for (String string2 : this.props.keySet()) {
            if (list.contains(string2)) continue;
            try {
                this.networkInfoList.add(NetworkInfo.convertConfEntry(string2, this.props.getProperty(string2)));
            }
            catch (IOException iOException) {}
        }
        String string3 = this.getProperty(IF_INTERFACE_NAME);
        String string = this.getProperty(IF_NET_MASK_NAME);
        if (string3 != null) {
            if (string == null && Platform.isWindows()) {
                throw new InvalidPropertiesFormatException(nmText.missingNetMaskProp(string3));
            }
            this.networkInfoList.add(new NetworkInfo(string3, string));
        }
        if (this.networkInfoList.isEmpty()) {
            throw new InvalidPropertiesFormatException(nmText.missingSrvrMigProp());
        }
    }

    public NMProperties getConfigProperties() {
        NMProperties nMProperties = new NMProperties();
        nMProperties.setProperty(NM_HOME_PROP, this.nmHome);
        nMProperties.setProperty(LISTEN_ADDRESS_PROP, this.listenAddress != null ? this.listenAddress : "");
        nMProperties.setProperty(LISTEN_PORT_PROP, String.valueOf(this.listenPort));
        nMProperties.setProperty(LISTEN_BACKLOG_PROP, String.valueOf(this.listenBacklog));
        nMProperties.setProperty(SECURE_LISTENER_PROP, String.valueOf(this.secureListener));
        nMProperties.setProperty(AUTHENTICATION_ENABLED_PROP, String.valueOf(this.authenticationEnabled));
        nMProperties.setProperty(NATIVE_VERSION_ENABLED_PROP, String.valueOf(this.nativeVersionEnabled));
        nMProperties.setProperty(CRASH_RECOVERY_ENABLED_PROP, String.valueOf(this.crashRecoveryEnabled));
        nMProperties.setProperty(JAVA_HOME_PROP, this.javaHome);
        nMProperties.setProperty(START_SCRIPT_ENABLED_PROP, String.valueOf(this.startScriptEnabled));
        nMProperties.setProperty(STOP_SCRIPT_ENABLED_PROP, String.valueOf(this.stopScriptEnabled));
        nMProperties.setProperty(START_SCRIPT_NAME_PROP, this.startScriptName);
        if (this.stopScriptName != null) {
            nMProperties.setProperty(STOP_SCRIPT_NAME_PROP, this.stopScriptName);
        }
        nMProperties.setProperty(LOG_FILE_PROP, this.logFile);
        nMProperties.setProperty(LOG_LEVEL_PROP, String.valueOf(this.logLevel));
        nMProperties.setProperty(LOG_LIMIT_PROP, String.valueOf(this.logLimit));
        nMProperties.setProperty(LOG_COUNT_PROP, String.valueOf(this.logCount));
        nMProperties.setProperty(LOG_APPEND_PROP, String.valueOf(this.logAppend));
        nMProperties.setProperty(LOG_TO_STDERR_PROP, String.valueOf(this.logToStderr));
        nMProperties.setProperty(LOG_FORMATTER_PROP, this.logFormatter.getClass().getName());
        nMProperties.setProperty(DOMAINS_FILE_PROP, String.valueOf(this.domainsFile));
        nMProperties.setProperty(DOMAINS_FILE_ENABLED_PROP, String.valueOf(this.domainsFileEnabled));
        nMProperties.setProperty(QUIT_ENABLED_PROP, String.valueOf(this.quitEnabled));
        nMProperties.setProperty(STATE_CHECK_INTERVAL_PROP, String.valueOf(this.stateCheckInterval));
        try {
            for (NetworkInfo networkInfo : this.getNetworkInfoList()) {
                nMProperties.setProperty(networkInfo.getInterfaceName(), networkInfo.getPropertyValueString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        nMProperties.setProperty(DOMAIN_REGISTRATION_ENABLED_PROP, String.valueOf(this.domainRegistrationEnabled));
        nMProperties.setProperty(DOMAINDIRS_DIR_REMOTE_SHARING_ENABLED_PROP, String.valueOf(this.domainsDirRemoteSharingEnabled));
        return nMProperties;
    }

    public void print(PrintStream printStream) {
        this.print(new PrintWriter((Writer)new OutputStreamWriter(printStream), true));
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("Configuration settings:");
        printWriter.println();
        printWriter.println("NodeManagerHome=" + this.nmHome);
        printWriter.println("ListenAddress=" + (this.listenAddress != null ? this.listenAddress : ""));
        printWriter.println("ListenPort=" + this.listenPort);
        printWriter.println("ListenBacklog=" + this.listenBacklog);
        printWriter.println("SecureListener=" + this.secureListener);
        printWriter.println("AuthenticationEnabled=" + this.authenticationEnabled);
        printWriter.println("NativeVersionEnabled=" + this.nativeVersionEnabled);
        printWriter.println("CrashRecoveryEnabled=" + this.crashRecoveryEnabled);
        printWriter.println("JavaHome=" + this.javaHome);
        printWriter.println("StartScriptEnabled=" + this.startScriptEnabled);
        printWriter.println("StopScriptEnabled=" + this.stopScriptEnabled);
        printWriter.println("StartScriptName=" + this.startScriptName);
        printWriter.println("StopScriptName=" + (this.stopScriptName == null ? "" : this.stopScriptName));
        printWriter.println("LogFile=" + this.logFile);
        printWriter.println("LogLevel=" + this.logLevel);
        printWriter.println("LogLimit=" + this.logLimit);
        printWriter.println("LogCount=" + this.logCount);
        printWriter.println("LogAppend=" + this.logAppend);
        printWriter.println("LogToStderr=" + this.logToStderr);
        printWriter.println("LogFormatter=" + this.logFormatter.getClass().getName());
        printWriter.println("DomainsFile=" + this.domainsFile);
        printWriter.println("DomainsFileEnabled=" + this.domainsFileEnabled);
        printWriter.println("StateCheckInterval=" + this.stateCheckInterval);
        if (this.quitEnabled) {
            printWriter.println("QuitEnabled=" + this.quitEnabled);
        }
        try {
            for (NetworkInfo networkInfo : this.getNetworkInfoList()) {
                printWriter.println(networkInfo);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println("UseMACBroadcast=" + this.useMACBroadcast);
        printWriter.println("DomainRegistrationEnabled=" + this.domainRegistrationEnabled);
        printWriter.println("DomainsDirRemoteSharingEnabled=" + this.domainsDirRemoteSharingEnabled);
        printWriter.println();
        this.printDomainsMap(printWriter);
    }

    public void printDomainsMap(PrintWriter printWriter) {
        printWriter.println("Domain name mappings:");
        printWriter.println();
        for (Map.Entry entry : this.domainsMap.entrySet()) {
            printWriter.println(entry.getKey() + " -> " + entry.getValue());
        }
        printWriter.println();
    }

    public void initLogger(Logger logger) throws IOException {
        logger.setUseParentHandlers(true);
        logger.setLevel(this.logLevel);
        FileHandler fileHandler = new FileHandler(this.logFile, this.logLimit, this.logCount, this.logAppend);
        fileHandler.setFormatter(this.logFormatter);
        fileHandler.setLevel(this.logLevel);
        logger.addHandler(fileHandler);
        if (this.logToStderr) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(this.logFormatter);
            consoleHandler.setLevel(this.logLevel);
            logger.addHandler(consoleHandler);
        }
    }

    public String getIfConfigDir() {
        return this.ifConfigDir;
    }

    public long getExecScriptTimeout() {
        return this.execScriptTimeout;
    }

    public boolean useMACBroadcast() {
        return this.useMACBroadcast;
    }

    public boolean isDomainRegistrationEnabled() {
        return this.domainRegistrationEnabled;
    }

    public boolean isDomainsDirRemoteSharingEnabled() {
        return this.domainsDirRemoteSharingEnabled;
    }
}

