/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.InvalidPropertiesFormatException;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.utils.net.InetAddressHelper;

public class NetworkInfo {
    private InetAddress beginIPRange;
    private InetAddress endIPRange;
    private String interfaceName;
    private String netMask;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public NetworkInfo(String string, String string2, InetAddress inetAddress, InetAddress inetAddress2) {
        this.init(string, string2, inetAddress, inetAddress2);
    }

    public NetworkInfo(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, InetAddress inetAddress, InetAddress inetAddress2) {
        this.interfaceName = string;
        this.netMask = string2;
        this.beginIPRange = inetAddress;
        this.endIPRange = inetAddress2;
    }

    public boolean isNetworkInfoFor(InetAddress inetAddress) {
        return this.beginIPRange == null && this.endIPRange == null || NetworkInfo.isGreaterThanEqual(inetAddress, this.beginIPRange) && NetworkInfo.isGreaterThanEqual(this.endIPRange, inetAddress);
    }

    private static boolean isGreaterThanEqual(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray;
        if (InetAddressHelper.isIPV6Address((String)inetAddress.getHostAddress())) {
            return NetworkInfo.isGreaterThanEqualIPv6(inetAddress, inetAddress2);
        }
        byte[] byArray2 = inetAddress.getAddress();
        if (byArray2.length == (byArray = inetAddress2.getAddress()).length) {
            for (int i = 0; i < byArray2.length; ++i) {
                int n = byArray2[i] & 0xFF;
                int n2 = byArray[i] & 0xFF;
                if (n > n2 || i == byArray2.length - 1) {
                    return true;
                }
                if (n < n2) break;
            }
        }
        return false;
    }

    private static boolean isGreaterThanEqualIPv6(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray;
        byte[] byArray2 = inetAddress.getAddress();
        if (byArray2.length == (byArray = inetAddress2.getAddress()).length) {
            for (int i = 0; i < byArray2.length - 1; i += 2) {
                int n = ((byArray2[i] & 0xFF) << 8) + (byArray2[i + 1] & 0xFF);
                int n2 = ((byArray[i] & 0xFF) << 8) + (byArray[i + 1] & 0xFF);
                if (n > n2 || i == byArray2.length - 2) {
                    return true;
                }
                if (n < n2) break;
            }
        }
        return false;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getNetMask() {
        return this.netMask;
    }

    public static NetworkInfo convertConfEntry(String string, String string2) throws IOException {
        int n;
        Object object;
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        String string3 = null;
        String[] stringArray = string2.split(",");
        assert (stringArray.length < 2);
        if (stringArray.length > 2 || stringArray.length < 1) {
            throw new InvalidPropertiesFormatException(nmText.unknownIPRange(string2));
        }
        String string4 = stringArray[0].trim();
        if (!string4.equals("*")) {
            object = string4.split("-");
            if (((String[])object).length != 2) {
                throw new InvalidPropertiesFormatException(nmText.unknownIPRange(string2));
            }
            inetAddress = InetAddress.getByName(object[0]);
            inetAddress2 = InetAddress.getByName((String)object[1]);
            if (!NetworkInfo.isGreaterThanEqual(inetAddress2, inetAddress)) {
                inetAddress = InetAddress.getByName((String)object[1]);
                inetAddress2 = InetAddress.getByName((String)object[0]);
            }
        }
        if (stringArray.length == 2 && (n = ((String)(object = stringArray[1].trim())).indexOf("=")) > 0 && n < ((String)object).length() - 1) {
            string3 = ((String)object).substring(((String)object).indexOf("=") + 1);
            try {
                string3 = InetAddress.getByName(string3).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvalidPropertiesFormatException(nmText.invalidNetMask(string3, string2) + unknownHostException.toString());
            }
        }
        return new NetworkInfo(string, string3, inetAddress, inetAddress2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.interfaceName);
        stringBuffer.append("=");
        stringBuffer.append(this.getPropertyValueString());
        return stringBuffer.toString();
    }

    public String getPropertyValueString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.beginIPRange == null && this.endIPRange == null) {
            stringBuffer.append("*");
        } else if (this.beginIPRange != null && this.endIPRange != null) {
            stringBuffer.append(this.beginIPRange.getHostAddress());
            stringBuffer.append("-");
            stringBuffer.append(this.endIPRange.getHostAddress());
        }
        if (this.netMask != null) {
            stringBuffer.append(",NetMask=");
            stringBuffer.append(this.netMask);
        }
        return stringBuffer.toString();
    }
}

