/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.Config;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.server.Encryptor;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.Upgrader;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextWrapper;

class SSLConfig
extends Config {
    private String keyStores = "DemoIdentityAndDemoTrust";
    private String customIdentityKeyStoreFileName;
    private String customIdentityKeyStoreType;
    private String customIdentityKeyStorePassPhrase;
    private String customIdentityAlias;
    private String customIdentityPrivateKeyPassPhrase;
    private String cipherSuite;
    private String keyFile = "config/demokey.pm";
    private String keyPassword = "password";
    private String certificateFile = "config/democert.pm";
    private PrivateKey privateKey;
    private X509Certificate[] certChain;
    private Encryptor encryptor;
    public static final String KEY_STORES_PROP = "KeyStores";
    public static final String CUSTOM_IDENTITY_KEY_STORE_FILE_NAME_PROP = "CustomIdentityKeyStoreFileName";
    public static final String CUSTOM_IDENTITY_KEY_STORE_TYPE_PROP = "CustomIdentityKeyStoreType";
    public static final String CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP = "CustomIdentityKeyStorePassPhrase";
    public static final String CUSTOM_IDENTITY_ALIAS_PROP = "CustomIdentityAlias";
    public static final String CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP = "CustomIdentityPrivateKeyPassPhrase";
    public static final String CUSTOM_TRUST_KEY_STORE_PASS_PHRASE_PROP = "CustomTrustKeyStorePassPhrase";
    public static final String JAVA_STANDARD_TRUST_KEY_STORE_PASS_PHRASE_PROP = "JavaStandardTrustKeyStorePassPhrase";
    public static final String CIPHER_SUITE_PROP = "CipherSuite";
    public static final String KEY_FILE_PROP = "keyFile";
    public static final String KEY_PASSWORD_PROP = "keyPassword";
    public static final String CERTIFICATE_FILE_PROP = "certificateFile";
    public static final String DEMO_IDENTITY = "DemoIdentity";
    public static final String CUSTOM_IDENTITY = "CustomIdentity";
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public SSLConfig(Properties properties, Encryptor encryptor) throws IOException, ConfigException {
        super(properties);
        this.encryptor = encryptor;
        this.loadProperties();
        properties.remove(CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP);
        properties.remove(CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP);
        if (this.keyFile != null && this.keyPassword != null && this.certificateFile != null) {
            this.loadCompatibilityConfig();
        } else {
            this.loadKeyStoreConfig();
        }
    }

    private void loadProperties() {
        this.keyStores = this.getProperty(KEY_STORES_PROP, this.keyStores);
        if (DEMO_IDENTITY.equals(this.keyStores)) {
            this.keyStores = "DemoIdentityAndDemoTrust";
        } else if (CUSTOM_IDENTITY.equals(this.keyStores)) {
            this.keyStores = "CustomIdentityAndCustomTrust";
        }
        this.customIdentityKeyStoreFileName = this.getProperty(CUSTOM_IDENTITY_KEY_STORE_FILE_NAME_PROP);
        this.customIdentityKeyStoreType = this.getProperty(CUSTOM_IDENTITY_KEY_STORE_TYPE_PROP);
        this.customIdentityAlias = this.getProperty(CUSTOM_IDENTITY_ALIAS_PROP);
        this.customIdentityKeyStorePassPhrase = this.encryptor.encrypt(this.getProperty(CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP));
        this.customIdentityPrivateKeyPassPhrase = this.encryptor.encrypt(this.getProperty(CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP));
        this.cipherSuite = this.getProperty(CIPHER_SUITE_PROP);
        this.keyFile = this.getProperty(KEY_FILE_PROP);
        this.keyPassword = this.getProperty(KEY_PASSWORD_PROP);
        this.certificateFile = this.getProperty(CERTIFICATE_FILE_PROP);
    }

    private void loadKeyStoreConfig() throws IOException, ConfigException {
        Certificate[] certificateArray;
        FileInputStream fileInputStream;
        KeyStore keyStore;
        KeyStoreConfigurationHelper keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(new KeyStoreConfig());
        KeyStoreInfo keyStoreInfo = keyStoreConfigurationHelper.getIdentityKeyStore();
        NMServer.nmLog.info(nmText.getLoadingIDStore(keyStoreInfo.toString()));
        try {
            keyStore = KeyStore.getInstance(keyStoreInfo.getType());
        }
        catch (KeyStoreException keyStoreException) {
            throw new ConfigException(nmText.getUnknownIDStoreType(keyStoreInfo.getType().toString()));
        }
        try {
            fileInputStream = new FileInputStream(keyStoreInfo.getFileName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(nmText.getIDStoreNotFound(keyStoreInfo.getFileName()));
        }
        try {
            try {
                keyStore.load(fileInputStream, keyStoreInfo.getPassPhrase());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ConfigException(nmText.getIDAlgorithmNotFound(), (Throwable)noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new ConfigException(nmText.getCertificatesNotLoaded());
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        String string = keyStoreConfigurationHelper.getIdentityAlias();
        try {
            this.privateKey = (PrivateKey)keyStore.getKey(string, keyStoreConfigurationHelper.getIdentityPrivateKeyPassPhrase());
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ConfigException(nmText.getIncorrectIDPassword());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ConfigException(nmText.getIDAlgorithmNotFound(), (Throwable)noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalError("Identity key store not initialized");
        }
        if (this.privateKey == null) {
            throw new ConfigException(nmText.getUnknownKeyStoreID(string));
        }
        try {
            certificateArray = keyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(nmText.getIdentityStoreNotInit());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new ConfigException(nmText.getNoCertificate(string));
        }
        this.certChain = SSLCertUtility.toJavaX5092(certificateArray);
        if (this.certChain == null) {
            throw new ConfigException(nmText.getNoX509());
        }
    }

    private void loadCompatibilityConfig() throws IOException, ConfigException {
        FileInputStream fileInputStream;
        SSLContextWrapper sSLContextWrapper;
        try {
            sSLContextWrapper = SSLContextWrapper.getInstance();
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError("Could not instantiate SSLContextWrapper").initCause(exception);
        }
        try {
            fileInputStream = new FileInputStream(this.certificateFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(nmText.getCertificateFileNF(this.certificateFile.toString()));
        }
        try {
            try {
                this.certChain = sSLContextWrapper.inputCertChain(fileInputStream);
            }
            catch (KeyManagementException keyManagementException) {
                throw (ConfigException)new ConfigException(nmText.getInvalidCertFile(this.certificateFile.toString())).initCause((Throwable)keyManagementException);
            }
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        try {
            fileInputStream = new FileInputStream(this.keyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(nmText.getKeyFileNotFound(this.keyFile.toString()));
        }
        try {
            try {
                char[] cArray = null;
                if (this.keyPassword != null && this.keyPassword.length() > 0) {
                    cArray = this.keyPassword.toCharArray();
                }
                this.privateKey = sSLContextWrapper.inputPrivateKey(fileInputStream, cArray);
            }
            catch (KeyManagementException keyManagementException) {
                throw (ConfigException)new ConfigException(nmText.getInvalidKeyFile(this.keyFile.toString())).initCause((Throwable)keyManagementException);
            }
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public PrivateKey getIdentityPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate[] getIdentityCertificateChain() {
        return this.certChain;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public static boolean checkUpgrade(Properties properties, Encryptor encryptor, boolean bl) {
        boolean bl2 = false;
        String string = properties.getProperty(CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP);
        String string2 = properties.getProperty(CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP);
        String string3 = properties.getProperty(CUSTOM_TRUST_KEY_STORE_PASS_PHRASE_PROP);
        String string4 = properties.getProperty(JAVA_STANDARD_TRUST_KEY_STORE_PASS_PHRASE_PROP);
        String string5 = encryptor.encrypt(string);
        String string6 = encryptor.encrypt(string2);
        if (string != null && !string.equals(string5)) {
            properties.setProperty(CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP, string5);
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getEncryptingProp(CUSTOM_IDENTITY_KEY_STORE_PASS_PHRASE_PROP));
            }
            bl2 = true;
        }
        if (string2 != null && !string2.equals(string6)) {
            properties.setProperty(CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP, string6);
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getEncryptingProp(CUSTOM_IDENTITY_PRIVATE_KEY_PASS_PHRASE_PROP));
            }
            bl2 = true;
        }
        if (string3 != null) {
            properties.remove(CUSTOM_TRUST_KEY_STORE_PASS_PHRASE_PROP);
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getRemovingProp(CUSTOM_TRUST_KEY_STORE_PASS_PHRASE_PROP));
            }
            bl2 = true;
        }
        if (string4 != null) {
            properties.remove(JAVA_STANDARD_TRUST_KEY_STORE_PASS_PHRASE_PROP);
            if (bl) {
                Upgrader.log(Level.INFO, nmText.getRemovingProp(JAVA_STANDARD_TRUST_KEY_STORE_PASS_PHRASE_PROP));
            }
            bl2 = true;
        }
        return bl2;
    }

    private class KeyStoreConfig
    implements KeyStoreConfiguration {
        private KeyStoreConfig() {
        }

        public String getKeyStores() {
            return SSLConfig.this.keyStores;
        }

        public String getCustomIdentityKeyStoreFileName() {
            return SSLConfig.this.customIdentityKeyStoreFileName;
        }

        public String getCustomIdentityKeyStoreType() {
            return SSLConfig.this.customIdentityKeyStoreType;
        }

        public String getCustomIdentityKeyStorePassPhrase() {
            return SSLConfig.this.encryptor.decrypt(SSLConfig.this.customIdentityKeyStorePassPhrase);
        }

        public String getCustomIdentityAlias() {
            return SSLConfig.this.customIdentityAlias;
        }

        public String getCustomIdentityPrivateKeyPassPhrase() {
            return SSLConfig.this.encryptor.decrypt(SSLConfig.this.customIdentityPrivateKeyPassPhrase);
        }

        public String getCustomTrustKeyStoreFileName() {
            return null;
        }

        public String getCustomTrustKeyStoreType() {
            return null;
        }

        public String getCustomTrustKeyStorePassPhrase() {
            return null;
        }

        public String getJavaStandardTrustKeyStorePassPhrase() {
            return null;
        }

        public String getOutboundPrivateKeyAlias() {
            return null;
        }

        public String getOutboundPrivateKeyPassPhrase() {
            return null;
        }
    }
}

